/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.jgroups.util.Util;

public class NetworkUtilization {
    boolean sender = false;
    InetAddress mcast_addr;
    int mcast_port = 7500;
    long start;
    long stop;
    long num_received = 0L;
    int received_packet_size = 0;
    MulticastSocket mcast_sock = null;

    byte[] createBuffer(int size) {
        byte[] buf = new byte[size];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 46;
        }
        return buf;
    }

    public void start(boolean sender, int packet_size) throws Exception {
        this.sender = sender;
        this.mcast_addr = InetAddress.getByName("228.8.8.8");
        if (sender) {
            DatagramSocket sock = new DatagramSocket();
            byte[] buf = this.createBuffer(packet_size);
            System.out.println("-- starting to send packets");
            while (true) {
                DatagramPacket p = new DatagramPacket(buf, buf.length, this.mcast_addr, this.mcast_port);
                sock.send(p);
            }
        }
        Runtime.getRuntime().addShutdownHook(new MyTimer());
        byte[] buf = new byte[1000000];
        boolean first = true;
        DatagramPacket p = new DatagramPacket(buf, buf.length);
        this.mcast_sock = new MulticastSocket(this.mcast_port);
        this.mcast_sock.joinGroup(this.mcast_addr);
        System.out.println("-- joined group " + this.mcast_addr + ':' + this.mcast_port + ", waiting for packets\n" + "(press ctrl-c to kill)");
        while (true) {
            p.setData(buf);
            try {
                this.mcast_sock.receive(p);
            }
            catch (SocketException ex) {
                break;
            }
            if (first) {
                first = false;
                this.start = System.currentTimeMillis();
                this.received_packet_size = p.getLength();
            }
            ++this.num_received;
            if (this.num_received % 1000L != 0L) continue;
            System.out.println(this.num_received);
        }
    }

    public static void main(String[] args) {
        boolean sender = false;
        int packet_size = 10;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                NetworkUtilization.help();
                return;
            }
            if ("-sender".equals(args[i])) {
                sender = true;
                continue;
            }
            if ("-size".equals(args[i])) {
                packet_size = Integer.parseInt(args[++i]);
                continue;
            }
            NetworkUtilization.help();
            return;
        }
        try {
            new NetworkUtilization().start(sender, packet_size);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("NetworkUtilization [-help] [-sender] [-size <packet size in bytes>]");
    }

    class MyTimer
    extends Thread {
        MyTimer() {
        }

        public void run() {
            if (NetworkUtilization.this.mcast_sock != null) {
                NetworkUtilization.this.mcast_sock.close();
            }
            long stop = System.currentTimeMillis();
            long diff = stop - NetworkUtilization.this.start;
            double secs = (double)diff / 1000.0;
            double num_kb_received = (double)(NetworkUtilization.this.num_received * (long)NetworkUtilization.this.received_packet_size) / 1000.0;
            Util.sleep(200L);
            System.out.println("** took " + secs + " secs to receive " + NetworkUtilization.this.num_received + " msgs (" + (double)NetworkUtilization.this.num_received / secs + " msgs/sec)\n" + "** throughput: " + num_kb_received / secs + " KB/sec");
        }
    }
}

