/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.MessageConsumer;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.util.Daemon;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class HttpDebug {
    static HttpDebug httpd = null;
    static int port = 8090;
    HttpDebugMonitor[] monitors = null;
    ServerSocket listen = null;
    static boolean debug = true;
    DebugMonitor dmon = null;
    static Logger xlogmon = null;
    String host = null;
    String base = null;
    static final String CMD_HELP = "/HELP";
    static final String CMD_ADMIN = "/ADMIN";
    static final String CMD_AGENTS = "/ADMIN/AGENTS";
    static final String CMD_SERVERS = "/ADMIN/SERVERS";
    static final String CMD_MSG_CONS = "/ADMIN/MSGCONS";
    static final String CMD_SERVICES = "/ADMIN/SERVICES";
    static final String CMD_DUMP_AGENT = "/ADMIN/DUMP_AGENT";
    static final String CMD_DEBUG = "/DEBUG";
    static final String CMD_DEBUG_WAIT = "/XEBUGWAIT";
    static final String CMD_DEBUG_RUN = "/XEBUGRUN";
    static final String CMD_CLASS = "/CLASS";
    static final String CMD_STOP = "/STOP";
    static final String CMD_START = "/START";
    static final String CMD_QUEUE = "/QUEUE";
    static final String CMD_DUMP = "/DUMP";
    static final String CMD_REMOVE = "/REMOVE";
    static final String CMD_THREADS = "/THREADS";

    public static void init(String args, boolean firstTime) throws Exception {
        if (args.length() != 0) {
            try {
                port = Integer.parseInt(args);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        xlogmon = Debug.getLogger("fr.dyade.aaa.agent.Service.HttpDebug");
        if (httpd == null) {
            httpd = new HttpDebug(port);
        }
        HttpDebug.startService();
    }

    public static void startService() {
        for (int i = 0; i < HttpDebug.httpd.monitors.length; ++i) {
            HttpDebug.httpd.monitors[i].start();
        }
    }

    public static void stopService() {
        for (int i = 0; i < HttpDebug.httpd.monitors.length; ++i) {
            if (HttpDebug.httpd.monitors[i] == null) continue;
            HttpDebug.httpd.monitors[i].stop();
        }
        httpd = null;
    }

    private HttpDebug(int port) throws IOException {
        if (port != 0) {
            HttpDebug.port = port;
        }
        this.host = InetAddress.getLocalHost().getHostName();
        this.base = "http://" + this.host + ":" + port;
        this.listen = new ServerSocket(port);
        this.monitors = new HttpDebugMonitor[1];
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i] = new HttpDebugMonitor("HttpDebug#" + AgentServer.getServerId() + '.' + i);
        }
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(").append(super.toString());
        strBuf.append(",port=").append(port);
        strBuf.append(",monitors=[");
        for (int i = 0; i < this.monitors.length; ++i) {
            strBuf.append(this.monitors[i].toString()).append(",");
        }
        strBuf.append("]");
        strBuf.append(")");
        return strBuf.toString();
    }

    class DebugMonitor
    extends Daemon {
        ServerSocket server;
        int listen;

        public DebugMonitor() {
            super("DebugMonitor");
            this.server = null;
            this.listen = -1;
            this.logmon = xlogmon;
            try {
                this.server = new ServerSocket(0);
                this.listen = this.server.getLocalPort();
            }
            catch (IOException exc) {
                this.server = null;
                this.listen = -1;
            }
        }

        public void run() {
            Object socket = null;
            Object writer = null;
        }

        protected void close() {
        }

        protected void shutdown() {
        }
    }

    class HttpDebugMonitor
    extends Daemon {
        Socket socket;
        BufferedReader reader;
        PrintWriter writer;

        protected HttpDebugMonitor(String name) {
            super(name, xlogmon);
            this.socket = null;
            this.reader = null;
            this.writer = null;
            this.setThreadGroup(AgentServer.getThreadGroup());
        }

        public String toString() {
            return "(" + super.toString() + ",socket=" + this.socket + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    block30: {
                        this.canStop = true;
                        try {
                            this.socket = HttpDebug.this.listen.accept();
                            this.canStop = false;
                        }
                        catch (IOException exc) {
                            if (!this.running) break block30;
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during accept"), (Throwable)exc);
                        }
                    }
                    if (!this.running) {
                        break;
                    }
                    try {
                        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                        this.writer = new PrintWriter(this.socket.getOutputStream(), true);
                        this.doRequest(this.reader.readLine());
                        this.writer.flush();
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error during connection"), (Throwable)exc);
                    }
                    finally {
                        try {
                            this.reader.close();
                        }
                        catch (Exception exc) {}
                        this.reader = null;
                        try {
                            this.writer.close();
                        }
                        catch (Exception exc) {}
                        this.writer = null;
                        try {
                            this.socket.close();
                        }
                        catch (Exception exception) {}
                        this.socket = null;
                    }
                }
            }
            finally {
                this.finish();
            }
        }

        protected void close() {
            try {
                HttpDebug.this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            HttpDebug.this.listen = null;
        }

        protected void shutdown() {
            this.close();
        }

        void header(String title) throws IOException {
            this.writer.println("<HTML>");
            this.writer.println("<HEAD>");
            this.writer.println("   <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"/>");
            this.writer.println("<STYLE TYPE=\"text/css\">");
            this.writer.println("<!-- ");
            this.writer.println("  /* Style definitions */");
            this.writer.println("  H1 {font-family:Arial,Helvetica;font-weight:bold;font-size:36pt}");
            this.writer.println("  H2 {font-family:Arial,Helvetica;font-weight:bold;font-size:20pt}");
            this.writer.println("  H3 {font-family:Arial,Helvetica;font-weight:bold;font-size:16pt}");
            this.writer.println("  CODE {font-size:14}");
            this.writer.println("  .NORMAL {font-family:Arial,Helvetica;font-style:normal;font-size:14}");
            this.writer.println("  .BOTTOM {font-family:Arial,Helvetica;font-style:italic;font-size:10pt}");
            this.writer.println("  .FONT1 {font-family:Arial,Helvetica;font-weight:normal;font-size:18pt}");
            this.writer.println("  .FONT2 {font-family:Arial,Helvetica;font-weight:normal;font-size:14pt}");
            this.writer.println("  .FONT3 {font-family:Arial,Helvetica;font-weight:normal;font-size:12pt}");
            this.writer.println("  a:link {color:white}");
            this.writer.println("  a:visited{color:white}");
            this.writer.println("  a:active{color:white}");
            this.writer.println("-->");
            this.writer.println("</STYLE>");
            this.writer.println("<TITLE>" + title + "</TITLE>");
            this.writer.println("</HEAD>");
            this.writer.println("<BODY bgcolor=\"#CCCCCC\">");
            this.writer.println("<H1>" + title + "</H1>");
            this.writer.println("<HR WIDTH=\"100%\"/>");
        }

        void menu() throws IOException {
            this.writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" BGCOLOR=\"#3366FF\">");
            this.writer.println("<TR>");
            this.writer.println("<TD CLASS=FONT1><CENTER>");
            this.writer.println("<A href=\"" + HttpDebug.this.base + HttpDebug.CMD_SERVERS + "\">Servers</A>");
            this.writer.println("</CENTER></TD>");
            this.writer.println("<TD CLASS=FONT1><CENTER>");
            this.writer.println("<A href=\"" + HttpDebug.this.base + HttpDebug.CMD_AGENTS + "\">Agents</A>");
            this.writer.println("</CENTER></TD>");
            this.writer.println("<TD CLASS=FONT1><CENTER>");
            this.writer.println("<A href=\"" + HttpDebug.this.base + HttpDebug.CMD_MSG_CONS + "\">Consumers</A>");
            this.writer.println("</CENTER></TD>");
            this.writer.println("<TD CLASS=FONT1><CENTER>");
            this.writer.println("<A href=\"" + HttpDebug.this.base + HttpDebug.CMD_SERVICES + "\">Services</A>");
            this.writer.println("</CENTER></TD>");
            if (debug) {
                this.writer.println("<TD CLASS=FONT1><CENTER>");
                this.writer.println("<A href=\"" + HttpDebug.this.base + HttpDebug.CMD_THREADS + "\">Threads</A>");
                this.writer.println("</CENTER></TD>");
            }
            this.writer.println("</TR>");
            this.writer.println("</TABLE>");
            this.writer.println("<HR WIDTH=\"100%\"/>");
        }

        void error(Exception exc) throws IOException {
            this.writer.println("<H2>Error</H2>");
            this.writer.println("<BLOCKQUOTE><PRE>");
            exc.printStackTrace(this.writer);
            this.writer.println("</PRE></BLOCKQUOTE>");
        }

        void help() throws IOException {
            this.writer.println("<H2>Help</H2>");
            this.usage();
        }

        void unknown(String cmd) throws IOException {
            this.writer.println("<H2>Error</H2>");
            this.writer.println("<P CLASS=FONT2>");
            this.writer.println("Unknown command \"" + cmd + "\"");
            this.writer.println("</P>");
            this.usage();
        }

        void usage() throws IOException {
            this.writer.println("<H2>Usage</H2>");
            this.writer.println("<P CLASS=FONT2>");
            this.writer.println("To be provided.");
            this.writer.println("</P>");
        }

        void footer() throws IOException {
            this.writer.println("<HR WIDTH=\"100%\"/>");
            this.writer.println("<P CLASS=BOTTOM>");
            this.writer.println("Generated by fr.dyade.aaa.agent.HttpDebug, version 1.0, date:" + new Date().toString());
            this.writer.println("</P>");
            this.writer.println("</BODY>");
            this.writer.println("</HTML>");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRequest(String request) {
            block32: {
                String cmd = null;
                try {
                    StringTokenizer st = new StringTokenizer(request);
                    if (st.countTokens() < 2 || !st.nextToken().equals("GET")) break block32;
                    cmd = st.nextToken();
                    StringBuffer buf = new StringBuffer();
                    try {
                        if (cmd.equals("/") || cmd.equals(HttpDebug.CMD_HELP)) {
                            this.header("A3 AgentServer #" + AgentServer.getServerId());
                            this.menu();
                            this.help();
                        } else if (cmd.startsWith(HttpDebug.CMD_HELP)) {
                            this.header("A3 AgentServer #" + AgentServer.getServerId());
                        } else if (cmd.startsWith(HttpDebug.CMD_ADMIN)) {
                            this.header("A3 AgentServer #" + AgentServer.getServerId() + " Administration");
                            this.menu();
                            if (cmd.equals(HttpDebug.CMD_AGENTS)) {
                                this.listAgents(buf);
                            } else if (cmd.startsWith(HttpDebug.CMD_SERVERS)) {
                                this.listServers(cmd.substring(HttpDebug.CMD_SERVERS.length()), buf);
                                if (cmd.substring(HttpDebug.CMD_SERVERS.length()).startsWith(HttpDebug.CMD_STOP)) {
                                    AgentServer.stop(false);
                                }
                            } else if (cmd.startsWith(HttpDebug.CMD_MSG_CONS)) {
                                this.listConsumers(cmd.substring(HttpDebug.CMD_MSG_CONS.length()), buf);
                            } else if (cmd.startsWith(HttpDebug.CMD_SERVICES)) {
                                this.listServices(cmd.substring(HttpDebug.CMD_SERVICES.length()), buf);
                            } else if (cmd.startsWith(HttpDebug.CMD_DUMP_AGENT)) {
                                this.dumpAgent(cmd.substring(HttpDebug.CMD_DUMP_AGENT.length()), buf);
                            }
                        } else if (cmd.equals(HttpDebug.CMD_DEBUG_WAIT)) {
                            this.header("A3 AgentServer #" + AgentServer.getServerId());
                            this.writer.println("<H2>Debug Waiting</H2>");
                        } else if (cmd.equals(HttpDebug.CMD_DEBUG_RUN)) {
                            this.header("A3 AgentServer #" + AgentServer.getServerId());
                            this.writer.println("<H2>Debug Running</H2>");
                        } else if (cmd.startsWith(HttpDebug.CMD_DEBUG)) {
                            this.header("A3 AgentServer #" + AgentServer.getServerId() + " Debug Tool");
                            this.debug(cmd.substring(HttpDebug.CMD_DEBUG.length()), buf);
                        } else if (cmd.startsWith(HttpDebug.CMD_CLASS)) {
                            this.loadClass(cmd.substring(HttpDebug.CMD_CLASS.length()));
                        } else if (cmd.startsWith(HttpDebug.CMD_THREADS)) {
                            this.header("A3 AgentServer #" + AgentServer.getServerId());
                            this.menu();
                            this.listThread(cmd.substring(HttpDebug.CMD_THREADS.length()), buf);
                        } else {
                            this.unknown(cmd);
                        }
                        this.writer.println(buf.toString());
                    }
                    catch (Exception exc) {
                        this.error(exc);
                    }
                    this.footer();
                }
                catch (IOException exc) {
                    this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", error in \"" + cmd + "\""), (Throwable)exc);
                }
            }
        }

        void listThread(String cmd, StringBuffer buf) {
            String group = null;
            if (cmd.length() > 1 && cmd.charAt(0) == '/') {
                group = cmd.substring(1);
            }
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            int nbt = tg.activeCount();
            Thread[] tab = new Thread[nbt];
            nbt = tg.enumerate(tab);
            buf.append("<H2>List of threads</H2>\n");
            buf.append("<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\">\n");
            for (int j = 0; j < nbt; ++j) {
                if (tab[j] == null || group != null && !tab[j].getThreadGroup().getName().equals(group)) continue;
                buf.append("<TR><TD CLASS=FONT2><PRE>\n");
                buf.append("name=").append(tab[j].getName()).append("\n").append("group=").append(tab[j].getThreadGroup().getName()).append("\n").append("isAlive=").append(tab[j].isAlive()).append("\n").append("isDaemon=").append(tab[j].isDaemon()).append("\n");
                buf.append("</PRE></TD></TR>\n");
                buf.append("");
            }
            buf.append("</TABLE>");
        }

        void listAgents(StringBuffer buf) {
            buf.append("<H2>List of agents</H2>\n");
            buf.append("<PRE>\n");
            buf.append("now=" + AgentServer.engine.now + "\n");
            buf.append("NumberAgents=" + AgentServer.engine.agents.size() + "\n");
            buf.append("NbMaxAgents=" + AgentServer.engine.NbMaxAgents + "\n");
            buf.append("</PRE>\n");
            buf.append("<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\">\n");
            AgentId[] list = AgentServer.engine.getLoadedAgentIdlist();
            for (int i = 0; i < list.length; ++i) {
                Agent agent = (Agent)AgentServer.engine.agents.get(list[i]);
                buf.append("<TR>\n");
                buf.append("<TD CLASS=FONT1 WIDTH=\"20%\"><CENTER>\n");
                if (agent != null) {
                    buf.append(this.urlAgent(list[i]) + "\n");
                } else {
                    buf.append(list[i] + "\n");
                }
                buf.append("</CENTER></TD>\n");
                buf.append("<TD WIDTH=\"80%\"><PRE>\n");
                if (agent != null) {
                    buf.append("name=" + agent.name + "\n\n");
                    buf.append("\tclass=" + agent.getClass().getName() + "\n\n");
                    buf.append("fixed=" + agent.fixed + "\n");
                    buf.append("last=" + agent.last + "\n");
                }
                buf.append("</PRE></TD>\n");
                buf.append("</TR>\n");
            }
            buf.append("</TABLE>");
        }

        String urlServer(short serverId) {
            if (serverId == AgentServer.getServerId()) {
                return HttpDebug.this.base;
            }
            try {
                ServerDesc desc = AgentServer.getServerDesc(serverId);
                int port = Integer.parseInt(AgentServer.getServiceArgs(desc.sid, "fr.dyade.aaa.agent.HttpDebug"));
                if (desc.getHostname().equals("localhost")) {
                    return new String("http://" + InetAddress.getLocalHost().getHostName() + ":" + port);
                }
                return new String("http://" + desc.getHostname() + ":" + port);
            }
            catch (Exception exception) {
                return null;
            }
        }

        String urlAgent(AgentId id) {
            String url = this.urlServer(id.getTo());
            if (url == null) {
                return id.toString();
            }
            return new String("<A href=\"" + this.urlServer(id.getTo()) + HttpDebug.CMD_DUMP_AGENT + "/" + id.toString().substring(1) + "\">" + id + "</A>");
        }

        void listServers(String cmd, StringBuffer buf) {
            buf.append("<H2>List of servers</H2>\n");
            buf.append("<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0 WIDTH=\"100%\">\n");
            for (short i = 0; i < AgentServer.getServerNb(); i = (short)(i + 1)) {
                int port = -1;
                ServerDesc desc = null;
                try {
                    desc = AgentServer.getServerDesc(i);
                }
                catch (Exception exc) {
                    desc = null;
                }
                if (desc == null) continue;
                buf.append("<TR>\n");
                buf.append("<TD CLASS=FONT1 WIDTH=\"20%\" VALIGN=TOP>\n");
                String url = this.urlServer(desc.sid);
                if (url != null && i == AgentServer.getServerId() && cmd.startsWith(HttpDebug.CMD_STOP)) {
                    url = null;
                }
                if (url != null) {
                    buf.append("<A href=\"" + url + HttpDebug.CMD_SERVERS + "\">Server #" + desc.sid + "</A>\n");
                    buf.append("<BLOCKQUOTE><FONT CLASS=FONT3>\n");
                    buf.append("<P><A href=\"" + url + HttpDebug.CMD_AGENTS + "\">Agents</A>\n");
                    buf.append("<P><A href=\"" + url + HttpDebug.CMD_MSG_CONS + "\">Messages Consumers</A>\n");
                    buf.append("<P><A href=\"" + url + HttpDebug.CMD_SERVICES + "\">Services</A>\n");
                    buf.append("</FONT></BLOCKQUOTE>\n");
                } else {
                    buf.append("Server #" + desc.sid + "\n");
                }
                buf.append("</TD>\n<TD WIDTH=\"80%\" VALIGN=TOP>\n");
                if (url != null) {
                    buf.append("<BLOCKQUOTE><FORM ACTION=\"" + url + HttpDebug.CMD_SERVERS + HttpDebug.CMD_STOP + "\" METHOD=\"GET\">\n" + "<INPUT TYPE=\"submit\" VALUE=\"STOP\" NAME=\"A\">\n" + "</FORM></BLOCKQUOTE>\n");
                }
                buf.append("<PRE><CODE>\nname=" + desc.name + "\n");
                if (desc.gateway == desc.sid) {
                    buf.append("domain=<A href=\"" + HttpDebug.this.base + HttpDebug.CMD_MSG_CONS + "/" + desc.domain.getName() + "\">" + desc.domain.getName() + "</A>\n");
                    buf.append("hostname=" + desc.getHostname() + "\n");
                    buf.append("port=" + desc.getPort() + "\n");
                    if (desc.active) {
                        buf.append("active=" + desc.active + "\n");
                    } else {
                        buf.append("last=" + desc.last + "\n");
                        buf.append("retry=" + desc.retry);
                    }
                } else {
                    buf.append("gateway=#" + desc.gateway + "\n");
                }
                buf.append("</CODE></PRE></TD>\n");
                buf.append("</TR>\n");
            }
            buf.append("</TABLE>");
        }

        void listConsumers(String cmd, StringBuffer buf) {
            String msgConsId = null;
            int sub = -1;
            if (cmd.startsWith(HttpDebug.CMD_QUEUE)) {
                sub = 0;
                msgConsId = cmd.substring(HttpDebug.CMD_QUEUE.length() + 1);
            } else if (cmd.startsWith(HttpDebug.CMD_START)) {
                sub = 1;
                msgConsId = cmd.substring(HttpDebug.CMD_START.length() + 1);
            } else if (cmd.startsWith(HttpDebug.CMD_STOP)) {
                sub = 2;
                msgConsId = cmd.substring(HttpDebug.CMD_STOP.length() + 1);
            }
            buf.append("<H2>List of messages consumers</H2>\n");
            buf.append("<TABLE BORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"0\" WIDTH=\"100%\">\n");
            Enumeration c = AgentServer.getConsumers();
            while (c.hasMoreElements()) {
                MessageConsumer cons = (MessageConsumer)c.nextElement();
                buf.append("<TR>\n<TD CLASS=FONT1 VALIGN=\"TOP\" WIDTH=\"20%\">\n<CENTER>").append(cons.getName()).append("</CENTER>\n");
                buf.append("</TD>\n");
                buf.append("<TD WIDTH=\"80%\">");
                buf.append("<TABLE BORDER=\"1\" WIDTH=\"100%\"><TR><TD COLSPAN=\"3\">");
                if (msgConsId.equals(cons.getName())) {
                    if (sub == 1) {
                        try {
                            cons.start();
                        }
                        catch (Exception exc) {
                            buf.append("<TR><TD COLSPAN=\"3\"><PRE WIDTH=\"80\">");
                            buf.append(exc.toString()).append(" during starting.\n");
                            buf.append("</PRE></TD></TR>");
                        }
                    } else if (sub == 2) {
                        cons.stop();
                    }
                }
                buf.append(cons.getClass().getName());
                if (cons.isRunning()) {
                    buf.append(" is running.");
                } else {
                    buf.append(" is stopped.");
                }
                buf.append("</TD></TR><TR>");
                buf.append("<TD CLASS=FONT1 ALIGN=\"CENTER\" BGCOLOR=\"#3366FF\"><A href=\"").append(HttpDebug.this.base).append(HttpDebug.CMD_MSG_CONS).append("/STOP+").append(cons.getName()).append("\">STOP</A>\n").append("</TD>");
                buf.append("<TD CLASS=FONT1 ALIGN=\"CENTER\" BGCOLOR=\"#3366FF\"><A href=\"").append(HttpDebug.this.base).append(HttpDebug.CMD_MSG_CONS).append("/START+").append(cons.getName()).append("\">START</A>\n").append("</TD>");
                buf.append("<TD CLASS=FONT1 ALIGN=\"CENTER\" BGCOLOR=\"#3366FF\"><A href=\"").append(HttpDebug.this.base).append(HttpDebug.CMD_MSG_CONS).append("/QUEUE+").append(cons.getName()).append("\">QUEUE</A>\n").append("</TD>");
                buf.append("</TR><TR><TD COLSPAN=\"3\">");
                buf.append("<PRE WIDTH=\"80\">\n");
                buf.append(cons.toString());
                buf.append("</PRE>");
                buf.append("</TD></TR>");
                if (msgConsId.equals(cons.getName()) && sub == 0 && cons.getQueue().size() > 0) {
                    buf.append("<TR><TD COLSPAN=\"3\"><PRE WIDTH=\"80\">");
                    this.dumpQueue(buf, cons.getQueue().toString().toCharArray());
                    buf.append("</PRE></TD></TR>");
                }
                buf.append("</TABLE>");
                buf.append("</TD>");
                buf.append("</TR>\n");
            }
            buf.append("</TABLE>");
        }

        void dumpQueue(StringBuffer buf, char[] dump) {
            try {
                int idx = 0;
                if (dump[idx++] != '(') {
                    throw new IllegalArgumentException();
                }
                while (true) {
                    if (dump[idx++] != '(') {
                        throw new IllegalArgumentException();
                    }
                    while (dump[idx] != '=') {
                        buf.append(dump[idx++]);
                    }
                    buf.append(dump[idx++]);
                    if (dump[idx] != '#') {
                        throw new IllegalArgumentException();
                    }
                    AgentId id = null;
                    int j = this.dumpAgentId(dump, idx);
                    if (j != -1) {
                        id = AgentId.fromString(new String(dump, idx, j - idx));
                    }
                    if (id == null) {
                        throw new IllegalArgumentException();
                    }
                    buf.append(this.urlAgent(id));
                    idx = j;
                    while (dump[idx] != '=') {
                        buf.append(dump[idx++]);
                    }
                    buf.append(dump[idx++]);
                    if (dump[idx] != '#') {
                        throw new IllegalArgumentException();
                    }
                    id = null;
                    j = this.dumpAgentId(dump, idx);
                    if (j != -1) {
                        id = AgentId.fromString(new String(dump, idx, j - idx));
                    }
                    if (id == null) {
                        throw new IllegalArgumentException();
                    }
                    buf.append(this.urlAgent(id));
                    idx = j;
                    if (dump[idx] != ',') {
                        throw new IllegalArgumentException();
                    }
                    buf.append('\n');
                    ++idx;
                    while (dump[idx] != '=') {
                        buf.append(dump[idx++]);
                    }
                    buf.append(dump[idx++]);
                    if (dump[idx++] != '[') {
                        throw new IllegalArgumentException();
                    }
                    while (dump[idx] != ']') {
                        if (dump[idx] == '#') {
                            id = null;
                            j = this.dumpAgentId(dump, idx);
                            if (j != -1) {
                                id = AgentId.fromString(new String(dump, idx, j - idx));
                            }
                            if (id != null) {
                                buf.append(this.urlAgent(id));
                                idx = j;
                            }
                        }
                        buf.append(dump[idx++]);
                    }
                    ++idx;
                    if (dump[++idx] != ',') {
                        throw new IllegalArgumentException();
                    }
                    buf.append('\n');
                    ++idx;
                    while (dump[idx] != '=') {
                        buf.append(dump[idx++]);
                    }
                    buf.append(dump[idx++]);
                    if (dump[idx++] != '[') {
                        throw new IllegalArgumentException();
                    }
                    while (dump[idx] != ']') {
                        buf.append(dump[idx++]);
                    }
                    if (dump[++idx] != ')') {
                        if (dump[idx] != ',') {
                            throw new IllegalArgumentException();
                        }
                        buf.append('\n');
                        ++idx;
                        while (dump[idx] != ')') {
                            buf.append(dump[idx++]);
                        }
                    }
                    if (dump[++idx] != ')') {
                        buf.append("\n<hr>");
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        void listServices(String cmd, StringBuffer buf) {
            int sub = -1;
            String sclass = null;
            if (cmd.startsWith(HttpDebug.CMD_START)) {
                sub = 1;
                sclass = cmd.substring(HttpDebug.CMD_START.length() + 1);
            } else if (cmd.startsWith(HttpDebug.CMD_STOP)) {
                sub = 2;
                sclass = cmd.substring(HttpDebug.CMD_STOP.length() + 1);
            } else if (cmd.startsWith(HttpDebug.CMD_REMOVE)) {
                sub = 3;
                sclass = cmd.substring(HttpDebug.CMD_REMOVE.length() + 1);
            }
            buf.append("<H2>List of services</H2>\n");
            buf.append("<TABLE BORDER=\"1\" WIDTH=\"100%\">\n");
            if (sub == 3) {
                buf.append("<TR><TD><PRE>");
                try {
                    ServiceManager.stop(sclass);
                    buf.append("\nService <").append(sclass).append("> stopped.");
                }
                catch (Exception exc) {
                    buf.append("\nCan't stop service \"").append(sclass).append("\" :\n\t").append(exc.getMessage());
                }
                try {
                    ServiceManager.unregister(sclass);
                    buf.append("\nService <").append(sclass).append("> unregistred.");
                }
                catch (Exception exc) {
                    buf.append("\nCan't unregister service \"").append(sclass).append("\" :\n\t").append(exc.getMessage());
                }
                buf.append("</PRE></TD></TR>\n");
            }
            ServiceDesc[] services = ServiceManager.getServices();
            for (int i = 0; i < services.length; ++i) {
                buf.append("<TABLE BORDER=\"1\" WIDTH=\"100%\">\n");
                buf.append("<TR><TD CLASS=FONT1 VALIGN=\"TOP\" COLSPAN=\"2\">").append(services[i].getClassName());
                if (services[i].getClassName().equals(sclass)) {
                    if (sub == 1) {
                        try {
                            ServiceManager.start(sclass);
                        }
                        catch (Exception exc) {
                            buf.append("<PRE>\nCan't start service: \n\t").append(exc.getMessage()).append("</PRE>");
                        }
                    } else if (sub == 2) {
                        try {
                            ServiceManager.stop(sclass);
                        }
                        catch (Exception exc) {
                            buf.append("<PRE>\nCan't stop service: \n\t").append(exc.getMessage()).append("</PRE>");
                        }
                    }
                }
                buf.append("</TD></TR>");
                buf.append("<TR><TD ROWSPAN=\"2\" WIDTH=\"70%\"><PRE>").append("\narguments=").append(services[i].getArguments()).append("\ninitialized=").append(services[i].isInitialized()).append("\nrunning=").append(services[i].isRunning()).append("</PRE></TD>\n");
                buf.append("<TD CLASS=FONT1 ALIGN=\"CENTER\" BGCOLOR=\"#3366FF\">").append("<A href=\"").append(HttpDebug.this.base).append(HttpDebug.CMD_SERVICES);
                if (services[i].isRunning()) {
                    buf.append("/STOP+").append(services[i].getClassName()).append("\">STOP</A>\n");
                } else {
                    buf.append("/START+").append(services[i].getClassName()).append("\">START</A>\n");
                }
                buf.append("</TD></TR>\n");
                buf.append("<TR><TD CLASS=FONT1 ALIGN=\"CENTER\" BGCOLOR=\"#3366FF\">").append("<A href=\"").append(HttpDebug.this.base).append(HttpDebug.CMD_SERVICES).append("/REMOVE+").append(services[i].getClassName()).append("\">REMOVE</A>\n").append("</TD></TR>\n");
                buf.append("</TABLE>");
            }
            buf.append("</TABLE>");
        }

        int dumpAgentId(char[] dump, int idx) {
            int j;
            if (dump[idx] != '#') {
                return -1;
            }
            for (j = idx + 1; j < dump.length && dump[j] >= '0' && dump[j] <= '9'; ++j) {
            }
            if (j == idx + 1 || dump[j] != '.' || j == dump.length) {
                return -1;
            }
            idx = j++;
            while (j < dump.length && dump[j] >= '0' && dump[j] <= '9') {
                ++j;
            }
            if (j == idx + 1 || dump[j] != '.' || j == dump.length) {
                return -1;
            }
            idx = j++;
            while (j < dump.length && dump[j] >= '0' && dump[j] <= '9') {
                ++j;
            }
            if (j == idx + 1) {
                return -1;
            }
            return j;
        }

        void dumpAgent(String cmd, StringBuffer buf) {
            AgentId id = null;
            try {
                if (cmd.charAt(0) != '/') {
                    throw new IllegalArgumentException();
                }
                id = AgentId.fromString(new String("#" + cmd.substring(1)));
                if (id == null) {
                    throw new IllegalArgumentException();
                }
            }
            catch (IllegalArgumentException exc) {
                buf.append("<H2>Error</H2>\n<P>\nCan't parse AgentId #x.y.z in \"" + cmd + "\"\n" + "</P>\n");
                return;
            }
            buf.append("<H2>Dump agent " + id + "</H2>\n");
            Agent agent = (Agent)AgentServer.engine.agents.get(id);
            if (agent == null) {
                buf.append("<P CLASS=FONT2>\nAgent not loaded in memory.\n</P>\n");
                return;
            }
            try {
                char[] dump = agent.toString().toCharArray();
                for (int i = 0; i < dump.length; ++i) {
                    if (dump[i] == '(') {
                        buf.append("<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0>\n");
                        buf.append("<TR><TD CLASS=FONT1><PRE>\n");
                        continue;
                    }
                    if (dump[i] == ',') {
                        buf.append("\n");
                        continue;
                    }
                    if (dump[i] == ')') {
                        buf.append("</PRE></TD></TR>\n");
                        buf.append("</TABLE>");
                        continue;
                    }
                    if (dump[i] == '#') {
                        id = null;
                        int j = this.dumpAgentId(dump, i);
                        if (j != -1) {
                            id = AgentId.fromString(new String(dump, i, j - i));
                        }
                        if (id == null) {
                            buf.append(dump[i]);
                            continue;
                        }
                        buf.append(this.urlAgent(id));
                        i = j - 1;
                        continue;
                    }
                    buf.append(dump[i]);
                }
            }
            catch (IllegalArgumentException exc) {
                buf.setLength(0);
                buf.append("<H2>Error</H2>\n<P>\nCan't parse AgentId #x.y.z in \"" + cmd + "\"\n" + "</P>\n");
                return;
            }
        }

        void debug(String cmd, StringBuffer buf) {
            ServerSocket server = null;
            int listen = -1;
            buf.append("<H2>Debug Tool</H2>\n");
            try {
                server = new ServerSocket(0);
            }
            catch (IOException exc) {
                buf.append(exc.toString()).append(" during connection.\n");
                return;
            }
            listen = server.getLocalPort();
            buf.append("<APPLET CODE=\"AppletDebug.class\" CODEBASE=\"").append(HttpDebug.CMD_CLASS).append("\" WIDTH=\"800\" HEIGHT=\"200\">\n").append("<PARAM NAME=\"host\" VALUE=\"").append(HttpDebug.this.host).append("\"/>\n").append("<PARAM NAME=\"port\" VALUE=\"").append(listen).append("\"/>\n").append("<PARAM NAME=\"url\" VALUE=\"").append(HttpDebug.this.base).append(HttpDebug.CMD_DEBUG_WAIT).append("\"/>\n").append("</APPLET>\n");
            buf.append("<IFRAME name=\"debug\" src=\"").append(HttpDebug.CMD_DEBUG_WAIT).append("\" width=\"800\" height=\"400\" scrolling=\"auto\" frameborder=\"1\">\n").append("Your browser does not support internal frames (HTML 4.0)\n.").append("</IFRAME>\n");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadClass(String cmd) {
            BufferedOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(this.socket.getOutputStream());
                File file = new File(cmd.substring(1));
                byte[] c = new byte[(int)file.length()];
                new FileInputStream(file).read(c);
                bos.write(c, 0, c.length);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
            finally {
                try {
                    bos.flush();
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

