/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Path
extends DataType
implements Cloneable {
    private Vector elements;
    public static Path systemClasspath = new Path(null, System.getProperty("java.class.path"));
    public static Path systemBootClasspath = new Path(null, System.getProperty("sun.boot.class.path"));

    public Path(Project p, String path) {
        this(p);
        this.createPathElement().setPath(path);
    }

    public Path(Project project) {
        this.setProject(project);
        this.elements = new Vector();
    }

    public void setLocation(File location) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setLocation(location);
    }

    public void setPath(String path) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setPath(path);
    }

    public void setRefid(Reference r) throws BuildException {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        this.elements.addElement(r);
        super.setRefid(r);
    }

    public PathElement createPathElement() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PathElement pe = new PathElement();
        this.elements.addElement(pe);
        return pe;
    }

    public void addFileset(FileSet fs) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(fs);
        this.setChecked(false);
    }

    public void addFilelist(FileList fl) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(fl);
        this.setChecked(false);
    }

    public void addDirset(DirSet dset) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(dset);
        this.setChecked(false);
    }

    public void add(Path path) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(path);
        this.setChecked(false);
    }

    public Path createPath() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Path p = new Path(this.getProject());
        this.elements.addElement(p);
        this.setChecked(false);
        return p;
    }

    public void append(Path other) {
        if (other == null) {
            return;
        }
        String[] l = other.list();
        int i = 0;
        while (i < l.length) {
            if (this.elements.indexOf(l[i]) == -1) {
                this.elements.addElement(l[i]);
            }
            ++i;
        }
    }

    public void addExisting(Path source) {
        this.addExisting(source, false);
    }

    public void addExisting(Path source, boolean tryUserDir) {
        String[] list = source.list();
        File userDir = tryUserDir ? new File(System.getProperty("user.dir")) : null;
        int i = 0;
        while (i < list.length) {
            File f = null;
            f = this.getProject() != null ? this.getProject().resolveFile(list[i]) : new File(list[i]);
            if (tryUserDir && !f.exists()) {
                f = new File(userDir, list[i]);
            }
            if (f.exists()) {
                this.setLocation(f);
            } else {
                this.log("dropping " + f + " from path as it doesn't exist", 3);
            }
            ++i;
        }
    }

    public String[] list() {
        if (!this.isChecked()) {
            Stack<Path> stk = new Stack<Path>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.getProject());
        }
        Vector result = new Vector(2 * this.elements.size());
        int i = 0;
        while (i < this.elements.size()) {
            Reference r;
            Object o = this.elements.elementAt(i);
            if (o instanceof Reference && !((o = (r = (Reference)o).getReferencedObject(this.getProject())) instanceof Path)) {
                String msg = r.getRefId() + " doesn't denote a path " + o;
                throw new BuildException(msg);
            }
            if (o instanceof String) {
                Path.addUnlessPresent(result, (String)o);
            } else if (o instanceof PathElement) {
                String[] parts = ((PathElement)o).getParts();
                if (parts == null) {
                    throw new BuildException("You must either set location or path on <pathelement>");
                }
                int j = 0;
                while (j < parts.length) {
                    Path.addUnlessPresent(result, parts[j]);
                    ++j;
                }
            } else if (o instanceof Path) {
                Path p = (Path)o;
                if (p.getProject() == null) {
                    p.setProject(this.getProject());
                }
                String[] parts = p.list();
                int j = 0;
                while (j < parts.length) {
                    Path.addUnlessPresent(result, parts[j]);
                    ++j;
                }
            } else if (o instanceof DirSet) {
                DirSet dset = (DirSet)o;
                Path.addUnlessPresent(result, dset.getDir(this.getProject()), dset.getDirectoryScanner(this.getProject()).getIncludedDirectories());
            } else if (o instanceof FileSet) {
                FileSet fs = (FileSet)o;
                Path.addUnlessPresent(result, fs.getDir(this.getProject()), fs.getDirectoryScanner(this.getProject()).getIncludedFiles());
            } else if (o instanceof FileList) {
                FileList fl = (FileList)o;
                Path.addUnlessPresent(result, fl.getDir(this.getProject()), fl.getFiles(this.getProject()));
            }
            ++i;
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public String toString() {
        String[] list = this.list();
        if (list.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(list[0].toString());
        int i = 1;
        while (i < list.length) {
            result.append(File.pathSeparatorChar);
            result.append(list[i]);
            ++i;
        }
        return result.toString();
    }

    public static String[] translatePath(Project project, String source) {
        Vector<String> result = new Vector<String>();
        if (source == null) {
            return new String[0];
        }
        PathTokenizer tok = new PathTokenizer(source);
        StringBuffer element = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String pathElement = tok.nextToken();
            try {
                element.append(Path.resolveFile(project, pathElement));
            }
            catch (BuildException e) {
                project.log("Dropping path element " + pathElement + " as it is not valid relative to the project", 3);
            }
            int i = 0;
            while (i < element.length()) {
                Path.translateFileSep(element, i);
                ++i;
            }
            result.addElement(element.toString());
            element = new StringBuffer();
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public static String translateFile(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(source);
        int i = 0;
        while (i < result.length()) {
            Path.translateFileSep(result, i);
            ++i;
        }
        return result.toString();
    }

    protected static boolean translateFileSep(StringBuffer buffer, int pos) {
        if (buffer.charAt(pos) == '/' || buffer.charAt(pos) == '\\') {
            buffer.setCharAt(pos, File.separatorChar);
            return true;
        }
        return false;
    }

    public int size() {
        return this.list().length;
    }

    public Object clone() {
        try {
            Path p = (Path)super.clone();
            p.elements = (Vector)this.elements.clone();
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    protected void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        Enumeration e = this.elements.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Reference) {
                o = ((Reference)o).getReferencedObject(p);
            }
            if (!(o instanceof DataType)) continue;
            if (stk.contains(o)) {
                throw this.circularReference();
            }
            stk.push(o);
            ((DataType)o).dieOnCircularReference(stk, p);
            stk.pop();
        }
        this.setChecked(true);
    }

    private static String resolveFile(Project project, String relativeName) {
        if (project != null) {
            File f = project.resolveFile(relativeName);
            return f.getAbsolutePath();
        }
        return relativeName;
    }

    private static void addUnlessPresent(Vector v, String s) {
        if (v.indexOf(s) == -1) {
            v.addElement(s);
        }
    }

    private static void addUnlessPresent(Vector v, File dir2, String[] s) {
        int j = 0;
        while (j < s.length) {
            File d = new File(dir2, s[j]);
            String absolutePath = d.getAbsolutePath();
            Path.addUnlessPresent(v, Path.translateFile(absolutePath));
            ++j;
        }
    }

    public Path concatSystemClasspath() {
        return this.concatSystemClasspath("last");
    }

    public Path concatSystemClasspath(String defValue) {
        String o;
        Path result = new Path(this.getProject());
        String order = defValue;
        if (this.getProject() != null && (o = this.getProject().getProperty("build.sysclasspath")) != null) {
            order = o;
        }
        if (order.equals("only")) {
            result.addExisting(systemClasspath, true);
        } else if (order.equals("first")) {
            result.addExisting(systemClasspath, true);
            result.addExisting(this);
        } else if (order.equals("ignore")) {
            result.addExisting(this);
        } else {
            if (!order.equals("last")) {
                this.log("invalid value for build.sysclasspath: " + order, 1);
            }
            result.addExisting(this);
            result.addExisting(systemClasspath, true);
        }
        return result;
    }

    public void addJavaRuntime() {
        if ("Kaffe".equals(System.getProperty("java.vm.name"))) {
            File kaffeShare = new File(System.getProperty("java.home") + File.separator + "share" + File.separator + "kaffe");
            if (kaffeShare.isDirectory()) {
                FileSet kaffeJarFiles = new FileSet();
                kaffeJarFiles.setDir(kaffeShare);
                kaffeJarFiles.setIncludes("*.jar");
                this.addFileset(kaffeJarFiles);
            }
        } else if ("GNU libgcj".equals(System.getProperty("java.vm.name"))) {
            this.addExisting(systemBootClasspath);
        }
        if (System.getProperty("java.vendor").toLowerCase(Locale.US).indexOf("microsoft") >= 0) {
            FileSet msZipFiles = new FileSet();
            msZipFiles.setDir(new File(System.getProperty("java.home") + File.separator + "Packages"));
            msZipFiles.setIncludes("*.ZIP");
            this.addFileset(msZipFiles);
        } else if (JavaEnvUtils.isJavaVersion("1.1")) {
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "classes.zip"));
        } else {
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
            String[] secJars = new String[]{"jce", "jsse"};
            int i = 0;
            while (i < secJars.length) {
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + secJars[i] + ".jar"));
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + secJars[i] + ".jar"));
                ++i;
            }
            String[] ibmJars = new String[]{"core", "graphics", "security", "server", "xml"};
            int i2 = 0;
            while (i2 < ibmJars.length) {
                this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + ibmJars[i2] + ".jar"));
                ++i2;
            }
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "classes.jar"));
            this.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "ui.jar"));
        }
    }

    public void addExtdirs(Path extdirs) {
        if (extdirs == null) {
            String extProp = System.getProperty("java.ext.dirs");
            if (extProp != null) {
                extdirs = new Path(this.getProject(), extProp);
            } else {
                return;
            }
        }
        String[] dirs = extdirs.list();
        int i = 0;
        while (i < dirs.length) {
            File dir2 = this.getProject().resolveFile(dirs[i]);
            if (dir2.exists() && dir2.isDirectory()) {
                FileSet fs = new FileSet();
                fs.setDir(dir2);
                fs.setIncludes("*");
                this.addFileset(fs);
            }
            ++i;
        }
    }

    public class PathElement {
        private String[] parts;

        public void setLocation(File loc) {
            this.parts = new String[]{Path.translateFile(loc.getAbsolutePath())};
        }

        public void setPath(String path) {
            this.parts = Path.translatePath(Path.this.getProject(), path);
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

