/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;

public class WSS4JHandler
extends WSHandler
implements Handler {
    private HandlerInfo handlerInfo;
    static Log log = LogFactory.getLog((class$org$apache$ws$security$handler$WSS4JHandler == null ? (class$org$apache$ws$security$handler$WSS4JHandler = WSS4JHandler.class$("org.apache.ws.security.handler.WSS4JHandler")) : class$org$apache$ws$security$handler$WSS4JHandler).getName());
    private boolean doDebug = false;
    static final String DEPLOYMENT = "deployment";
    static final String CLIENT_DEPLOYMENT = "client";
    static final String SERVER_DEPLOYMENT = "server";
    static final String FLOW = "flow";
    static final String REQUEST_ONLY = "request-only";
    static final String RESPONSE_ONLY = "response-only";
    static final String ALLOW_FORM_OPTIMIZATION = "axis.form.optimization";
    static /* synthetic */ Class class$org$apache$ws$security$handler$WSS4JHandler;

    public void init(HandlerInfo hi) {
        this.handlerInfo = hi;
    }

    public void destroy() {
    }

    public QName[] getHeaders() {
        return this.handlerInfo.getHeaders();
    }

    public boolean handleRequest(MessageContext mc) {
        mc.setProperty(ALLOW_FORM_OPTIMIZATION, Boolean.TRUE);
        try {
            return this.processMessage(mc, true);
        }
        catch (WSSecurityException e) {
            throw new JAXRPCException(e);
        }
    }

    public boolean handleResponse(MessageContext mc) {
        mc.setProperty(ALLOW_FORM_OPTIMIZATION, Boolean.TRUE);
        try {
            return this.processMessage(mc, false);
        }
        catch (WSSecurityException e) {
            throw new JAXRPCException(e);
        }
    }

    public boolean handleFault(MessageContext mc) {
        if (this.doDebug) {
            log.debug("Entered handleFault");
        }
        return true;
    }

    public boolean processMessage(MessageContext mc, boolean isRequestMessage) throws WSSecurityException {
        boolean needsHandling;
        RequestData reqData = new RequestData();
        reqData.setMsgContext(mc);
        this.doDebug = log.isDebugEnabled();
        String deployment = null;
        String handleFlow = null;
        deployment = (String)this.getOption(DEPLOYMENT);
        if (deployment == null) {
            deployment = (String)mc.getProperty(DEPLOYMENT);
        }
        if (deployment == null) {
            throw new JAXRPCException("WSS4JHandler.processMessage: No deployment defined");
        }
        handleFlow = (String)this.getOption(FLOW);
        if (handleFlow == null) {
            handleFlow = (String)mc.getProperty(FLOW);
        }
        if (handleFlow == null) {
            handleFlow = "";
        }
        boolean bl = needsHandling = isRequestMessage && !handleFlow.equals(RESPONSE_ONLY) || !isRequestMessage && !handleFlow.equals(REQUEST_ONLY);
        if (deployment.equals(CLIENT_DEPLOYMENT) ^ isRequestMessage) {
            if (needsHandling) {
                return this.doReceiver(mc, reqData);
            }
        } else if (needsHandling) {
            return this.doSender(mc, reqData);
        }
        return true;
    }

    public boolean doSender(MessageContext mc, RequestData reqData) throws WSSecurityException {
        reqData.getSignatureParts().removeAllElements();
        reqData.getEncryptParts().removeAllElements();
        reqData.setNoSerialization(false);
        Vector actions2 = new Vector();
        String action = (String)this.getOption("send.action");
        if (action == null && (action = (String)this.getOption("action")) == null) {
            action = (String)mc.getProperty("action");
        }
        if (action == null) {
            throw new JAXRPCException("WSS4JHandler: No action defined");
        }
        int doAction = WSSecurityUtil.decodeAction(action, actions2);
        if (doAction == 0) {
            return true;
        }
        reqData.setUsername((String)this.getOption("user"));
        if (reqData.getUsername() == null || reqData.getUsername().equals("")) {
            reqData.setUsername((String)mc.getProperty("user"));
            mc.setProperty("user", null);
        }
        if ((doAction & 0x43) != 0 && (reqData.getUsername() == null || reqData.getUsername().equals(""))) {
            throw new JAXRPCException("WSS4JHandler: Empty username for specified action");
        }
        if (this.doDebug) {
            log.debug("Action: " + doAction);
            log.debug("Actor: " + reqData.getActor());
        }
        Document doc = null;
        SOAPMessage message = ((SOAPMessageContext)mc).getMessage();
        Boolean propFormOptimization = (Boolean)mc.getProperty(ALLOW_FORM_OPTIMIZATION);
        log.debug("Form optimzation: " + propFormOptimization);
        SOAPPart sPart = message.getSOAPPart();
        doc = (Document)mc.getProperty("SND_SECURTIY");
        if (doc == null) {
            try {
                doc = WSS4JHandler.messageToDocument(message);
            }
            catch (Exception e) {
                throw new JAXRPCException("WSS4JHandler: cannot get SOAP envlope from message" + e);
            }
        }
        if (this.doDebug) {
            log.debug("WSS4JHandler: orginal SOAP request: ");
            log.debug(org.apache.ws.security.util.XMLUtils.PrettyDocumentToString(doc));
        }
        this.doSenderAction(doAction, doc, reqData, actions2);
        if (reqData.isNoSerialization()) {
            mc.setProperty("SND_SECURTIY", doc);
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM(doc, os, true);
            if (this.doDebug) {
                String osStr = null;
                try {
                    osStr = os.toString("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    osStr = os.toString();
                }
                log.debug("Send request:");
                log.debug(osStr);
            }
            try {
                sPart.setContent(new StreamSource(new ByteArrayInputStream(os.toByteArray())));
            }
            catch (SOAPException se) {
                throw new JAXRPCException("Couldn't set content on SOAPPart" + se.getMessage());
            }
            mc.setProperty("SND_SECURTIY", null);
        }
        if (this.doDebug) {
            log.debug("WSS4JHandler: exit invoke()");
        }
        return true;
    }

    public boolean doReceiver(MessageContext mc, RequestData reqData) throws WSSecurityException {
        Timestamp timestamp;
        X509Certificate returnCert;
        Vector actions2 = new Vector();
        String action = (String)this.getOption("receive.action");
        if (action == null && (action = (String)this.getOption("action")) == null) {
            action = (String)mc.getProperty("action");
        }
        if (action == null) {
            throw new JAXRPCException("WSS4JHandler: No action defined");
        }
        int doAction = WSSecurityUtil.decodeAction(action, actions2);
        String actor = (String)this.getOption("actor");
        SOAPMessage message = ((SOAPMessageContext)mc).getMessage();
        SOAPPart sPart = message.getSOAPPart();
        Document doc = null;
        try {
            doc = WSS4JHandler.messageToDocument(message);
        }
        catch (Exception ex) {
            throw new JAXRPCException("WSS4JHandler: cannot convert into document", ex);
        }
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        if (WSSecurityUtil.findElement(doc.getDocumentElement(), "Fault", soapConstants.getEnvelopeURI()) != null) {
            return false;
        }
        CallbackHandler cbHandler = null;
        if ((doAction & 5) != 0) {
            cbHandler = this.getPasswordCB(reqData);
        }
        if ((doAction & 2) == 2) {
            this.decodeSignatureParameter2(reqData);
        }
        if ((doAction & 4) == 4) {
            this.decodeDecryptionParameter(reqData);
        }
        Vector wsResult = null;
        try {
            wsResult = secEngine.processSecurityHeader(doc, actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
        }
        catch (WSSecurityException ex) {
            ex.printStackTrace();
            throw new JAXRPCException("WSS4JHandler: security processing failed", ex);
        }
        if (wsResult == null) {
            if (doAction == 0) {
                return true;
            }
            throw new JAXRPCException("WSS4JHandler: Request does not contain required Security header");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLUtils.outputDOM(doc, os, true);
        try {
            sPart.setContent(new StreamSource(new ByteArrayInputStream(os.toByteArray())));
        }
        catch (SOAPException se) {
            throw new JAXRPCException("Couldn't set content on SOAPPart" + se.getMessage());
        }
        if (this.doDebug) {
            log.debug("Processed received SOAP request");
        }
        SOAPHeader sHeader = null;
        try {
            sHeader = message.getSOAPPart().getEnvelope().getHeader();
        }
        catch (Exception ex) {
            throw new JAXRPCException("WSS4JHandler: cannot get SOAP header after security processing", ex);
        }
        Iterator headers = sHeader.examineHeaderElements(actor);
        SOAPHeaderElement headerElement = null;
        while (headers.hasNext()) {
            SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
            if (!hE.getElementName().getLocalName().equals("Security") || !hE.getNamespaceURI().equals(WSConstants.WSSE_NS)) continue;
            headerElement = hE;
            break;
        }
        headerElement.setMustUnderstand(false);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(wsResult, 2);
        if (actionResult != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert, reqData)) {
            throw new JAXRPCException("WSS4JHandler: The certificate used for the signature is not trusted");
        }
        actionResult = WSSecurityUtil.fetchActionResult(wsResult, 32);
        if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
            throw new JAXRPCException("WSS4JHandler: The timestamp could not be validated");
        }
        int resultActions = wsResult.size();
        int size = actions2.size();
        if (size != resultActions) {
            throw new JAXRPCException("WSS4JHandler: security processing failed (actions number mismatch)");
        }
        for (int i = 0; i < size; ++i) {
            if (((Integer)actions2.get(i)).intValue() == ((WSSecurityEngineResult)wsResult.get(i)).getAction()) continue;
            throw new JAXRPCException("WSS4JHandler: security processing failed (actions mismatch)");
        }
        Vector<WSHandlerResult> results = null;
        results = (Vector<WSHandlerResult>)mc.getProperty("RECV_RESULTS");
        if (results == null) {
            results = new Vector<WSHandlerResult>();
            mc.setProperty("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
        if (this.doDebug) {
            log.debug("WSS4JHandler: exit invoke()");
        }
        return true;
    }

    public static Document messageToDocument(SOAPMessage message) {
        try {
            Source content = message.getSOAPPart().getContent();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(org.apache.ws.security.util.XMLUtils.sourceToInputSource(content));
        }
        catch (Exception ex) {
            throw new JAXRPCException("messageToDocument: cannot convert SOAPMessage into Document", ex);
        }
    }

    public Object getOption(String key) {
        return this.handlerInfo.getHandlerConfig().get(key);
    }

    public Object getProperty(Object msgContext, String key) {
        return ((MessageContext)msgContext).getProperty(key);
    }

    public String getPassword(Object msgContext) {
        return (String)((MessageContext)msgContext).getProperty("javax.xml.rpc.security.auth.password");
    }

    public void setPassword(Object msgContext, String password) {
        ((MessageContext)msgContext).setProperty("javax.xml.rpc.security.auth.password", password);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

