/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.InboundConsumer;
import org.objectweb.util.monolog.api.BasicLevel;

class InboundSession
implements ServerSession,
Work,
MessageListener {
    private InboundConsumer consumer;
    private WorkManager workManager;
    private MessageEndpointFactory endpointFactory;
    private Session session;
    private XAResource xaResource = null;

    InboundSession(InboundConsumer consumer, WorkManager workManager, MessageEndpointFactory endpointFactory, XAConnection cnx, boolean transacted, int ackMode) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("InboundSession(" + consumer + "," + workManager + "," + endpointFactory + "," + cnx + "," + transacted + "," + ackMode + ")"));
        }
        this.consumer = consumer;
        this.workManager = workManager;
        this.endpointFactory = endpointFactory;
        try {
            if (transacted) {
                this.session = cnx.createXASession();
                this.xaResource = ((XASession)this.session).getXAResource();
                if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                    AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("InboundSession xaResource = " + this.xaResource));
                }
            } else {
                this.session = cnx.createSession(false, ackMode);
            }
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("InboundSession session = " + this.session));
            }
            this.session.setMessageListener(this);
        }
        catch (JMSException exc) {
            // empty catch block
        }
    }

    public Session getSession() throws JMSException {
        return this.session;
    }

    public void start() throws JMSException {
        try {
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)"ServerSession submits Work instance.");
            }
            this.workManager.scheduleWork(this);
        }
        catch (Exception exc) {
            throw new JMSException("Can't start the adapter session for processing the delivered messages: " + exc);
        }
    }

    public void release() {
        try {
            this.session.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void run() {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)"ServerSession runs wrapped Session.");
        }
        this.session.run();
        this.consumer.releaseSession(this);
    }

    public void onMessage(Message message) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " onMessage(" + message + ")"));
        }
        MessageEndpoint endpoint = null;
        try {
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)"ServerSession passes message to listener.");
            }
            endpoint = this.endpointFactory.createEndpoint(this.xaResource);
            ((MessageListener)((Object)endpoint)).onMessage(message);
            endpoint.release();
        }
        catch (Exception exc) {
            try {
                if (endpoint != null) {
                    endpoint.release();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new IllegalStateException("Could not get endpoint instance: " + exc);
        }
    }
}

