/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.facility.naming.polymorphid;

import org.objectweb.jorm.api.PAccessor;
import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PBindingCtrl;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionNoDSI;
import org.objectweb.jorm.api.PExceptionProtocol;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.api.PStateGraph;
import org.objectweb.jorm.facility.naming.generator.LongGen;
import org.objectweb.jorm.facility.naming.polymorphid.ClassIdAccessor;
import org.objectweb.jorm.facility.naming.polymorphid.IdClassAccessor;
import org.objectweb.jorm.facility.naming.polymorphid.PolymorphIdBinder;
import org.objectweb.jorm.facility.naming.polymorphid.PolymorphIdMgr;
import org.objectweb.jorm.facility.naming.polymorphid.PolymorphIdPName;
import org.objectweb.jorm.naming.api.PExceptionExistingName;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.perseus.cache.api.CacheEntry;
import org.objectweb.perseus.cache.api.CacheException;
import org.objectweb.perseus.cache.api.CacheManager;

public class PolymorphIdBinderInfo
extends PolymorphIdBinder
implements PAccessor,
ClassIdAccessor,
IdClassAccessor {
    public static final String CLASSIDN = "org.objectweb.jorm.facility.naming.polymorphid.ClassId";
    public static final String IDCLASSN = "org.objectweb.jorm.facility.naming.polymorphid.IdClass";
    Long classId;
    String className;
    private PolymorphIdMgr mgr;
    private LongGen objectIdGen;

    void init(PMapper m, String cn, PolymorphIdMgr mgr) throws PException {
        Object conn = mgr.getPMapper().getConnection();
        try {
            this.init(m, cn, mgr, conn);
        }
        catch (PException e) {
            throw e;
        }
        finally {
            mgr.getPMapper().closeConnection(conn);
        }
    }

    void init(PMapper m, String cn, PolymorphIdMgr mgr, Object conn) throws PException {
        this.mgr = mgr;
        this.className = cn;
        PClassMapping pcm = m.lookup(CLASSIDN);
        PBinding binding = pcm.createPBinding();
        this.objectIdGen = mgr.getLongGenMgr().getLongGen(this.className);
        binding.bind(pcm.getPBinder().decodeString(this.className));
        Object connection = conn;
        if (connection == null) {
            connection = mgr.getPMapper().getConnection();
        }
        try {
            binding.read(connection, this);
        }
        catch (PExceptionNoDSI e) {
            binding.export(connection, this.className);
            this.classId = new Long(mgr.newClassId(connection));
            binding.write(connection, this);
            PClassMapping pcm2 = m.lookup(IDCLASSN);
            PBinding binding2 = pcm2.createPBinding();
            binding2.bind(pcm2.getPBinder().decodeLong(this.classId));
            if (!binding2.exist(connection)) {
                binding2.export(connection, this.classId);
                binding2.write(connection, this);
            }
            binding2.unbind();
        }
        binding.unbind();
    }

    void init(PMapper m, long id, PolymorphIdMgr mgr, Object conn) throws PException {
        Object connection = conn;
        if (connection == null) {
            connection = mgr.getPMapper().getConnection();
        }
        try {
            this.mgr = mgr;
            PClassMapping pcm = m.lookup(IDCLASSN);
            PBinding binding = pcm.createPBinding();
            binding.bind(pcm.getPBinder().decodeLong(id));
            try {
                binding.read(connection, this);
            }
            catch (PExceptionNoDSI e) {
                throw new PExceptionNaming(e, "The binder " + id + " does not exist");
            }
            finally {
                binding.unbind();
            }
            this.objectIdGen = mgr.getLongGenMgr().getLongGen(this.className);
        }
        catch (PException e) {
            throw e;
        }
        finally {
            mgr.getPMapper().closeConnection(connection);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setPType(PType pt) {
        super.setPType(pt);
        this.mgr.binderTypeDef(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PName export(Object conn, Object binding) throws PException {
        PBindingCtrl pb = (PBindingCtrl)binding;
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)3);
        if (nextstate == 5) {
            throw new PExceptionProtocol("Unauthorized operation");
        }
        PolymorphIdPName res = new PolymorphIdPName(this.classId, this.objectIdGen.genId(conn), this);
        if (this.cache != null) {
            CacheManager cacheManager = this.cache;
            synchronized (cacheManager) {
                if (this.cache.lookup(res) != null) {
                    throw new PExceptionExistingName("[" + this.getClassName() + "]: an object has been already export with the same identifier");
                }
                try {
                    CacheEntry ce = this.cache.bind(res, binding);
                    this.cache.fix(ce);
                }
                catch (CacheException e) {
                    throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                }
            }
        }
        pb.setPName(res);
        pb.setStatus(nextstate);
        return res;
    }

    public PName export(Object conn, Object binding, Object ctxt) throws PException {
        throw new PExceptionNaming("Supports only auto-generated names (no need of a user context).");
    }

    public Object getMemoryInstance() {
        return this;
    }

    public void paSetClassId(long val) throws PException {
        this.classId = new Long(val);
    }

    public long paGetClassId() throws PException {
        return this.classId;
    }

    public void paSetClassName(String val) throws PException {
        this.className = val;
    }

    public String paGetClassName() throws PException {
        return this.className;
    }
}

