/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.filter.postfix;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.BinaryArithmeticOperator;
import org.objectweb.medor.expression.api.BinaryLogicalOperator;
import org.objectweb.medor.expression.api.BinaryOperator;
import org.objectweb.medor.expression.api.Comparator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.api.UnaryArithmeticOperator;
import org.objectweb.medor.expression.api.UnaryLogicalOperator;
import org.objectweb.medor.expression.api.UnaryOperator;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicOperator;
import org.objectweb.medor.expression.lib.FirstLocate;
import org.objectweb.medor.expression.lib.IndexedLocate;
import org.objectweb.medor.expression.lib.Length;
import org.objectweb.medor.expression.lib.Not;
import org.objectweb.medor.expression.lib.Sqrt;
import org.objectweb.medor.filter.api.BelongOperator;
import org.objectweb.medor.filter.api.ExpressionHelper;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;

public class PostfixExpressionHelper
implements ExpressionHelper {
    int MAX_OPERAND_ON_OPERATOR = 3;

    public Expression[] toStack(Expression e) throws ExpressionException, TypingException {
        return this.toStack(e, new ArrayList()).toArray(new Expression[0]);
    }

    public Expression join(Expression[] stack) throws ExpressionException, TypingException {
        Expression[] temp = new Expression[this.MAX_OPERAND_ON_OPERATOR];
        int operandIdx = 0;
        for (int i = stack.length; i >= 0; --i) {
            if (stack[i] instanceof Operand) {
                if (operandIdx == this.MAX_OPERAND_ON_OPERATOR) {
                    throw new ExpressionException("Malformed stack: too many operand:" + (operandIdx + 1));
                }
                temp[operandIdx] = stack[i];
                ++operandIdx;
                continue;
            }
            if (stack[i] instanceof Operator) {
                Operator op = (Operator)stack[i];
                if (operandIdx != op.getOperandNumber()) {
                    throw new ExpressionException("Malformed stack: wrong operand number:" + stack[i]);
                }
                int j = 0;
                while (i < op.getOperandNumber()) {
                    op.setExpression(j, temp[j]);
                    ++i;
                }
                temp[0] = op;
                operandIdx = 1;
                continue;
            }
            throw new ExpressionException("Malformed stack: Unknown expression element: " + stack[i]);
        }
        return temp[0];
    }

    public Expression substituteParameters(ParameterOperand[] pos, Expression e) throws ExpressionException, TypingException {
        if (e instanceof ParameterOperand) {
            ParameterOperand p = (ParameterOperand)e;
            for (int j = 0; j < pos.length; ++j) {
                if (!pos[j].getName().equalsIgnoreCase(p.getName())) continue;
                return pos[j];
            }
            throw new ExpressionException("Parameter not defined");
        }
        if (e instanceof Operator) {
            Operator op = (Operator)e;
            for (int i = 0; i < op.getOperandNumber(); ++i) {
                op.setExpression(i, this.substituteParameters(pos, op.getExpression(i)));
            }
            return op;
        }
        return e;
    }

    public Expression[] substituteParameters(ParameterOperand[] pos, Expression[] stack) throws ExpressionException, TypingException {
        for (int i = 0; i < stack.length; ++i) {
            int j;
            if (!(stack[i] instanceof ParameterOperand)) continue;
            ParameterOperand p = (ParameterOperand)stack[i];
            for (j = 0; j < pos.length; ++j) {
                if (!pos[j].getName().equalsIgnoreCase(p.getName())) continue;
                stack[i] = pos[j];
                break;
            }
            if (j != pos.length) continue;
            throw new ExpressionException("Parameter not defined");
        }
        return stack;
    }

    public void fixIndexes(QueryNode node, Expression e) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Operand evaluate(Expression[] stack, ParameterOperand[] parameters, Tuple t) throws MedorException, ExpressionException, IllegalStateException {
        try {
            Stack<Expression> expressionResult = new Stack<Expression>();
            for (int cpt = 0; cpt < stack.length; ++cpt) {
                PType type;
                BasicOperator locate;
                Operand ve1;
                Operand ve2;
                if (stack[cpt] instanceof Operand) {
                    stack[cpt].evaluate(parameters, t);
                    expressionResult.push(stack[cpt]);
                    continue;
                }
                if (!(stack[cpt] instanceof Operator)) continue;
                VariableOperand vop = (VariableOperand)stack[cpt].compileExpression();
                if (((Operator)stack[cpt]).getOperandNumber() == 3) {
                    Operand ve3 = (Operand)expressionResult.pop();
                    ve2 = (Operand)expressionResult.pop();
                    ve1 = (Operand)expressionResult.pop();
                    if (!(stack[cpt] instanceof IndexedLocate)) throw new MedorException("Unknown Expression element");
                    locate = (IndexedLocate)stack[cpt];
                    vop.setValue(((IndexedLocate)locate).evaluate(ve1.getString(), ve2.getString(), ve3.getInt()));
                } else if (stack[cpt] instanceof BinaryOperator) {
                    ve2 = (Operand)expressionResult.pop();
                    ve1 = (Operand)expressionResult.pop();
                    if (stack[cpt] instanceof Comparator) {
                        Comparator c = (Comparator)stack[cpt];
                        type = stack[cpt].getType();
                        switch (type.getTypeCode()) {
                            case 4: 
                            case 12: {
                                vop.setValue(c.evaluate(ve1.getInt(), ve2.getInt()));
                                break;
                            }
                            case 3: 
                            case 11: {
                                vop.setValue(c.evaluate((int)ve1.getShort(), ve2.getShort()));
                                break;
                            }
                            case 2: 
                            case 10: {
                                vop.setValue(c.evaluate((int)ve1.getByte(), (short)ve2.getByte()));
                                break;
                            }
                            case 5: 
                            case 13: {
                                vop.setValue(c.evaluate(ve1.getLong(), ve2.getLong()));
                                break;
                            }
                            case 7: 
                            case 15: {
                                vop.setValue(c.evaluate(ve1.getDouble(), ve2.getDouble()));
                                break;
                            }
                            case 6: 
                            case 14: {
                                vop.setValue(c.evaluate(ve1.getFloat(), ve2.getFloat()));
                                break;
                            }
                            case 16: {
                                vop.setValue(c.evaluate(ve1.getString(), ve2.getString()));
                                break;
                            }
                            case 1: 
                            case 9: {
                                vop.setValue(c.evaluate(ve1.getChar(), ve2.getChar()));
                                break;
                            }
                            case 17: {
                                vop.setValue(c.evaluate(ve1.getDate(), (Object)ve2.getDate()));
                            }
                        }
                    } else if (stack[cpt] instanceof BinaryLogicalOperator) {
                        BinaryLogicalOperator bLogicop = (BinaryLogicalOperator)stack[cpt];
                        boolean result = bLogicop.evaluate(ve1.getBoolean(), ve2.getBoolean());
                        vop.setValue(result);
                    } else if (stack[cpt] instanceof BinaryArithmeticOperator) {
                        BinaryArithmeticOperator bAritOp = (BinaryArithmeticOperator)stack[cpt];
                        type = bAritOp.getType();
                        switch (type.getTypeCode()) {
                            case 4: 
                            case 12: {
                                vop.setValue(bAritOp.evaluate(ve1.getInt(), ve2.getInt()));
                                break;
                            }
                            case 3: 
                            case 11: {
                                vop.setValue(bAritOp.evaluate((int)ve1.getShort(), ve2.getShort()));
                                break;
                            }
                            case 2: 
                            case 10: {
                                vop.setValue(bAritOp.evaluate((int)ve1.getByte(), (short)ve2.getByte()));
                                break;
                            }
                            case 5: 
                            case 13: {
                                vop.setValue(bAritOp.evaluate(ve1.getLong(), ve2.getLong()));
                                break;
                            }
                            case 7: 
                            case 15: {
                                vop.setValue(bAritOp.evaluate(ve1.getDouble(), ve2.getDouble()));
                                break;
                            }
                            case 6: 
                            case 14: {
                                vop.setValue(bAritOp.evaluate(ve1.getFloat(), ve2.getFloat()));
                                break;
                            }
                            case 16: {
                                vop.setValue(bAritOp.evaluate(ve1.getString(), ve2.getString()));
                                break;
                            }
                            case 1: 
                            case 9: {
                                vop.setValue(bAritOp.evaluate(ve1.getChar(), ve2.getChar()));
                                break;
                            }
                            case 17: {
                                vop.setValue(bAritOp.evaluate(ve1.getDate(), ve2.getDate()));
                            }
                        }
                    } else if (stack[cpt] instanceof BelongOperator) {
                        BelongOperator in = (BelongOperator)stack[cpt];
                        vop.setValue(in.evaluate((Tuple)ve1.getObject(), (TupleCollection)ve2.getObject()));
                    } else {
                        if (!(stack[cpt] instanceof FirstLocate)) throw new MedorException("Uknowen Expression element");
                        locate = (FirstLocate)stack[cpt];
                        vop.setValue(((FirstLocate)locate).evaluate(ve1.getString(), ve2.getString()));
                    }
                    ++cpt;
                } else {
                    if (!(stack[cpt] instanceof UnaryOperator)) throw new MedorException("Unknown Expression element");
                    ve1 = (Operand)expressionResult.pop();
                    if (stack[cpt] instanceof UnaryArithmeticOperator) {
                        UnaryArithmeticOperator uAritOp = (UnaryArithmeticOperator)stack[cpt];
                        type = uAritOp.getType();
                        switch (type.getTypeCode()) {
                            case 4: 
                            case 12: {
                                vop.setValue(uAritOp.evaluate(ve1.getInt()));
                                break;
                            }
                            case 3: 
                            case 11: {
                                vop.setValue(uAritOp.evaluate(ve1.getShort()));
                                break;
                            }
                            case 2: 
                            case 10: {
                                vop.setValue(uAritOp.evaluate(ve1.getByte()));
                                break;
                            }
                            case 5: 
                            case 13: {
                                vop.setValue(uAritOp.evaluate(ve1.getLong()));
                                break;
                            }
                            case 7: 
                            case 15: {
                                vop.setValue(uAritOp.evaluate(ve1.getDouble()));
                                break;
                            }
                            case 6: 
                            case 14: {
                                vop.setValue(uAritOp.evaluate(ve1.getFloat()));
                            }
                        }
                    } else if (stack[cpt] instanceof UnaryLogicalOperator) {
                        Not notop = (Not)stack[cpt];
                        vop.setValue(notop.evaluate(ve1.getBoolean()));
                    } else if (stack[cpt] instanceof Sqrt) {
                        Sqrt sqrt = (Sqrt)stack[cpt];
                        vop.setValue(sqrt.evaluate(ve1.getDouble()));
                    } else {
                        if (!(stack[cpt] instanceof Length)) throw new MedorException("Unknown Expression element");
                        Length length = (Length)stack[cpt];
                        vop.setValue(length.evaluate(ve1.getString()));
                    }
                }
                expressionResult.push(vop);
            }
            return (Operand)expressionResult.pop();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Expression Error: may be not Compiled");
        }
    }

    public ArrayList toStack(Expression e, ArrayList al) throws ExpressionException, TypingException {
        if (e instanceof Operator) {
            for (int i = 0; i < ((Operator)e).getOperandNumber(); ++i) {
                this.toStack(((Operator)e).getExpression(i), al);
            }
        } else if (!(e instanceof Operand)) {
            throw new ExpressionException("Malformed stack: Unknown expression element: " + e);
        }
        al.add(e);
        return al;
    }

    public int getNumberOfNode(Expression e) throws ExpressionException {
        if (e instanceof Operand) {
            return 1;
        }
        if (e instanceof Operator) {
            int result = 1;
            for (int i = 0; i < ((Operator)e).getOperandNumber(); ++i) {
                result += this.getNumberOfNode(((Operator)e).getExpression(i));
            }
            return result;
        }
        throw new ExpressionException("Malformed stack: Unknown expression element: " + e);
    }

    public boolean verifyNoNull(Expression e) {
        if (e instanceof Operator) {
            boolean res = true;
            for (int i = 0; i < ((Operator)e).getOperandNumber() && res; ++i) {
                res = this.verifyNoNull(((Operator)e).getExpression(i));
            }
            return res;
        }
        return e != null;
    }

    public String[] getParameterNames(Expression e) throws ExpressionException, TypingException {
        LinkedList<String> nameList = new LinkedList<String>();
        Expression[] stack = this.toStack(e);
        for (int i = 0; i < stack.length; ++i) {
            if (!(stack[i] instanceof ParameterOperand)) continue;
            nameList.add(((ParameterOperand)stack[i]).getName());
        }
        return nameList.toArray(new String[nameList.size()]);
    }
}

