/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.util.Properties;
import java.util.StringTokenizer;

public final class CarolDefaultValues {
    public static final String CAROL_DEFAULT_CONFIGURATION_FILE = "carol-defaults.properties";
    public static final String CAROL_CONFIGURATION_FILE = "carol.properties";
    public static final String CAROL_PREFIX = "carol";
    public static final String SERVER_MODE = "carol.server.mode";
    public static final String SETTER_CLASS = "setter.class";
    public static final String SETTER_METHOD_PROPERTIES = "setter.methodProperties";
    public static final String SETTER_METHOD_MBEAN = "setter.methodMBean";
    public static final String SERVER_IIOP_PORT = "carol.iiop.server.port";
    public static final String SERVER_IRMI_PORT = "carol.irmi.server.port";
    public static final String SERVER_IRMI_SINGLE_ITF = "carol.irmi.interfaces.bind.single";
    public static final String SERVER_JRMP_PORT = "carol.jrmp.server.port";
    public static final String SERVER_JRMP_SINGLE_ITF = "carol.jrmp.interfaces.bind.single";
    public static final String SERVER_SSL_IIOP_PORT = "carol.iiop.server.sslport";
    public static final int DEFAULT_SSL_PORT = 2003;
    public static final String DEFAULT_HOST = "localhost";
    public static final String JNDI_PREFIX = "jndi";
    public static final String JVM_PREFIX = "jvm";
    public static final String NS_PREFIX = "NameServiceClass";
    public static final String PRO_PREFIX = "PortableRemoteObjectClass";
    public static final String URL_PREFIX = "url";
    public static final String LOCAL_JRMP_PROPERTY = "rmi.local.call";
    public static final String LOCALREG_JRMP_PROPERTY = "rmi.local.registry";
    public static final String FACTORY_PREFIX = "context.factory";
    public static final String START_NS_PREFIX = "start.ns";
    public static final String START_NS_KEY = "carol.start.ns";
    public static final String START_RMI_KEY = "carol.start.rmi";
    public static final String START_JNDI_KEY = "carol.start.jndi";
    public static final String START_CMI_KEY = "carol.start.cmi";
    public static final String CMI_INITIAL_CONTEXT_FACTORY = "cmi.context.factory";
    public static final String DEFAULT_PROTOCOLS_KEY = "carol.protocols.default";
    public static final String PROTOCOLS_KEY = "carol.protocols";
    public static final String MULTI_RMI_PREFIX = "multi";
    public static final String MULTI_PROD = "org.ow2.carol.rmi.multi.MultiPRODelegate";
    public static final String MULTI_JNDI = "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory";
    public static final String LEGACY_MULTI_JNDI = "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory";
    public static final String INTERCEPTOR_PKGS_PREFIX = "interceptor.pkgs";
    public static final String INTERCEPTOR_VALUES_PREFIX = "interceptors";
    public static final String PROTOCOL_CLASS_SUFFIX = "protocol.class";
    private static Properties mapping = null;

    public static String getRMIProtocol(String url) {
        if (mapping == null) {
            mapping = new Properties();
            mapping.setProperty("rmi", "jrmp");
            mapping.setProperty("iiop", "iiop");
        }
        if (url != null) {
            StringTokenizer st = new StringTokenizer(url, "://");
            if (!st.hasMoreTokens()) {
                throw new IllegalArgumentException("The given url '" + url + "' is not on the format protocol://<something>.");
            }
            String pref = st.nextToken().trim();
            return mapping.getProperty(pref, pref);
        }
        return null;
    }

    private CarolDefaultValues() {
    }
}

