/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.admin;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.CMIAdminMBean;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.lb.PropertyConfigurationException;
import org.ow2.cmi.lb.data.PropertyData;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.util.PolicyFactory;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class CMIAdmin
implements CMIAdminMBean {
    private static final Log LOGGER = LogFactory.getLog(CMIAdmin.class);
    private final ClusterViewManager clusterViewManager;
    private final ObjectName objectName;
    private static CMIAdmin cmiAdmin;

    private CMIAdmin(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
        this.objectName = null;
    }

    private CMIAdmin(ClusterViewManager clusterViewManager, ObjectName objectName) {
        this.clusterViewManager = clusterViewManager;
        this.objectName = objectName;
    }

    public static synchronized CMIAdmin getCMIAdmin(ObjectName objectName, ClusterViewManager clusterViewManager) {
        if (cmiAdmin == null) {
            cmiAdmin = new CMIAdmin(clusterViewManager, objectName);
        }
        return cmiAdmin;
    }

    public static synchronized CMIAdmin getCMIAdmin() {
        if (cmiAdmin == null) {
            ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
            cmiAdmin = new CMIAdmin(clusterViewManager);
        }
        return cmiAdmin;
    }

    public static synchronized void setCMIAdmin(CMIAdmin cmiAdmin) {
        if (cmiAdmin == null | CMIAdmin.cmiAdmin == null) {
            CMIAdmin.cmiAdmin = cmiAdmin;
        }
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public JMXServiceURL getJMXServiceURL(String protocolName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        JMXServiceURL jmxServiceURL = ((ServerClusterViewManager)this.clusterViewManager).getJMXServiceURL(protocolName);
        if (jmxServiceURL == null) {
            throw new IllegalArgumentException("Unknown protocol: " + protocolName);
        }
        return jmxServiceURL;
    }

    @Override
    public Set<String> getProtocols() {
        return this.clusterViewManager.getProtocols();
    }

    @Override
    public String getItfName(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            return ((ServerClusterViewManager)this.clusterViewManager).getItfName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n " + e.getMessage());
        }
    }

    @Override
    public String getBusinessName(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            return ((ServerClusterViewManager)this.clusterViewManager).getBusinessName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public boolean isReplicated(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.isReplicated(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public Set<String> getServerRefsForProtocol(String protocolName) throws IllegalArgumentException, UnsupportedOperationException {
        Set<ServerRef> serverRefs;
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            serverRefs = ((ServerClusterViewManager)this.clusterViewManager).getServerRefs(protocolName);
        }
        catch (ServerClusterViewManagerException e) {
            throw new IllegalArgumentException("Protocol not found: " + protocolName + "\n" + e.getMessage());
        }
        HashSet<String> result = new HashSet<String>();
        for (ServerRef serverRef : serverRefs) {
            result.add(serverRef.getProviderURL());
        }
        return result;
    }

    @Override
    public Set<String> getServerObjectsForProtocol(String serverUrl, String protocolName) throws IllegalArgumentException, UnsupportedOperationException {
        Set<String> objectRefs;
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            objectRefs = ((ServerClusterViewManager)this.clusterViewManager).getServerObjectForProtocol(serverUrl, protocolName);
        }
        catch (ServerClusterViewManagerException e) {
            throw new IllegalArgumentException("Unable to get Objects for server " + serverUrl + " on " + protocolName + " protocol \n" + e.getMessage());
        }
        return objectRefs;
    }

    @Override
    public Set<String> getObjectNames() {
        return this.clusterViewManager.getObjectNames();
    }

    @Override
    public String getRefOnLocalRegistry(String protocolName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ServerRef serverRef = ((ServerClusterViewManager)this.clusterViewManager).getRefOnLocalRegistry(protocolName);
        if (serverRef == null) {
            throw new IllegalArgumentException(serverRef + " doesn't exist");
        }
        return serverRef.getProviderURL();
    }

    @Override
    public String getPolicyClassName(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getPolicyClassName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public void setPolicyClassName(String objectName, String policyClassName) throws IllegalArgumentException, UnsupportedOperationException, ClassNotFoundException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            ((ServerClusterViewManager)this.clusterViewManager).setPolicyClassName(objectName, policyClassName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public String getStrategyClassName(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getStrategyClassName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public void setStrategyClassName(String objectName, String strategyClassName) throws IllegalArgumentException, UnsupportedOperationException, ClassNotFoundException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            ((ServerClusterViewManager)this.clusterViewManager).setStrategyClassName(objectName, strategyClassName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public Set<String> getPropertiesNamesForPolicy(String objectName) throws IllegalArgumentException {
        Class<IPolicy<?>> policyClass;
        try {
            policyClass = this.clusterViewManager.getPolicyClass(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        HashSet<String> propertiesNames = new HashSet<String>();
        try {
            Map<String, PropertyData> properties = PolicyFactory.getPropertyData(policyClass);
            for (String propertyName : properties.keySet()) {
                if (List.class.equals((Object)PolicyFactory.getPropertyRawType(policyClass, propertyName))) continue;
                propertiesNames.add(propertyName);
            }
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error("Cannot get properties for class {0}", policyClass.getName(), e);
            throw new RuntimeException("Cannot get properties for class " + policyClass.getName() + "\n" + e.getMessage());
        }
        return propertiesNames;
    }

    @Override
    public Set<String> getListPropertiesNamesForPolicy(String objectName) throws IllegalArgumentException {
        Class<IPolicy<?>> policyClass;
        try {
            policyClass = this.clusterViewManager.getPolicyClass(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        HashSet<String> propertiesNames = new HashSet<String>();
        try {
            Map<String, PropertyData> properties = PolicyFactory.getPropertyData(policyClass);
            for (String propertyName : properties.keySet()) {
                if (!List.class.equals((Object)PolicyFactory.getPropertyRawType(policyClass, propertyName))) continue;
                propertiesNames.add(propertyName);
            }
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error("Cannot get properties for class {0}", policyClass.getName(), e);
            throw new RuntimeException("Cannot get properties for class " + policyClass.getName() + "\n" + e.getMessage());
        }
        return propertiesNames;
    }

    @Override
    public String getPropertyForPolicy(String objectName, String propertyName) throws IllegalArgumentException {
        IPolicy<CMIReference> policy;
        try {
            policy = this.clusterViewManager.getPolicy(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        Class<?> policyClass = policy.getClass();
        try {
            Type propertyType = PolicyFactory.getPropertyRawType(policyClass, propertyName);
            if (List.class.equals((Object)propertyType)) {
                LOGGER.error("The value of property {0} is a list", objectName);
                throw new IllegalArgumentException("The value of property " + objectName + " is a list");
            }
            return PolicyFactory.getProperty(policy, propertyName).toString();
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error("Cannot get properties for class {0}", policyClass.getName(), e);
            throw new RuntimeException("Cannot get properties for class " + policyClass.getName() + "\n" + e.getMessage());
        }
    }

    @Override
    public List<String> getListPropertyForPolicy(String objectName, String propertyName) throws IllegalArgumentException {
        IPolicy<CMIReference> policy;
        try {
            policy = this.clusterViewManager.getPolicy(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        Class<?> policyClass = policy.getClass();
        try {
            Type propertyType = PolicyFactory.getPropertyRawType(policyClass, propertyName);
            if (!List.class.equals((Object)propertyType)) {
                LOGGER.error("The value of property {0} is not a list", objectName);
                throw new IllegalArgumentException("The value of property " + objectName + " is not a list");
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Object obj : (List)PolicyFactory.getProperty(policy, propertyName)) {
                result.add(obj.toString());
            }
            return result;
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error("Cannot get properties for class {0}", policyClass.getName(), e);
            throw new RuntimeException("Cannot get properties for class " + policyClass.getName() + "\n" + e.getMessage());
        }
    }

    @Override
    public void setPropertyForPolicy(String objectName, String propertyName, String propertyValue) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            Class<? extends IPolicy<?>> policyClass = this.clusterViewManager.getPolicyClass(objectName);
            ((ServerClusterViewManager)this.clusterViewManager).setPropertyForPolicy(objectName, propertyName, PolicyFactory.convertString(policyClass, propertyName, propertyValue));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        catch (PropertyConfigurationException e) {
            throw new IllegalArgumentException("The property " + propertyName + " cannot be applied", e);
        }
    }

    @Override
    public void setListPropertyForPolicy(String objectName, String propertyName, List<String> propertyValue) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            Class<? extends IPolicy<?>> policyClass = this.clusterViewManager.getPolicyClass(objectName);
            ((ServerClusterViewManager)this.clusterViewManager).setPropertyForPolicy(objectName, propertyName, PolicyFactory.convertStrings(policyClass, propertyName, propertyValue));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        catch (PropertyConfigurationException e) {
            throw new IllegalArgumentException("The property " + propertyName + " cannot be applied" + "\n" + e.getMessage());
        }
    }

    @Override
    public void setPropertiesForPolicy(String objectName, Map<String, Object> properties) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            Class<? extends IPolicy<?>> policyClass = this.clusterViewManager.getPolicyClass(objectName);
            ((ServerClusterViewManager)this.clusterViewManager).setPropertiesForPolicy(objectName, this.convertProperties(policyClass, properties));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        catch (PropertyConfigurationException e) {
            throw new IllegalArgumentException("The properties " + properties + " cannot be applied" + "\n" + e.getMessage());
        }
    }

    @Override
    public void setAlgorithmForPolicy(String objectName, String policyClassName, String strategyClassName, Map<String, Object> properties) throws IllegalArgumentException, UnsupportedOperationException, ClassNotFoundException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        Class<?> policyClass = Class.forName(policyClassName);
        Class<?>[] interfaces = policyClass.getInterfaces();
        if (!Arrays.asList(interfaces).contains(IPolicy.class)) {
            throw new IllegalArgumentException(policyClassName + " doesn't implement the interface " + IPolicy.class.getName());
        }
        Class<?> strategyClass = Class.forName(strategyClassName);
        interfaces = strategyClass.getInterfaces();
        if (!Arrays.asList(interfaces).contains(IStrategy.class)) {
            throw new IllegalArgumentException(strategyClassName + " doesn't implement the interface " + IStrategy.class.getName());
        }
        try {
            ((ServerClusterViewManager)this.clusterViewManager).setAlgorithmForPolicy(objectName, policyClassName, strategyClassName, this.convertProperties(policyClass, properties));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        catch (PropertyConfigurationException e) {
            throw new IllegalArgumentException("The properties " + properties + " cannot be applied" + "\n" + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> convertProperties(Class<? extends IPolicy> policyClass, Map<String, Object> properties) throws ObjectNotFoundException, PropertyConfigurationException {
        HashMap<String, Object> castedProps = new HashMap<String, Object>();
        for (String propertyName : properties.keySet()) {
            Type propertyType = PolicyFactory.getPropertyType(policyClass, propertyName);
            List<?> value = properties.get(propertyName);
            if (propertyType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)propertyType;
                if (!parameterizedType.getRawType().equals(List.class)) throw new PropertyConfigurationException("Support only list as parameterized type");
                if (parameterizedType.getActualTypeArguments().equals(String.class)) {
                    value = PolicyFactory.convertStrings(policyClass, propertyName, (List)properties.get(propertyName));
                }
            } else if (propertyType.equals(String.class)) {
                value = PolicyFactory.convertString(policyClass, propertyName, (String)properties.get(propertyName));
            }
            castedProps.put(propertyName, value);
        }
        return castedProps;
    }

    @Override
    public List<String> getServerRefs(String objectName, String protocolName) throws IllegalArgumentException {
        List<CMIReference> cmiReferences;
        try {
            cmiReferences = this.clusterViewManager.getCMIReferences(objectName, protocolName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        ArrayList<String> stringOfCMIRefs = new ArrayList<String>(cmiReferences.size());
        for (CMIReference cmiReference : cmiReferences) {
            stringOfCMIRefs.add(cmiReference.getServerRef().getProviderURL());
        }
        return stringOfCMIRefs;
    }

    @Override
    public List<String> getServerRefs(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        List<CMIReference> cmiReferences;
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            cmiReferences = ((ServerClusterViewManager)this.clusterViewManager).getCMIReferences(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        ArrayList<String> stringOfCMIRefs = new ArrayList<String>(cmiReferences.size());
        for (CMIReference cmiReference : cmiReferences) {
            stringOfCMIRefs.add(cmiReference.getServerRef().getProviderURL());
        }
        return stringOfCMIRefs;
    }

    @Override
    public Set<String> getClusterNames() throws UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        Set<String> clusterNames = ((ServerClusterViewManager)this.clusterViewManager).getClusterNames();
        return clusterNames;
    }

    @Override
    public Set<String> getObjectNames(String clusterName) throws UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        Set<String> objectNames = ((ServerClusterViewManager)this.clusterViewManager).getObjectNames(clusterName);
        return objectNames;
    }

    @Override
    public Integer getDelayToRefresh() {
        return this.clusterViewManager.getDelayToRefresh();
    }

    @Override
    public void setDelayToRefresh(Integer delay) throws UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).setDelayToRefresh(delay);
    }

    @Override
    public String getClusterName(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getClusterName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public Integer getMaxPoolSize(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getPoolConfiguration(objectName).getMax();
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public void setMaxPoolSize(String objectName, Integer maxSize) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            IPoolConfiguration poolConfiguration = this.clusterViewManager.getPoolConfiguration(objectName);
            poolConfiguration.setMax(maxSize);
            ((ServerClusterViewManager)this.clusterViewManager).getPool(objectName).setPoolConfiguration(poolConfiguration);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public void setMinPoolSize(String objectName, Integer minSize) throws IllegalArgumentException, UnsupportedOperationException {
    }

    @Override
    public Integer getMinPoolSize(String objectName) throws IllegalArgumentException {
        return -1;
    }

    @Override
    public boolean isPoolToEmpty(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.isPoolToEmpty(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Object not found: {0}", objectName, e);
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public boolean isServerBlackListed(String serverName) throws UnsupportedOperationException, MalformedURLException, UnknownHostException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        return ((ServerClusterViewManager)this.clusterViewManager).isServerBlackListed(new ServerRef(serverName));
    }

    @Override
    public void addPooltoEmpty(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).addPoolToEmpty(objectName);
    }

    @Override
    public void addServerToBlackList(String serverName) throws UnsupportedOperationException, MalformedURLException, UnknownHostException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).addServerToBlackList(new ServerRef(serverName));
    }

    @Override
    public void removePoolToEmpty(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).removePoolToEmpty(objectName);
    }

    @Override
    public void removeServerFromBlackList(String serverName) throws UnsupportedOperationException, MalformedURLException, UnknownHostException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).removeServerFromBlackList(new ServerRef(serverName));
    }

    @Override
    public Integer getLoadFactor(String serverRef) throws IllegalArgumentException, MalformedURLException, UnknownHostException {
        try {
            return this.clusterViewManager.getLoadFactor(new ServerRef(serverRef));
        }
        catch (ServerNotFoundException e) {
            LOGGER.error("Server not found: {0}", serverRef, e);
            throw new IllegalArgumentException("Server not found: " + serverRef + "\n" + e.getMessage());
        }
    }

    @Override
    public void setLoadFactor(String serverRef, String loadFactor) throws UnsupportedOperationException, MalformedURLException, UnknownHostException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).setLoadFactor(new ServerRef(serverRef), new Integer(loadFactor));
    }

    @Override
    public Integer getNbClientsConnectedToProvider() {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        return ((ServerClusterViewManager)this.clusterViewManager).getNbClientsConnectedToProvider();
    }

    public Boolean receiveFile(Byte[] fileBuff, String fileName, String attributeToSet) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        if ("policies".equals(attributeToSet) || "strategies".equals(attributeToSet)) {
            // empty if block
        }
        return true;
    }

    @Override
    public Map<String, Set<String>> retrieveAvailablePoliciesAndStrategies() throws UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error("Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        return ((ServerClusterViewManager)this.clusterViewManager).getAvailablePoliciesAndStrategies();
    }
}

