/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.client;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.objectweb.carol.util.configuration.ConfigurationRepository;
import org.ow2.easybeans.client.ClientContainerException;
import org.ow2.easybeans.client.ClientEnhancer;
import org.ow2.easybeans.client.xml.ApplicationClient;
import org.ow2.easybeans.client.xml.ApplicationClientLoader;
import org.ow2.easybeans.deployment.Deployment;
import org.ow2.easybeans.deployment.resolver.JNDIResolver;
import org.ow2.easybeans.deployment.xml.struct.common.EJBRef;
import org.ow2.easybeans.deployment.xml.struct.common.InjectionTarget;
import org.ow2.easybeans.enhancer.EnhancerException;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.naming.NamingManager;
import org.ow2.easybeans.util.files.FileUtils;
import org.ow2.easybeans.util.files.FileUtilsException;
import org.ow2.easybeans.util.url.URLUtils;
import org.ow2.easybeans.util.url.URLUtilsException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class ClientContainer {
    private static final String DEFAULT_FOLDER = "EasyBeans-Deployer";
    private String mainClass = null;
    private String tmpDir = null;
    private String classpath = null;
    private String[] args = null;
    private List<String> appArgs = null;
    private URL[] extensionsURLs = null;
    private Log logger = LogFactory.getLog(ClientContainer.class);
    private JNDIResolver jndiResolver = null;
    private String jarClient = null;
    private ApplicationClient applicationClient = null;

    private ClientContainer(String[] args) {
        this.args = args;
        this.appArgs = new ArrayList<String>();
    }

    public static void main(String[] args) {
        ClientContainer cc = new ClientContainer(args);
        try {
            cc.start();
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String message = t.getMessage();
            if (t instanceof Error) {
                System.err.println("There was the following error : " + message);
            } else if (t instanceof Exception) {
                System.err.println("There was the following exception : " + message);
            }
            t.printStackTrace(System.err);
        }
        catch (Exception e) {
            System.err.println("There was the following exception : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void start() throws Exception {
        this.analyzeArgs();
        String userArg = null;
        String fileName = null;
        boolean fileMode = true;
        try {
            userArg = this.appArgs.get(0);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.usage();
            throw new ClientContainerException("You haven't specify a jar, an ear file or class name as argument.See the Usage.");
        }
        String className = null;
        if (!userArg.toLowerCase().endsWith(".jar") && !userArg.toLowerCase().endsWith(".ear")) {
            className = userArg;
            fileMode = false;
        } else {
            fileMode = true;
            fileName = userArg;
        }
        File clientJarFile = null;
        if (fileMode) {
            File argFile = new File(fileName);
            clientJarFile = fileName.toLowerCase().endsWith(".ear") ? this.extractAndAnalyzeEar(argFile) : argFile;
        }
        ConfigurationRepository.init();
        System.setProperty("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.ow2.easybeans.naming.pkg");
        if (fileMode) {
            Manifest manifest = new JarFile(clientJarFile).getManifest();
            if (manifest == null) {
                throw new ClientContainerException("No manifest was found inside the file" + clientJarFile);
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                throw new ClientContainerException("No attributes were found in the manifest of the file '" + clientJarFile + "'.");
            }
            this.mainClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
        } else {
            this.mainClass = className;
        }
        if (!fileMode) {
            URLClassLoader clientCL = new URLClassLoader(this.getUserClasspathUrls());
            Thread.currentThread().setContextClassLoader(clientCL);
            this.invokeClient();
            return;
        }
        if (this.mainClass == null || this.mainClass.length() == 0) {
            throw new ClientContainerException("No main class was found inside the Manifest  of the file '" + clientJarFile + "'. This attribute is required to launch the application client.");
        }
        this.logger.info("Using Main-Class : {0}", this.mainClass);
        URL clientJarURL = null;
        try {
            clientJarURL = URLUtils.fileToURL2(clientJarFile);
        }
        catch (URLUtilsException uue) {
            throw new ClientContainerException("Error when building an URL with the file '" + clientJarFile + "'.", uue);
        }
        this.applicationClient = ApplicationClientLoader.loadApplicationClient(clientJarFile);
        URL[] urlsClient = null;
        if (this.extensionsURLs != null) {
            urlsClient = new URL[this.extensionsURLs.length + 1];
            for (int i = 0; i < this.extensionsURLs.length; ++i) {
                urlsClient[i] = this.extensionsURLs[i];
                this.logger.debug("Adding " + this.extensionsURLs[i] + " to the urls of the client", new Object[0]);
            }
            urlsClient[this.extensionsURLs.length] = clientJarURL;
        } else {
            this.logger.debug("Only one url for urls of client", new Object[0]);
            urlsClient = new URL[]{clientJarURL};
        }
        this.logger.debug("Building classloader with urls {0}", Arrays.asList(urlsClient));
        EasyBeansClassLoader clientClassloader = new EasyBeansClassLoader(urlsClient, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(clientClassloader);
        this.buildENC();
        this.invokeClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeClient() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, EnhancerException {
        ClassLoader clientClassloader = Thread.currentThread().getContextClassLoader();
        if (this.logger.isDebugEnabled() && clientClassloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)clientClassloader;
            URL[] urls = urlClassLoader.getURLs();
            this.logger.debug("URLs of the classloader :", new Object[0]);
            for (int u = 0; u < urls.length; ++u) {
                this.logger.debug("URL[" + u + "] = " + urls[u], new Object[0]);
            }
        }
        ArrayList<String> classesToEnhance = new ArrayList<String>();
        classesToEnhance.add(this.mainClass.replace(".", "/"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jndi.resolver", this.jndiResolver);
        ClientEnhancer.enhance(Thread.currentThread().getContextClassLoader(), classesToEnhance, map);
        Class<?> clazz = clientClassloader.loadClass(this.mainClass);
        Class[] argList = new Class[]{this.args.getClass()};
        if (this.applicationClient != null) {
            for (EJBRef ejbRef : this.applicationClient.getEJBRefs()) {
                List<InjectionTarget> injectionTargetList = ejbRef.getInjectionTargetList();
                if (injectionTargetList == null) continue;
                for (InjectionTarget injectionTarget : injectionTargetList) {
                    String targetName = injectionTarget.getTargetName();
                    try {
                        Field field = clazz.getDeclaredField(targetName);
                        boolean access = field.isAccessible();
                        try {
                            if (!access) {
                                field.setAccessible(true);
                            }
                            String ejbLink = ejbRef.getEjbLink();
                            String itfName = ejbRef.getRemote();
                            String jndiName = this.jndiResolver.getJndiNameInterface(itfName, ejbLink);
                            if (jndiName != null) {
                                Object value = null;
                                try {
                                    value = new InitialContext().lookup(jndiName);
                                }
                                catch (NamingException e) {
                                    this.logger.error("Unable to lookup the name '" + jndiName + "'.", e);
                                }
                                if (value != null) {
                                    field.set(this.applicationClient, value);
                                    continue;
                                }
                                this.logger.error("No value found in Initial Context for the name '" + jndiName + "'.", new Object[0]);
                                continue;
                            }
                            this.logger.error("No JNDI name found for interface '" + itfName + "'.", new Object[0]);
                        }
                        finally {
                            if (access) continue;
                            field.setAccessible(false);
                        }
                    }
                    catch (SecurityException e) {
                        this.logger.error("Cannot perform injection on the client", e);
                    }
                    catch (NoSuchFieldException e) {
                        this.logger.error("Cannot perform injection on the client", e);
                    }
                }
            }
        }
        Method injectedMeth = clazz.getMethod("injectedByEasyBeans", new Class[0]);
        try {
            injectedMeth.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Cannot perform injection on the client", e);
        }
        Method lifeCycleMeth = clazz.getMethod("easyBeansLifeCyclePostConstruct", new Class[0]);
        try {
            lifeCycleMeth.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Cannot perform lifecycle init on the client", e);
        }
        Method meth = clazz.getMethod("main", argList);
        String[] newArgs = new String[this.appArgs.size() - 1];
        String txtArgs = "";
        for (int i = 0; i < newArgs.length; ++i) {
            newArgs[i] = this.appArgs.get(i + 1);
            txtArgs = txtArgs + newArgs[i] + " ";
        }
        this.logger.info("Starting the application client with the arguments '" + txtArgs + "'.", new Object[0]);
        this.logger.info("Starting client...", new Object[0]);
        meth.invoke(null, new Object[]{newArgs});
        this.logger.debug("End of main method", new Object[0]);
    }

    private void analyzeArgs() throws Exception {
        for (int argn = 0; argn < this.args.length; ++argn) {
            String arg = this.args[argn];
            try {
                if (arg.equals("-tmpDir")) {
                    this.tmpDir = this.args[++argn];
                    continue;
                }
                if (arg.equals("-jarClient")) {
                    this.jarClient = this.args[++argn];
                    continue;
                }
                if (arg.equals("-cp")) {
                    this.classpath = this.args[++argn];
                    continue;
                }
                if (arg.equals("--help") || arg.equals("-help") || arg.equals("-h") || arg.equals("-?")) {
                    this.usage();
                    System.exit(1);
                }
                this.appArgs.add(arg);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new ClientContainerException("A required parameter was missing after the argument" + arg);
            }
        }
    }

    private void usage() {
        System.out.println("Usage of this client :");
        System.out.println("-------------------------------------------------------------------");
        System.out.println("java -jar client.jar <client.jar|app.ear|className> [options]");
        System.out.println("-------------------------------------------------------------------");
        System.out.println(" -jarClient   : Specify the client jar to use of the ear if many.");
        System.out.println(" -tmpDir      : Specify the temp directory where unpack the ear.");
        System.out.println(" -cp          : Specify the classpath to use for the jar client.");
        System.out.println("-------------------------------------------------------------------");
        System.out.println("  --help  : Display this help.");
        System.out.println("  -help   : Display this help.");
        System.out.println("  -h      : Display this help.");
        System.out.println("  -?      : Display this help.");
        System.out.println("-------------------------------------------------------------------");
    }

    private File extractAndAnalyzeEar(File earFile) throws Exception {
        URL earUrl = null;
        try {
            earUrl = URLUtils.fileToURL2(earFile);
        }
        catch (URLUtilsException uue) {
            throw new ClientContainerException("Can not build an url with the filename '" + earFile + "'.", uue);
        }
        URL[] arrURL = new URL[]{earUrl};
        String tempDir = null;
        if (this.tmpDir != null) {
            tempDir = this.tmpDir;
            this.logger.debug("Use your specified temp directory '" + tempDir + "'.", new Object[0]);
        } else {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        this.logger.debug("Using temp directory {0}", tempDir);
        File tmpFileDir = new File(tempDir);
        if (!tmpFileDir.exists() || !tmpFileDir.isDirectory()) {
            throw new ClientContainerException("The temp directory '" + tempDir + "' doesn't exist or is not a directory.");
        }
        if (!tmpFileDir.canWrite()) {
            throw new ClientContainerException("Can not write to the temporary directory '" + tempDir + "'.");
        }
        this.logger.info("Ear file = {0}", earFile);
        JarFile earJarFile = new JarFile(earFile);
        File rootFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name") + File.separator + DEFAULT_FOLDER);
        rootFolder.mkdirs();
        File tmpFolder = new File(rootFolder, "TMP");
        tmpFolder.mkdirs();
        File file = new File(tmpFolder, earFile.getName() + ".new");
        try {
            FileUtils.unpack(earJarFile, file);
        }
        catch (FileUtilsException e) {
            throw new ClientContainerException("Cannot unpack '" + earJarFile + "'.", e);
        }
        File fClient = null;
        this.jndiResolver = new JNDIResolver();
        File clientFile = null;
        File[] files = file.listFiles();
        if (files != null) {
            if (this.jarClient != null) {
                File ff = null;
                boolean found = false;
                for (int f = 0; f < files.length && !found; ++f) {
                    ff = files[f];
                    if (!ff.getPath().endsWith(this.jarClient)) continue;
                    found = true;
                    clientFile = ff;
                    this.logger.info("Found a matching client with the name {0}", ff);
                }
                if (!found) {
                    throw new ClientContainerException("No client with the name '" + this.jarClient + "' was found in this Ear file");
                }
            }
            for (File f : files) {
                if (f.getName().toLowerCase().endsWith("_client.jar") && clientFile == null) {
                    clientFile = f;
                    continue;
                }
                if (f.getName().toLowerCase().endsWith(".ear")) continue;
                IArchive archive = ArchiveManager.getInstance().getArchive(f);
                Deployment dep = new Deployment(archive);
                dep.analyze();
                this.jndiResolver.addDeployment(dep);
            }
        }
        this.logger.debug("Resolver =" + this.jndiResolver, new Object[0]);
        if (clientFile == null) {
            throw new IllegalStateException("No client found");
        }
        fClient = clientFile;
        this.logger.info("Use the application client '" + fClient + "' of the Ear '" + earUrl + "'.", new Object[0]);
        return fClient;
    }

    private URL[] getUserClasspathUrls() {
        if (this.classpath == null) {
            return new URL[0];
        }
        String sep = File.pathSeparator;
        ArrayList<URL> clUser = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(this.classpath, sep);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            try {
                clUser.add(URLUtils.fileToURL2(file));
            }
            catch (URLUtilsException uue) {
                this.logger.warn("Cannot transform to URL the file : '" + file + "'", uue);
            }
        }
        return clUser.toArray(new URL[0]);
    }

    private void buildENC() throws ClientContainerException {
        Context envCtx;
        NamingManager namingManager = null;
        try {
            namingManager = NamingManager.getInstance();
        }
        catch (NamingException e) {
            throw new ClientContainerException("Cannot get a reference on the naming manager.", e);
        }
        Context javaCtx = null;
        try {
            javaCtx = namingManager.createEnvironmentContext("client");
        }
        catch (NamingException e) {
            throw new ClientContainerException("Cannot build an environment context", e);
        }
        try {
            envCtx = javaCtx.createSubcontext("comp/env");
        }
        catch (NamingException e) {
            throw new ClientContainerException("Cannot create subcontext comp/env", e);
        }
        namingManager.setClientContainerComponentContext(javaCtx);
        if (this.applicationClient != null) {
            for (EJBRef ejbRef : this.applicationClient.getEJBRefs()) {
                String ejbRefName = ejbRef.getEjbRefName();
                String ejbLink = ejbRef.getEjbLink();
                String home = ejbRef.getHome();
                String remote = ejbRef.getRemote();
                String itfName = null;
                itfName = home != null ? home : remote;
                String jndiName = this.jndiResolver.getJndiNameInterface(itfName, ejbLink);
                try {
                    this.logger.debug("Binding ejb-ref-name {0} with jndi-name {1}", ejbRefName, jndiName);
                    envCtx.bind(ejbRefName, (Object)new LinkRef(jndiName));
                }
                catch (NamingException e) {
                    throw new ClientContainerException("Cannot bind name '" + ejbRefName + "' in java:comp/env", e);
                }
            }
        }
    }
}

