/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.analyzer;

import java.util.List;
import org.ow2.easybeans.deployment.annotations.analyzer.WarArchiveHelper;
import org.ow2.easybeans.deployment.annotations.analyzer.configurator.metadata.war.WarArchiveMetadataConfigurator;
import org.ow2.easybeans.deployment.metadata.war.WarArchiveMetadata;
import org.ow2.util.deployment.annotations.analyzer.AnalyzerException;
import org.ow2.util.deployment.annotations.analyzer.ArchiveScanner;
import org.ow2.util.deployment.annotations.analyzer.ArchiveScannerFactory;
import org.ow2.util.ee.deploy.api.archive.IArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarAnnotationDeploymentAnalyzer {
    private WarArchiveMetadataConfigurator warArchiveMetadataConfigurator = null;
    private ArchiveScannerFactory archiveScannerFactory;
    private IArchive archive;
    private ClassLoader classLoader;

    public WarAnnotationDeploymentAnalyzer(IArchive archive, ClassLoader classLoader) {
        this(null, archive, classLoader);
    }

    public WarAnnotationDeploymentAnalyzer(ArchiveScannerFactory archiveScannerFactory, IArchive archive, ClassLoader classLoader) {
        this.archiveScannerFactory = archiveScannerFactory;
        this.archive = archive;
        this.classLoader = classLoader;
        this.warArchiveMetadataConfigurator = new WarArchiveMetadataConfigurator();
    }

    public void analyze(List<String> classNames) throws AnalyzerException {
        if (this.archiveScannerFactory == null) {
            this.archiveScannerFactory = ArchiveScannerFactory.getReferenceImplementationInstance();
        }
        ArchiveScanner archiveScanner = this.archiveScannerFactory.createArchiveScanner(this.archive, new WarArchiveHelper(classNames, this.classLoader));
        archiveScanner.addArchiveConfigurator(this.warArchiveMetadataConfigurator);
        archiveScanner.scanCollection(classNames);
        archiveScanner.endScan();
    }

    public WarArchiveMetadata getWarArchiveMetadata() {
        return this.warArchiveMetadataConfigurator.getWarArchiveMetadata();
    }
}

