/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarMethodMetadata;
import org.ow2.util.deployment.metadata.structures.JMethod;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class BusinessMethodResolver {
    public static final String CLASS_INIT = "<clinit>";
    public static final String CONST_INIT = "<init>";
    private static Log logger = LogFactory.getLog(BusinessMethodResolver.class);

    private BusinessMethodResolver() {
    }

    public static void resolve(EjbJarClassMetadata classAnnotationMetadata) {
        BusinessMethodResolver.loop(classAnnotationMetadata, classAnnotationMetadata);
    }

    private static void loop(EjbJarClassMetadata beanclassAnnotationMetadata, EjbJarClassMetadata visitingclassAnnotationMetadata) {
        for (String itf : visitingclassAnnotationMetadata.getInterfaces()) {
            if (itf.startsWith("javax/ejb/") || itf.startsWith("java/io/Serializable") || itf.startsWith("java/io/Externalizable")) continue;
            EjbJarClassMetadata itfMetadata = visitingclassAnnotationMetadata.getEjbJarArchiveMetadata().getEjbJarClassMetadata(itf);
            if (itfMetadata == null) {
                logger.warn("No class was found for interface {0}.", itf);
                continue;
            }
            for (EjbJarMethodMetadata methodData : itfMetadata.getMethodMetadataCollection()) {
                JMethod itfMethod = methodData.getJMethod();
                if (itfMethod.getName().equals(CLASS_INIT) || itfMethod.getName().equals(CONST_INIT)) continue;
                EjbJarMethodMetadata beanMethod = (EjbJarMethodMetadata)beanclassAnnotationMetadata.getMethodMetadata(itfMethod);
                if (beanMethod == null) {
                    throw new IllegalStateException("No method was found for method " + itfMethod + " in class " + beanclassAnnotationMetadata.getClassName());
                }
                beanMethod.setBusinessMethod(true);
            }
            if (itfMetadata.getInterfaces() == null) continue;
            BusinessMethodResolver.loop(beanclassAnnotationMetadata, itfMetadata);
        }
    }
}

