/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;

public final class InterfaceAnnotatedHelper {
    private InterfaceAnnotatedHelper() {
    }

    public static void resolve(EjbJarClassMetadata sessionBean) throws ResolverException {
        String[] interfaces;
        EjbJarArchiveMetadata ejbJarAnnotationMetadata = sessionBean.getEjbJarArchiveMetadata();
        JLocal currentLocalInterfaces = sessionBean.getLocalInterfaces();
        JRemote currentRemoteInterfaces = sessionBean.getRemoteInterfaces();
        for (String itf : interfaces = sessionBean.getInterfaces()) {
            JRemote jRemote;
            EjbJarClassMetadata itfAnnotationMetadata = ejbJarAnnotationMetadata.getEjbJarClassMetadata(itf);
            if (itfAnnotationMetadata == null) continue;
            JLocal jLocal = itfAnnotationMetadata.getLocalInterfaces();
            if (jLocal != null) {
                if (currentLocalInterfaces == null) {
                    currentLocalInterfaces = new JLocal();
                    sessionBean.setLocalInterfaces(currentLocalInterfaces);
                }
                String itfName = itfAnnotationMetadata.getClassName();
                if (!currentLocalInterfaces.getInterfaces().contains(itfName)) {
                    currentLocalInterfaces.addInterface(itfName);
                }
            }
            if ((jRemote = itfAnnotationMetadata.getRemoteInterfaces()) == null) continue;
            if (currentRemoteInterfaces == null) {
                currentRemoteInterfaces = new JRemote();
                sessionBean.setRemoteInterfaces(currentRemoteInterfaces);
            }
            String itfName = itfAnnotationMetadata.getClassName();
            if (currentRemoteInterfaces.getInterfaces().contains(itfName)) continue;
            currentRemoteInterfaces.addInterface(itfName);
        }
    }
}

