/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.enc;

import java.util.Arrays;
import java.util.List;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.impl.JAnnotationResource;
import org.ow2.easybeans.deployment.annotations.impl.JavaxPersistenceContext;
import org.ow2.easybeans.deployment.annotations.impl.JavaxPersistenceUnit;
import org.ow2.easybeans.deployment.api.IJAnnotationResource;
import org.ow2.easybeans.deployment.api.IJavaxPersistenceContext;
import org.ow2.easybeans.deployment.api.IJavaxPersistenceUnit;
import org.ow2.easybeans.deployment.enc.ENCBinding;
import org.ow2.easybeans.deployment.enc.ENCBindingException;
import org.ow2.easybeans.deployment.enc.ENCBindingHolder;
import org.ow2.easybeans.deployment.metadata.CommonClassMetadata;
import org.ow2.easybeans.deployment.metadata.CommonFieldMetadata;
import org.ow2.easybeans.deployment.metadata.CommonMethodMetadata;
import org.ow2.easybeans.deployment.metadata.interfaces.ISharedMetadata;
import org.ow2.easybeans.deployment.metadata.war.WarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.war.WarClassMetadata;
import org.ow2.util.deployment.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ENCBindingBuilder {
    private WarArchiveMetadata warArchiveMetadata = null;
    private ENCBindingHolder bindingHolder = null;
    private static final int GETTER_LENGTH = 3;

    protected ENCBindingBuilder(WarArchiveMetadata warArchiveMetadata) {
        this.warArchiveMetadata = warArchiveMetadata;
        this.bindingHolder = new ENCBindingHolder();
    }

    protected void analyze() throws ENCBindingException {
        for (WarClassMetadata classMetadata : this.warArchiveMetadata.getWarClassMetadataCollection()) {
            this.analyzeClassMetadata(classMetadata);
        }
    }

    protected void analyzeClassMetadata(CommonClassMetadata<?, ?, ?> classMetadata) throws ENCBindingException {
        List<JAnnotationResource> jAnnotationResources;
        List<JavaxPersistenceUnit> javaxPersistenceUnits;
        List<JavaxPersistenceContext> javaxPersistenceContexts = classMetadata.getJavaxPersistencePersistenceContexts();
        if (javaxPersistenceContexts != null) {
            for (JavaxPersistenceContext javaxPersistenceContext : javaxPersistenceContexts) {
                this.addPersistenceContext(javaxPersistenceContext);
            }
        }
        if ((javaxPersistenceUnits = classMetadata.getJavaxPersistencePersistenceUnits()) != null) {
            for (JavaxPersistenceUnit javaxPersistenceUnit : javaxPersistenceUnits) {
                this.addPersistenceUnit(javaxPersistenceUnit);
            }
        }
        if ((jAnnotationResources = classMetadata.getJAnnotationResources()) != null) {
            for (JAnnotationResource jAnnotationResource : jAnnotationResources) {
                this.addResource(jAnnotationResource);
            }
        }
        this.analyzeCommonMetadata(classMetadata);
        for (CommonFieldMetadata fieldAnnotationMetadata : classMetadata.getFieldMetadataCollection()) {
            this.analyzeFieldMetadata(fieldAnnotationMetadata);
        }
        for (CommonMethodMetadata methodAnnotationMetadata : classMetadata.getMethodMetadataCollection()) {
            this.analyzeMethodMetadata(methodAnnotationMetadata);
        }
    }

    protected void analyzeFieldMetadata(CommonFieldMetadata<?, ?, ?> fieldMetadata) throws ENCBindingException {
        this.analyzeCommonMetadata(fieldMetadata);
    }

    protected void analyzeMethodMetadata(CommonMethodMetadata<?, ?, ?> methodMetadata) throws ENCBindingException {
        this.analyzeCommonMetadata(methodMetadata);
    }

    protected void analyzeCommonMetadata(ISharedMetadata commonMetadata) throws ENCBindingException {
        JAnnotationResource jAnnotationResource;
        JavaxPersistenceUnit javaxPersistenceUnit;
        JavaxPersistenceContext javaxPersistenceContext = commonMetadata.getJavaxPersistenceContext();
        if (javaxPersistenceContext != null) {
            if (this.isNullOrEmpty(javaxPersistenceContext.getName())) {
                javaxPersistenceContext.setName(this.getName(commonMetadata, javaxPersistenceContext));
            }
            this.addPersistenceContext(javaxPersistenceContext);
        }
        if ((javaxPersistenceUnit = commonMetadata.getJavaxPersistenceUnit()) != null) {
            if (this.isNullOrEmpty(javaxPersistenceUnit.getName())) {
                javaxPersistenceUnit.setName(this.getName(commonMetadata, javaxPersistenceUnit));
            }
            this.addPersistenceUnit(javaxPersistenceUnit);
        }
        if ((jAnnotationResource = commonMetadata.getJAnnotationResource()) != null) {
            if (this.isNullOrEmpty(jAnnotationResource.getName())) {
                jAnnotationResource.setName(this.getName(commonMetadata, jAnnotationResource));
            }
            jAnnotationResource.setType(this.getType(commonMetadata, jAnnotationResource));
            this.addResource(jAnnotationResource);
        }
    }

    private boolean isNullOrEmpty(String name) {
        return name == null || "".equals(name);
    }

    private String getName(ISharedMetadata commonMetadata, Object o) throws ENCBindingException {
        if (commonMetadata instanceof CommonFieldMetadata) {
            CommonFieldMetadata fieldAnnotationMetadata = (CommonFieldMetadata)commonMetadata;
            return ((CommonClassMetadata)fieldAnnotationMetadata.getClassMetadata()).getJClass().getName().replace("/", ".") + "/" + fieldAnnotationMetadata.getJField().getName();
        }
        if (commonMetadata instanceof CommonMethodMetadata) {
            CommonMethodMetadata methodAnnotationMetadata = (CommonMethodMetadata)commonMetadata;
            StringBuilder propertyBuilder = new StringBuilder(methodAnnotationMetadata.getJMethod().getName());
            propertyBuilder.delete(0, 3);
            propertyBuilder.setCharAt(0, Character.toLowerCase(propertyBuilder.charAt(0)));
            propertyBuilder.insert(0, ((CommonClassMetadata)methodAnnotationMetadata.getClassMetadata()).getJClass().getName().replace("/", ".") + "/");
            return propertyBuilder.toString();
        }
        throw new ENCBindingException("There is no defined name in the object '" + o + "' that is defined on the class '" + commonMetadata + "'.");
    }

    private String getType(ISharedMetadata commonMetadata, IJAnnotationResource jAnnotationResource) throws ENCBindingException {
        if (commonMetadata instanceof CommonFieldMetadata) {
            CommonFieldMetadata fieldAnnotationMetadata = (CommonFieldMetadata)commonMetadata;
            Type typeInterface = Type.getType(fieldAnnotationMetadata.getJField().getDescriptor());
            return typeInterface.getClassName();
        }
        if (commonMetadata instanceof CommonMethodMetadata) {
            CommonMethodMetadata methodAnnotationMetadata = (CommonMethodMetadata)commonMetadata;
            JMethod jMethod = methodAnnotationMetadata.getJMethod();
            Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
            if (args.length != 1) {
                throw new ENCBindingException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
            }
            Type typeInterface = args[0];
            return typeInterface.getClassName();
        }
        return jAnnotationResource.getType();
    }

    protected void addPersistenceContext(IJavaxPersistenceContext javaxPersistenceContext) {
        this.bindingHolder.addPersistenceContextBinding(new ENCBinding<IJavaxPersistenceContext>(javaxPersistenceContext.getName(), javaxPersistenceContext));
    }

    protected void addPersistenceUnit(IJavaxPersistenceUnit javaxPersistenceUnit) {
        this.bindingHolder.addPersistenceUnitBinding(new ENCBinding<IJavaxPersistenceUnit>(javaxPersistenceUnit.getName(), javaxPersistenceUnit));
    }

    protected void addResource(IJAnnotationResource jAnnotationResource) {
        this.bindingHolder.addResourceBinding(new ENCBinding<IJAnnotationResource>(jAnnotationResource.getName(), jAnnotationResource));
    }

    protected ENCBindingHolder getHolder() {
        return this.bindingHolder;
    }

    public static ENCBindingHolder analyze(WarArchiveMetadata warArchiveMetadata) throws ENCBindingException {
        ENCBindingBuilder bindingBuilder = new ENCBindingBuilder(warArchiveMetadata);
        bindingBuilder.analyze();
        return bindingBuilder.getHolder();
    }
}

