/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.xml.helper;

import java.util.List;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.xml.helper.CommonMetadataMerge;
import org.ow2.easybeans.deployment.xml.specific.AbsSpecificBean;
import org.ow2.easybeans.deployment.xml.specific.EJB;
import org.ow2.easybeans.deployment.xml.specific.EasyBeansDD;
import org.ow2.easybeans.deployment.xml.specific.MessageDrivenBean;
import org.ow2.easybeans.deployment.xml.specific.Session;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;

public final class MetadataSpecificMerge
extends CommonMetadataMerge {
    private static Log logger = LogFactory.getLog(MetadataSpecificMerge.class);

    private MetadataSpecificMerge(EjbJarArchiveMetadata ejbMetadata) {
        super(ejbMetadata);
    }

    public static void merge(EjbJarArchiveMetadata ejbMetadata) {
        new MetadataSpecificMerge(ejbMetadata).resolve();
    }

    private void resolve() {
        EasyBeansDD easybeansDD = this.getEjbJarArchiveMetadata().getEasyBeansDD();
        if (easybeansDD != null) {
            logger.debug("There is a specific Deployment Descriptor object, performing the merge of the metadata.", new Object[0]);
            EJB ejb = easybeansDD.getEJB();
            if (ejb != null) {
                List<MessageDrivenBean> mdbList;
                List<Session> sessionList = ejb.getSessions();
                if (sessionList != null) {
                    for (Session session : sessionList) {
                        String ejbName = session.getEjbName();
                        EjbJarClassMetadata classAnnotationMetadata = this.findClassForEjb(ejbName, null);
                        this.applySessionBean(session, classAnnotationMetadata);
                    }
                }
                if ((mdbList = ejb.getMessageDrivenBeans()) != null) {
                    for (MessageDrivenBean mdb : mdbList) {
                        String ejbName = mdb.getEjbName();
                        EjbJarClassMetadata classAnnotationMetadata = this.findClassForEjb(ejbName, null);
                        this.applyMessageDrivenBean(mdb, classAnnotationMetadata);
                    }
                }
            }
        }
    }

    private void applySessionBean(Session sessionbean, EjbJarClassMetadata classAnnotationMetadata) {
        this.applyCommonBean(sessionbean, classAnnotationMetadata);
    }

    private void applyMessageDrivenBean(MessageDrivenBean mdb, EjbJarClassMetadata classAnnotationMetadata) {
        this.applyCommonBean(mdb, classAnnotationMetadata);
    }

    private void applyCommonBean(AbsSpecificBean bean, EjbJarClassMetadata classAnnotationMetadata) {
        IPoolConfiguration poolConfiguration = bean.getPoolConfiguration();
        if (poolConfiguration != null) {
            classAnnotationMetadata.setPoolConfiguration(poolConfiguration);
        }
    }
}

