/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.jmx;

import java.util.Hashtable;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.easybeans.api.jmx.EZBManagementIdentifier;
import org.ow2.easybeans.jmx.CommonsModelerException;
import org.ow2.easybeans.jmx.CommonsModelerHelper;
import org.ow2.easybeans.jmx.MBeansException;
import org.ow2.easybeans.util.loader.ClassUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MBeansHelper {
    private static Log logger = LogFactory.getLog(MBeansHelper.class);
    private static MBeansHelper instance = null;
    private Map<Class, EZBManagementIdentifier> identifiers = new Hashtable<Class, EZBManagementIdentifier>();
    private boolean activate;
    private static String domainName = null;
    private static String serverName = null;

    private MBeansHelper() {
    }

    public static MBeansHelper getInstance() {
        if (instance == null) {
            instance = new MBeansHelper();
        }
        return instance;
    }

    public void activate(boolean activate) {
        this.activate = activate;
    }

    public <T> void registerMBean(T instance) throws MBeansException {
        if (this.activate) {
            String on = this.getObjectName(instance);
            try {
                CommonsModelerHelper.registerModelerMBean(instance, on);
            }
            catch (CommonsModelerException e) {
                throw new MBeansException("Cannot register MBean", e);
            }
        }
    }

    public <T> void unregisterMBean(T instance) throws MBeansException {
        if (this.activate) {
            String on = this.getObjectName(instance);
            try {
                CommonsModelerHelper.unregisterModelerMBean(new ObjectName(on));
            }
            catch (MalformedObjectNameException e) {
                logger.warn("Cannot unregister MBean '" + on + "' : " + e.getMessage(), new Object[0]);
            }
            catch (NullPointerException e) {
                logger.warn("Cannot unregister MBean '" + on + "' : " + e.getMessage(), new Object[0]);
            }
        }
    }

    public <T> String getObjectName(T instance) throws MBeansException {
        EZBManagementIdentifier<T> identifier = this.getIdentifier(instance);
        if (identifier != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(identifier.getDomain());
            sb.append(":");
            sb.append(identifier.getTypeProperty());
            String additionnal = identifier.getAdditionnalProperties(instance);
            if (additionnal != null && !"".equals(additionnal)) {
                sb.append(",");
                sb.append(additionnal);
            }
            sb.append(",");
            sb.append("name=");
            sb.append(identifier.getNamePropertyValue(instance));
            return sb.toString();
        }
        return null;
    }

    private <T> EZBManagementIdentifier<T> getIdentifier(T instance) throws MBeansException {
        Class<?> clz = instance.getClass();
        if (this.identifiers.containsKey(clz)) {
            return this.identifiers.get(clz);
        }
        String mbeanClassname = instance.getClass().getName();
        String mbeanPackage = mbeanClassname.substring(0, mbeanClassname.lastIndexOf(".") + 1);
        String identifierClassname = mbeanPackage + "management." + clz.getSimpleName() + "Identifier";
        try {
            Class<EZBManagementIdentifier> cls = ClassUtils.forName(identifierClassname).asSubclass(EZBManagementIdentifier.class);
            EZBManagementIdentifier id = cls.newInstance();
            if (domainName != null) {
                id.setDomain(domainName);
            }
            if (serverName != null) {
                id.setServerName(serverName);
            }
            this.identifiers.put(clz, id);
            return id;
        }
        catch (ClassNotFoundException e) {
            throw new MBeansException("Identifier Class not found", e);
        }
        catch (InstantiationException e) {
            throw new MBeansException("Identifier Class not instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new MBeansException("Identifier Class not instantiated", e);
        }
    }

    public static String getDomainName() {
        return domainName;
    }

    public static void setDomainName(String domainName) {
        MBeansHelper.domainName = domainName;
    }

    public static String getServerName() {
        return serverName;
    }

    public static void setServerName(String serverName) {
        MBeansHelper.serverName = serverName;
    }
}

