/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.component;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.osgi.configuration.XMLConfigurationInjector;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xmlconfig.XMLConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EZBComponentServiceFactory
implements ManagedServiceFactory {
    private static Log logger = LogFactory.getLog(EZBComponentServiceFactory.class);
    private String componentName;
    private Map<String, EZBComponent> pidsToEasybeansComponentsMap = new HashMap<String, EZBComponent>();
    private Map<String, ServiceRegistration> pidsToServiceRegistrationsMap = new HashMap<String, ServiceRegistration>();
    private Map<String, Dictionary> pidsToConfigurationsMap = new HashMap<String, Dictionary>();
    private ComponentContext componentContext;
    private RunnableHelper<EZBComponent> runner = new RunnableHelper();

    public synchronized void deleted(String pid) {
        final EZBComponent ezbComponent = this.pidsToEasybeansComponentsMap.get(pid);
        ExecutionResult<EZBComponent> result = this.runner.execute(ezbComponent.getClass().getClassLoader(), new IExecution<EZBComponent>(){

            @Override
            public EZBComponent execute() throws Exception {
                ezbComponent.stop();
                return ezbComponent;
            }
        });
        if (result.getException() != null) {
            logger.error("Cannot stop component {0}", ezbComponent.getClass().getName(), result.getException());
        }
        ServiceRegistration serviceRegistration = this.pidsToServiceRegistrationsMap.get(pid);
        serviceRegistration.unregister();
        this.pidsToConfigurationsMap.remove(pid);
        this.pidsToEasybeansComponentsMap.remove(pid);
        this.pidsToServiceRegistrationsMap.remove(pid);
        logger.info("Component with pid {0} deleted", pid);
    }

    public synchronized String getName() {
        return this.componentName;
    }

    public synchronized void updated(String pid, final Dictionary properties) throws ConfigurationException {
        if (this.pidsToConfigurationsMap.get(pid) != null) {
            logger.debug("Update of component with pid {0} not yet supported", pid);
            return;
        }
        logger.debug("Creating Component with pid {0}", pid);
        this.pidsToConfigurationsMap.put(pid, properties);
        Class<EZBComponent> componentClass = null;
        String componentClassName = (String)properties.get("classname");
        try {
            componentClass = this.componentContext.getBundleContext().getBundle().loadClass(componentClassName).asSubclass(EZBComponent.class);
        }
        catch (Exception e) {
            throw new ConfigurationException("classname", "Cannot find EasyBeans component class: " + componentClassName, (Throwable)e);
        }
        catch (Error e) {
            e.printStackTrace();
            throw new ConfigurationException("classname", "Cannot find EasyBeans component class: " + componentClassName, (Throwable)e);
        }
        final Class<EZBComponent> clazz = componentClass;
        ExecutionResult<EZBComponent> result = this.runner.execute(componentClass.getClassLoader(), new IExecution<EZBComponent>(){

            @Override
            public EZBComponent execute() throws Exception {
                EZBComponent ezbComponent = EZBComponentServiceFactory.this.getConfiguredComponent(clazz, properties);
                ezbComponent.init();
                ezbComponent.start();
                EZBComponentServiceFactory.this.postComponentStart(ezbComponent);
                return ezbComponent;
            }
        });
        if (result.getException() != null) {
            throw new ConfigurationException("", "Error while starting component (class: " + componentClass.getName() + ").", (Throwable)result.getException());
        }
        this.updateMapsAndRegisterService(pid, properties, result.getResult());
        logger.debug("Component with pid {0} and dictionary {1} updated", pid, properties);
        logger.info("Component with pid {0} created", pid);
    }

    protected void postComponentStart(EZBComponent ezbComponent) {
    }

    protected void updateMapsAndRegisterService(String pid, Dictionary properties, EZBComponent ezbComponent) {
        ServiceRegistration serviceRegistration = this.componentContext.getBundleContext().registerService(new String[]{EZBComponent.class.getName(), ezbComponent.getClass().getName()}, (Object)ezbComponent, properties);
        this.pidsToEasybeansComponentsMap.put(pid, ezbComponent);
        this.pidsToServiceRegistrationsMap.put(pid, serviceRegistration);
        this.pidsToConfigurationsMap.put(pid, properties);
    }

    public void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        Dictionary properties = componentContext.getProperties();
        this.componentName = (String)properties.get("component.name");
        logger.debug("Activate component {0} with factory.pid = {1}", this.componentName, properties.get("service.pid"));
    }

    public void deactivate(ComponentContext componentContext) {
        ArrayList<String> pids = new ArrayList<String>();
        pids.addAll(this.pidsToServiceRegistrationsMap.keySet());
        for (String pid : pids) {
            logger.debug("Deleting component with pid {0}", pid);
            this.deleted(pid);
        }
        logger.debug("Deactivated component {0}", this.componentName);
    }

    protected EZBComponent getConfiguredComponent(Class<? extends EZBComponent> componentClass, Dictionary configuration) throws ConfigurationException {
        XMLConfigurationInjector xmlConfigurationInjector;
        String xmlConfiguration = (String)configuration.get("xmlconfig");
        if (xmlConfiguration == null) {
            throw new ConfigurationException("xmlconfig", "Could not find configuration for component: " + componentClass.getName());
        }
        try {
            xmlConfigurationInjector = new XMLConfigurationInjector(componentClass, xmlConfiguration);
        }
        catch (XMLConfigurationException e) {
            throw new ConfigurationException("", "Error while configuring component (class: " + componentClass.getName() + ").", (Throwable)e);
        }
        EZBComponent ezbComponent = xmlConfigurationInjector.getConfiguredComponent();
        return ezbComponent;
    }

    static {
        System.setProperty("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory");
    }
}

