/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.ow2.easybeans.persistence.JPersistenceContext;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfo;

public class PersistenceUnitManager
implements EZBPersistenceUnitManager {
    private Map<String, JPersistenceContext> persistenceContexts = null;
    private JPersistenceUnitInfo[] persistenceUnitInfos;

    public PersistenceUnitManager(JPersistenceUnitInfo[] persistenceUnitInfos) {
        this.persistenceUnitInfos = persistenceUnitInfos;
        this.persistenceContexts = new HashMap<String, JPersistenceContext>();
        this.addExtraPersistenceUnitInfos(persistenceUnitInfos);
    }

    public void addExtraPersistenceUnitInfos(JPersistenceUnitInfo[] newPersistenceUnitInfos) {
        if (newPersistenceUnitInfos != null) {
            for (JPersistenceUnitInfo pUnitInfo : newPersistenceUnitInfos) {
                String persistenceUnitName = pUnitInfo.getPersistenceUnitName();
                JPersistenceContext jPersistenceContext = this.persistenceContexts.get(persistenceUnitName);
                if (jPersistenceContext != null) {
                    throw new IllegalArgumentException("There is already an existing persistence unit name named '" + persistenceUnitName + "' in this persistence unit manager.");
                }
                this.persistenceContexts.put(persistenceUnitName, new JPersistenceContext(pUnitInfo));
            }
        }
    }

    private JPersistenceContext getPersistenceContext(String unitName) {
        if (unitName == null || unitName.equals("")) {
            if (this.persistenceContexts.size() == 0) {
                throw new IllegalArgumentException("No persistence-unit defined");
            }
            if (this.persistenceContexts.size() > 1) {
                throw new IllegalArgumentException("Too many persistence-unit defined, cannot take the default one.");
            }
            return this.persistenceContexts.values().iterator().next();
        }
        JPersistenceContext persistenceContext = this.persistenceContexts.get(unitName);
        if (persistenceContext == null) {
            throw new IllegalArgumentException("No persistence-unit with name '" + unitName + "' defined.");
        }
        return persistenceContext;
    }

    public EntityManager getEntityManager(String unitName, PersistenceContextType type) {
        return this.getPersistenceContext(unitName).getTxEntityManager();
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName) {
        return this.getPersistenceContext(unitName).getEntityManagerFactory();
    }

    public void addCurrent() {
        for (JPersistenceContext pContext : this.persistenceContexts.values()) {
            pContext.addCurrent();
        }
    }

    public void closeCurrentAndReturnToPrevious() {
        for (JPersistenceContext pContext : this.persistenceContexts.values()) {
            pContext.closeCurrentAndReturnToPrevious();
        }
    }

    public void merge(EZBPersistenceUnitManager otherEZBPersistenceUnitManager) {
        if (otherEZBPersistenceUnitManager == null) {
            return;
        }
        PersistenceUnitManager otherPersistenceUnitManager = null;
        if (!(otherEZBPersistenceUnitManager instanceof PersistenceUnitManager)) {
            return;
        }
        otherPersistenceUnitManager = (PersistenceUnitManager)otherEZBPersistenceUnitManager;
        for (String unitName : otherPersistenceUnitManager.persistenceContexts.keySet()) {
            JPersistenceContext pContext = this.persistenceContexts.get(unitName);
            if (pContext != null) continue;
            this.persistenceContexts.put(unitName, otherPersistenceUnitManager.persistenceContexts.get(unitName));
        }
    }

    public JPersistenceUnitInfo[] getPersistenceUnitInfos() {
        return this.persistenceUnitInfos;
    }
}

