/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.rpc.rmi.server;

import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.rpc.api.EJBRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.rmi.server.RMIServerRPC;
import org.ow2.easybeans.server.Embedded;

public class RMIServerRPCImpl
extends PortableRemoteObject
implements RMIServerRPC {
    private Embedded ejb3server;
    private static final int WAIT_TIME = 1000;

    public RMIServerRPCImpl(Embedded ejb3server) throws RemoteException {
        this.ejb3server = ejb3server;
    }

    public EJBResponse getEJBResponse(EJBRequest request) throws RemoteException {
        String id = request.getContainerId();
        if (id == null) {
            throw new RemoteException("No valid container id");
        }
        EZBContainer container = this.ejb3server.getContainer(id);
        if (container == null) {
            throw new RemoteException("Cannot find the container with id '" + id + "'.");
        }
        String factoryName = request.getFactory();
        while (!container.isAvailable()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Factory factory = container.getFactory(factoryName);
        if (factory == null) {
            throw new RemoteException("Cannot find the factory with name '" + factoryName + "'.");
        }
        return factory.rpcInvoke(request);
    }
}

