/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.jacc;

import java.security.Policy;
import org.ow2.easybeans.security.jacc.provider.JPolicy;
import org.ow2.easybeans.security.jacc.provider.JPolicyConfigurationFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class PolicyProvider {
    private static final String JACC_POLICY_PROVIDER = "javax.security.jacc.policy.provider";
    private static final String JACC_POLICY_CONFIG_FACTORY_PROVIDER = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static Log logger = LogFactory.getLog(PolicyProvider.class);

    private PolicyProvider() {
    }

    public static void init() throws SecurityException {
        String javaPolicy = System.getProperty(JACC_POLICY_PROVIDER);
        if (javaPolicy != null) {
            try {
                Policy.setPolicy((Policy)Class.forName(javaPolicy).newInstance());
            }
            catch (ClassNotFoundException cnfe) {
                throw new SecurityException(cnfe.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new SecurityException(iae.getMessage());
            }
            catch (InstantiationException ie) {
                throw new SecurityException(ie.getMessage());
            }
            catch (ClassCastException cce) {
                throw new SecurityException(cce.getMessage());
            }
            logger.info("Using policy provider ''{0}''", javaPolicy);
        } else {
            logger.info("Using EasyBeans policy provider ''{0}''.", JPolicy.class.getName());
            Policy.setPolicy(JPolicy.getInstance());
        }
        String jaccFactoryProvider = System.getProperty("JACC_POLICY_CONFIG_FACTORY_PROVIDER");
        if (jaccFactoryProvider == null) {
            logger.info("Using EasyBeans PolicyConfigurationFactory provider and EasyBeans Policy provider", new Object[0]);
            System.setProperty(JACC_POLICY_CONFIG_FACTORY_PROVIDER, JPolicyConfigurationFactory.class.getName());
        } else {
            logger.info("Using factory ''{0}'' as PolicyConfigurationFactory provider.", jaccFactoryProvider);
        }
    }
}

