/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.jacc.provider;

import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.security.jacc.provider.JPolicyConfiguration;

public final class JPolicyConfigurationKeeper {
    private static Map<String, JPolicyConfiguration> policyConfigurations = new HashMap<String, JPolicyConfiguration>();

    private JPolicyConfigurationKeeper() {
    }

    public static void addConfiguration(JPolicyConfiguration config) {
        try {
            policyConfigurations.put(config.getContextID(), config);
        }
        catch (PolicyContextException pce) {
            throw new RuntimeException("Cannot add the policy configuration object '" + config + "'");
        }
    }

    public static void removeConfiguration(JPolicyConfiguration config) {
        try {
            if (policyConfigurations.containsKey(config.getContextID())) {
                policyConfigurations.remove(config.getContextID());
            }
        }
        catch (PolicyContextException pce) {
            throw new RuntimeException("Cannot remove the policy configuration object '" + config + "'");
        }
    }

    public static JPolicyConfiguration getConfiguration(String contextId) {
        return policyConfigurations.get(contextId);
    }
}

