/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.server;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.deployable.DeployerFactory;
import org.ow2.easybeans.server.ContainersMonitor;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.easybeans.util.url.URLUtils;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DirectoryDeployerMonitor
extends ContainersMonitor {
    private static final int SLEEP_TIME = 5000;
    private Log logger = LogFactory.getLog(DirectoryDeployerMonitor.class);
    private Map<File, Long> modifiedFiles = new WeakHashMap<File, Long>();
    private Map<File, IDeployable> deployed = new ConcurrentHashMap<File, IDeployable>();
    private List<File> failed = new ArrayList<File>();
    private boolean bootInProgress = false;
    private boolean stopped = false;
    private IDeployer deployer;
    private static final FilenameFilter ARCHIVE_NAME_FILTER = new FilenameFilter(){

        public boolean accept(File dir2, String name) {
            return !name.startsWith(".");
        }
    };

    public DirectoryDeployerMonitor(Embedded embedded) throws EmbeddedException {
        super(embedded);
        this.setName(this.getClass().getSimpleName());
        try {
            this.deployer = DeployerFactory.getDeployer(embedded);
        }
        catch (DeployerException e) {
            throw new EmbeddedException("Cannot get a deployer", e);
        }
    }

    public void init() {
        this.bootInProgress = true;
        try {
            this.detectNewArchives();
        }
        catch (EmbeddedException e) {
            this.logger.error("Cannot scan for new archives", e);
        }
        this.bootInProgress = false;
    }

    public void run() {
        while (!this.stopped) {
            for (EZBContainer container : this.getEmbedded().getContainers().values()) {
                if (!container.isAvailable()) continue;
                this.checkContainer(container);
            }
            try {
                this.detectNewArchives();
            }
            catch (Exception e) {
                this.logger.error("Problem when trying to find and deploy new archives", e);
            }
            try {
                this.checkModifiedDeployables();
            }
            catch (Exception e) {
                this.logger.error("Problem when checking current deployables", e);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread fail to sleep");
            }
        }
        return;
    }

    private void detectNewArchives() throws EmbeddedException {
        List<File> deployDirectories = this.getEmbedded().getServerConfig().getDeployDirectories();
        for (File deployDirectory : deployDirectories) {
            File[] files = deployDirectory.listFiles(ARCHIVE_NAME_FILTER);
            if (files == null) continue;
            for (File f : files) {
                IDeployable<?> deployable;
                IArchive archive;
                if (this.deployed.containsKey(f)) continue;
                if (this.failed.contains(f)) {
                    if (!this.hasBeenUpdated(f)) continue;
                    this.failed.remove(f);
                }
                if ((archive = ArchiveManager.getInstance().getArchive(f)) == null) {
                    this.logger.warn("Ignoring invalid file ''{0}''", f);
                    continue;
                }
                try {
                    deployable = DeployableHelper.getDeployable(archive);
                }
                catch (DeployableHelperException e) {
                    throw new EmbeddedException("Cannot get a deployable for the archive '" + archive + "'", e);
                }
                if (!this.bootInProgress) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Thread fail to sleep");
                    }
                }
                this.logger.debug("Detect a new Deployable ''{0}'' and deploying it.", deployable);
                try {
                    this.deployer.deploy(deployable);
                }
                catch (DeployerException e) {
                    this.failed.add(f);
                    throw new EmbeddedException("Cannot deploy the deployable '" + deployable + "'", e);
                }
                catch (RuntimeException e) {
                    this.failed.add(f);
                    throw new EmbeddedException("RuntimeException when deploying the deployable '" + deployable + "'", e);
                }
                this.deployed.put(f, deployable);
            }
        }
    }

    protected boolean hasBeenUpdated(File file) {
        long previousLastModified = 0L;
        Long l = this.modifiedFiles.get(file);
        if (l != null) {
            previousLastModified = l;
        }
        long updatedModified = this.getLastModified(file);
        if (previousLastModified == 0L) {
            this.modifiedFiles.put(file, updatedModified);
            return false;
        }
        if (updatedModified > previousLastModified) {
            this.modifiedFiles.put(file, updatedModified);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkModifiedDeployables() throws EmbeddedException {
        Set<File> files = this.deployed.keySet();
        if (files == null) {
            return;
        }
        for (File f : files) {
            IDeployable<?> newDeployable;
            IDeployable deployable = this.deployed.get(f);
            if (deployable == null || deployable instanceof EJB3Deployable) continue;
            if (!f.exists()) {
                this.logger.info("Deployable ''{0}'' has been removed on the filesystem, undeploy it", deployable);
                try {
                    this.deployer.undeploy(deployable);
                    continue;
                }
                catch (DeployerException e) {
                    this.logger.error("Undeploy of the deployable '" + deployable + "' has failed", e);
                    this.failed.add(f);
                    continue;
                }
                finally {
                    this.deployed.remove(f);
                    continue;
                }
            }
            if (!this.hasBeenUpdated(f)) continue;
            this.logger.info("Deployable ''{0}'' has been updated, reloading it", deployable);
            try {
                this.deployer.undeploy(deployable);
            }
            catch (DeployerException e) {
                this.logger.error("Undeploy of the deployable '" + deployable + "' has failed", e);
                this.deployed.remove(f);
                this.failed.add(f);
            }
            IArchive archive = ArchiveManager.getInstance().getArchive(f);
            if (archive == null) {
                this.logger.warn("Ignoring invalid file ''{0}''", f);
                continue;
            }
            try {
                newDeployable = DeployableHelper.getDeployable(archive);
            }
            catch (DeployableHelperException e) {
                this.logger.error("Cannot get a deployable for the archive '" + archive + "'", e);
                continue;
            }
            try {
                this.deployer.deploy(newDeployable);
            }
            catch (DeployerException e) {
                this.failed.add(f);
                throw new EmbeddedException("Cannot redeploy the deployable '" + deployable + "'.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkContainer(EZBContainer container) {
        IArchive archive = container.getArchive();
        URL url = null;
        try {
            url = archive.getURL();
        }
        catch (ArchiveException e1) {
            this.logger.warn("Cannot get URL on the container {0}", archive.getName());
            return;
        }
        File file = URLUtils.urlToFile(url);
        if (!file.exists()) {
            this.logger.info("Archive ''{0}'' has been removed, then the associated EJB3 container is stopping", archive.getName());
            try {
                container.stop();
                this.getEmbedded().removeContainer(container);
            }
            finally {
                this.deployed.remove(file);
            }
            return;
        }
        if (this.hasBeenUpdated(file)) {
            this.logger.info("Container with archive {0} was modified. Reloading...", archive.getName());
            try {
                container.stop();
                this.getEmbedded().removeContainer(container);
            }
            finally {
                this.deployed.remove(file);
            }
            try {
                container.start();
                this.getEmbedded().addContainer(container);
            }
            catch (EZBContainerException e) {
                this.deployed.remove(file);
                this.logger.error("Error while restarting archive {0}.", archive.getName(), e);
            }
        }
    }

    public void stopOrder() {
        this.stopped = true;
    }
}

