/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb2.internal;

import java.io.File;
import java.net.URL;
import org.ow2.jonas.ejb2.EJBService;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB21Deployer
implements IDeployer {
    private Log logger = LogFactory.getLog(EJB21Deployer.class);
    private EJBService ejb21Service = null;

    protected void undeployEJB21JAR(EJB21Deployable ejbJarDeployable) throws DeployerException {
        this.logger.info("Undeploying {0}", ejbJarDeployable);
        try {
            this.ejb21Service.removeContainer(this.getFile(ejbJarDeployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the EJB 2.1 deployable '" + ejbJarDeployable + "'.", e);
        }
    }

    protected void deployEJB21JAR(EJB21Deployable ejbJarDeployable) throws DeployerException {
        this.logger.info("Deploying {0}", ejbJarDeployable);
        try {
            this.ejb21Service.createContainer(this.getFile(ejbJarDeployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the EJB 2.1 deployable '" + ejbJarDeployable + "'.", e);
        }
    }

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EJB21Deployable) {
            this.deployEJB21JAR((EJB21Deployable)deployable);
        }
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        return this.ejb21Service.isJarDeployed(this.getFile(deployable).getAbsolutePath());
    }

    protected File getFile(IDeployable<?> deployable) throws DeployerException {
        URL url = null;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from deployable '" + deployable + "'.", e);
        }
        return URLUtils.urlToFile(url);
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof EJB21Deployable;
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EJB21Deployable) {
            this.undeployEJB21JAR((EJB21Deployable)deployable);
        }
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    public void setEjb21Service(EJBService ejb21Service) {
        this.ejb21Service = ejb21Service;
    }
}

