/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.versioning.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.versioning.internal.VersioningServiceImplMBean;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbsServiceImpl
implements VersioningService,
VersioningServiceImplMBean {
    private static Log logger = LogFactory.getLog(VersioningService.class);
    private String defaultPolicy = "Reserved";
    private List<String> contexts = new ArrayList<String>();
    private JmxService jmxService = null;

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public static ObjectName getObjectName(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=versioning");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get versioning service", e);
        }
    }

    @Override
    protected void doStart() throws ServiceException {
        try {
            this.jmxService.registerMBean((Object)this, VersioningServiceImpl.getObjectName(this.getDomainName()));
            logger.info("Versioning service management bean has been registered successfully", new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot register VersioningService MBean", e);
        }
    }

    @Override
    protected void doStop() throws ServiceException {
        this.jmxService.unregisterMBean(VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info("Versioning service management bean has been unregistered successfully", new Object[0]);
    }

    @Override
    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    @Override
    public void setDefaultPolicy(String defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    @Override
    public boolean isVersioningEnabled() {
        return this.isStarted();
    }

    @Override
    public void addContext(String context) {
        this.contexts.add(context);
    }

    @Override
    public void removeContext(String context) {
        this.contexts.remove(context);
    }

    @Override
    public String[] getContexts() {
        return this.contexts.toArray(new String[this.contexts.size()]);
    }

    @Override
    public String getVersionID(File file) {
        String versionID = null;
        JarFile manifestWarFile = null;
        try {
            manifestWarFile = new JarFile(file);
            Manifest warManifest = manifestWarFile.getManifest();
            if (null != warManifest) {
                versionID = warManifest.getMainAttributes().getValue("Implementation-Version");
            }
            if (versionID != null) {
                String allowedSpecialChars = "-_,.";
                boolean versionIDFiltered = false;
                StringBuffer versionIDFilter = new StringBuffer();
                for (char c : versionID.toCharArray()) {
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "-_,.".indexOf(c) >= 0) {
                        versionIDFilter.append(c);
                        continue;
                    }
                    versionIDFiltered = true;
                    versionIDFilter.append('-');
                }
                if (versionIDFiltered) {
                    versionID = versionIDFilter.toString();
                    logger.warn("Invalid characters detected in version ID for file " + file + ", setting version ID to " + versionID, new Object[0]);
                }
                versionID = "-version" + versionID;
            }
        }
        catch (Exception e) {
            logger.info("Failed reading version ID from file " + file, e);
        }
        try {
            manifestWarFile.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return versionID;
    }

    @Override
    public String getVersionID(URL url) {
        try {
            return this.getVersionID(URLUtils.urlToFile(url));
        }
        catch (Exception e) {
            return this.getVersionID(new File(url.getFile()));
        }
    }

    @Override
    public String getVersionID(IDeployable<?> deployable) {
        String versionID = null;
        try {
            IDeployable originalDeployable = deployable;
            while (originalDeployable.getOriginalDeployable() != null) {
                try {
                    originalDeployable = (IDeployable)originalDeployable.getOriginalDeployable();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            versionID = this.getVersionID(originalDeployable.getArchive().getURL());
        }
        catch (Exception e) {
            logger.info("Failed reading version ID from deployable " + deployable, e);
        }
        return versionID;
    }
}

