/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.deployment.annotations.analyzer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ow2.util.deployment.annotations.analyzer.AnalyzerException;
import org.ow2.util.deployment.annotations.analyzer.ArchiveHelper;
import org.ow2.util.deployment.annotations.analyzer.DefaultArchiveHelper;
import org.ow2.util.deployment.annotations.analyzer.configurator.ArchiveConfigurator;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveScanner {
    private IArchive archive;
    private List<URL> scannableURL;
    private List<ArchiveConfigurator> archiveConfigurators;
    private boolean scanEnded;
    private ArchiveHelper archiveHelper;

    public ArchiveScanner(IArchive archive) {
        this(archive, DefaultArchiveHelper.getInstance());
    }

    public ArchiveScanner(IArchive archive, ArchiveHelper archiveHelper) {
        this.archive = archive;
        this.archiveHelper = archiveHelper;
        this.archiveConfigurators = new ArrayList<ArchiveConfigurator>();
        this.scanEnded = false;
    }

    private void prepareScan() throws AnalyzerException {
        try {
            this.scannableURL = this.archiveHelper.listClassURL(this.archive);
        }
        catch (ArchiveException e) {
            throw new AnalyzerException("Error while analyzing archive '" + this.archive.getName() + "'", e);
        }
    }

    public final void addArchiveConfigurator(ArchiveConfigurator archiveConfigurator) {
        this.archiveConfigurators.add(archiveConfigurator);
    }

    public final void removeArchiveConfigurator(ArchiveConfigurator archiveConfigurator) {
        this.archiveConfigurators.remove(archiveConfigurator);
    }

    protected abstract void doScan(URL var1) throws AnalyzerException;

    public final void scanAll() throws AnalyzerException {
        this.scanAll(true);
    }

    public final void scanAll(boolean closeArchive) throws AnalyzerException {
        if (this.scanEnded) {
            throw new IllegalStateException("the scan is already terminated");
        }
        if (this.scannableURL == null) {
            this.prepareScan();
        }
        for (URL url : this.scannableURL) {
            this.doScan(url);
        }
        this.endScan(closeArchive);
    }

    public final void scanCollection(Collection<String> classNameCollection) throws AnalyzerException {
        if (this.scanEnded) {
            throw new IllegalStateException("the scan is already terminated");
        }
        if (this.scannableURL == null) {
            this.prepareScan();
        }
        for (String className : classNameCollection) {
            try {
                URL url = this.archiveHelper.getClassURL(this.archive, className);
                if (url == null || !this.scannableURL.contains(url)) continue;
                this.doScan(url);
                this.scannableURL.remove(url);
            }
            catch (ArchiveException e) {
                throw new AnalyzerException("Error while analyzing archive '" + this.archive.getName() + "'", e);
            }
        }
    }

    public final void endScan() {
        this.endScan(true);
    }

    public final void endScan(boolean closeArchive) {
        if (this.scanEnded) {
            throw new IllegalStateException("the scan is already terminated");
        }
        this.scannableURL.clear();
        if (closeArchive) {
            this.archive.close();
        }
        this.scanEnded = true;
    }

    protected final IArchive getArchive() {
        return this.archive;
    }

    protected final List<ArchiveConfigurator> getArchiveConfigurators() {
        return this.archiveConfigurators;
    }
}

