/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.osgi;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(OSGiDeployer.class);
    private BundleContext bundleContext = null;
    private Map<URL, Bundle> installedBundles = new HashMap<URL, Bundle>();

    protected void undeployBundle(OSGiDeployable osgiDeployable) throws DeployerException {
        this.logger.info("Undeploying {0}", osgiDeployable);
        Bundle osgiBundle = null;
        if (!this.isDeployed(osgiDeployable)) {
            throw new DeployerException("Cannot undeploy the bundle '" + osgiDeployable + "' as it was not deployed.");
        }
        osgiBundle = this.installedBundles.get(this.getURL(osgiDeployable));
        if (osgiBundle == null) {
            throw new DeployerException("No bundle found for the '" + osgiDeployable + "'.");
        }
        try {
            osgiBundle.stop();
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot stop the bundle '" + osgiDeployable + "'.", e);
        }
        try {
            osgiBundle.uninstall();
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot uninstall the bundle '" + osgiDeployable + "'.", e);
        }
        this.installedBundles.remove(this.getURL(osgiDeployable));
    }

    protected void deployBundle(OSGiDeployable osgiDeployable) throws DeployerException {
        this.logger.info("Deploying {0}", osgiDeployable);
        Bundle osgiBundle = null;
        try {
            osgiBundle = this.bundleContext.installBundle(this.getURL(osgiDeployable).toExternalForm());
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot install the bundle '" + osgiDeployable + "'.", e);
        }
        try {
            osgiBundle.start();
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot start the bundle '" + osgiDeployable + "'.", e);
        }
        this.installedBundles.put(this.getURL(osgiDeployable), osgiBundle);
    }

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof OSGiDeployable) {
            this.deployBundle((OSGiDeployable)deployable);
        }
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        return this.installedBundles.get(this.getURL(deployable)) != null;
    }

    protected URL getURL(IDeployable<?> deployable) throws DeployerException {
        URL url = null;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from deployable '" + deployable + "'.", e);
        }
        return url;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof OSGiDeployable;
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof OSGiDeployable) {
            this.undeployBundle((OSGiDeployable)deployable);
        }
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (this.bundleContext == null) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not available as there is no bundle context set on this deployer.");
        }
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }
}

