/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsJobException;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public class SendTopicMessageJob
implements Job {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        TopicConnectionFactory tcf = null;
        TopicConnection connection = null;
        TopicSession session = null;
        Topic topic = null;
        TopicPublisher publisher = null;
        InitialContext ctx = null;
        String user = null;
        String pw = null;
        JobDetail detail = context.getJobDetail();
        JobDataMap jobDataMap = detail.getJobDataMap();
        try {
            ctx = JmsHelper.getInitialContext(jobDataMap);
            tcf = (TopicConnectionFactory)ctx.lookup("jms.connection.factory");
            if (JmsHelper.isDestinationSecure(jobDataMap)) {
                user = jobDataMap.getString("jms.user");
                pw = jobDataMap.getString("jms.password");
                connection = tcf.createTopicConnection(user, pw);
            } else {
                connection = tcf.createTopicConnection();
            }
            session = connection.createTopicSession(false, 1);
            topic = (Topic)ctx.lookup("jms.destination");
            publisher = session.createPublisher(topic);
            String factoryClassName = jobDataMap.getString("jms.message.factory.class.name");
            JmsMessageFactory factory = JmsHelper.getMessageFactory(factoryClassName);
            Message m = factory.createMessage(jobDataMap, session);
            publisher.publish(m);
        }
        catch (NamingException e) {
            try {
                throw new JobExecutionException(e);
                catch (JMSException e2) {
                    throw new JobExecutionException(e2);
                }
                catch (JmsJobException e3) {
                    throw new JobExecutionException(e3);
                }
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(publisher);
                JmsHelper.closeResource(session);
                JmsHelper.closeResource(connection);
                throw throwable;
            }
        }
        JmsHelper.closeResource(publisher);
        JmsHelper.closeResource(session);
        JmsHelper.closeResource(connection);
    }
}

