/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.deployment.impl.annotations.analyzer;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.FieldVisitor;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.util.deployment.annotations.analyzer.configurator.ArchiveConfigurator;
import org.ow2.util.deployment.annotations.analyzer.configurator.ClassConfigurator;
import org.ow2.util.deployment.annotations.analyzer.configurator.FieldConfigurator;
import org.ow2.util.deployment.annotations.analyzer.configurator.MethodConfigurator;
import org.ow2.util.deployment.impl.annotations.analyzer.ScanCommonVisitor;
import org.ow2.util.deployment.impl.annotations.analyzer.ScanFieldVisitor;
import org.ow2.util.deployment.impl.annotations.analyzer.ScanMethodVisitor;
import org.ow2.util.deployment.metadata.structures.JClass;
import org.ow2.util.deployment.metadata.structures.JField;
import org.ow2.util.deployment.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScanClassVisitor
extends ScanCommonVisitor<ClassConfigurator>
implements ClassVisitor {
    private List<ArchiveConfigurator> archiveConfigurators;

    public ScanClassVisitor(List<ArchiveConfigurator> archiveConfigurators) {
        this.archiveConfigurators = archiveConfigurators;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ArrayList<ClassConfigurator> classConfigurators = new ArrayList<ClassConfigurator>();
        JClass jClass = new JClass(version, access, name, signature, superName, interfaces);
        for (ArchiveConfigurator archiveConfigurator : this.archiveConfigurators) {
            classConfigurators.add(archiveConfigurator.createClassConfigurator(jClass));
        }
        this.setCommonConfigurators(classConfigurators);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        JMethod jMethod = new JMethod(access, name, desc, signature, exceptions);
        ArrayList<MethodConfigurator> methodConfigurators = new ArrayList<MethodConfigurator>();
        for (ClassConfigurator classConfigurator : this.getCommonConfigurators()) {
            methodConfigurators.add(classConfigurator.createMethodConfigurator(jMethod));
        }
        return new ScanMethodVisitor(methodConfigurators);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        JField jField = new JField(access, name, desc, signature, value);
        ArrayList<FieldConfigurator> fieldConfigurators = new ArrayList<FieldConfigurator>();
        for (ClassConfigurator classConfigurator : this.getCommonConfigurators()) {
            fieldConfigurators.add(classConfigurator.createFieldConfigurator(jField));
        }
        return new ScanFieldVisitor(fieldConfigurators);
    }

    public void visitEnd() {
        for (ClassConfigurator classConfigurator : this.getCommonConfigurators()) {
            classConfigurator.configurationComplete();
        }
    }
}

