/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.db.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.hsqldb.Server;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.db.DBService;
import org.ow2.jonas.db.base.AbsDBServiceImpl;
import org.ow2.jonas.db.base.AbsDBServiceImplMBean;
import org.ow2.jonas.db.base.User;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.service.ServiceException;

public class HsqlDBServiceImpl
extends AbsDBServiceImpl
implements DBService,
AbsDBServiceImplMBean,
Pojo {
    private InstanceManager _cm;
    private boolean _Fusers;
    private List users;
    private boolean _FdatabaseName;
    private String databaseName;
    private static final String DEFAULT_PORT = "9001";
    private static final int SLEEP_VALUE = 100;
    private static final int MAX_RETRY_NB = 20;
    private boolean _FportNumber;
    private String portNumber;
    private boolean _Fserver;
    private Server server;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MinitServerjava_util_Listjava_lang_Stringjava_lang_String;
    private boolean _MdoStart;
    private boolean _MdoStop;

    private List _getusers() {
        if (!this._Fusers) {
            return this.users;
        }
        return (List)this._cm.getterCallback("users");
    }

    private void _setusers(List list) {
        if (!this._Fusers) {
            this.users = list;
            return;
        }
        this._cm.setterCallback("users", (Object)list);
    }

    private String _getdatabaseName() {
        if (!this._FdatabaseName) {
            return this.databaseName;
        }
        return (String)this._cm.getterCallback("databaseName");
    }

    private void _setdatabaseName(String string) {
        if (!this._FdatabaseName) {
            this.databaseName = string;
            return;
        }
        this._cm.setterCallback("databaseName", (Object)string);
    }

    private String _getportNumber() {
        if (!this._FportNumber) {
            return this.portNumber;
        }
        return (String)this._cm.getterCallback("portNumber");
    }

    private void _setportNumber(String string) {
        if (!this._FportNumber) {
            this.portNumber = string;
            return;
        }
        this._cm.setterCallback("portNumber", (Object)string);
    }

    private Server _getserver() {
        if (!this._Fserver) {
            return this.server;
        }
        return (Server)this._cm.getterCallback("server");
    }

    private void _setserver(Server server) {
        if (!this._Fserver) {
            this.server = server;
            return;
        }
        this._cm.setterCallback("server", (Object)server);
    }

    public HsqlDBServiceImpl(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setusers(null);
        this._setdatabaseName(null);
        this._setportNumber(null);
        this._setserver(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initServer(List list, String string, String string2) {
        void databaseName;
        void portNumber;
        void users;
        if (this._MinitServerjava_util_Listjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("initServerjava_util_Listjava_lang_Stringjava_lang_String");
        }
        this._setusers((List)users);
        if (portNumber != null) {
            this._setportNumber((String)portNumber);
        } else {
            this._setportNumber(DEFAULT_PORT);
        }
        this._setdatabaseName((String)databaseName);
        String jBase = JProp.getJonasBase();
        this._setserver(new Server());
        if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this._getserver().setLogWriter(null);
            this._getserver().setErrWriter(null);
            this._getserver().setSilent(true);
            this._getserver().setTrace(false);
            this._getserver().setLogWriter(null);
        } else {
            this._getserver().setSilent(false);
            this._getserver().setTrace(true);
        }
        String baseDir = jBase + File.separator + "work" + File.separator + "hsqldb" + File.separator + (String)databaseName;
        String pString = "";
        if (portNumber != null) {
            pString = ";port=" + (String)portNumber;
        }
        String serverProps = "database.0=" + baseDir + ";dbname.0=" + (String)databaseName + pString;
        this._getserver().putPropertiesFromString(serverProps);
        Object var8_8 = null;
        if (this._MinitServerjava_util_Listjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("initServerjava_util_Listjava_lang_Stringjava_lang_String", var8_8);
        }
    }

    protected void doStart() throws ServiceException {
        block20: {
            if (this._MdoStart) {
                this._cm.entryCallback("doStart");
            }
            super.doStart();
            if (HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.INFO)) {
                HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)("Starting " + this._getserver().getProductName() + " " + this._getserver().getProductVersion() + " on port " + this._getportNumber()));
            }
            if (HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) {
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("serverState=" + this._getserver().getState()));
            }
            this._getserver().start();
            int retryNb = 0;
            while (this._getserver().getState() != 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    HsqlDBServiceImpl.getLogger().log(BasicLevel.ERROR, (Object)"Can't wait that the service is online", (Throwable)ie);
                }
                if (this._getserver().getState() == 16 && ++retryNb >= 20) {
                    Throwable t = this._getserver().getServerError();
                    ServiceException serviceException = new ServiceException("The server was shutdown :", t);
                    if (this._MdoStart) {
                        this._cm.exitCallback("doStart", (Object)serviceException);
                    }
                    throw serviceException;
                }
                if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) continue;
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("retry=" + retryNb + ", serverState=" + this._getserver().getState()));
            }
            HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)(this._getserver().getProductName() + " started."));
            Connection conn = null;
            Statement st = null;
            try {
                Class.forName("org.hsqldb.jdbcDriver");
                conn = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost:" + this._getportNumber() + "/" + this._getdatabaseName(), "sa", "");
                st = conn.createStatement();
            }
            catch (Exception e) {
                ServiceException serviceException = new ServiceException("Cannot access to HSQL", (Throwable)e);
                if (this._MdoStart) {
                    this._cm.exitCallback("doStart", (Object)serviceException);
                }
                throw serviceException;
            }
            User user2 = null;
            String userName = null;
            String password = null;
            ResultSet rs = null;
            for (User user2 : this._getusers()) {
                try {
                    block19: {
                        password = user2.getPassword();
                        userName = user2.getUserName();
                        HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)("Dropping and adding user '" + userName + "' with password '" + password + "'."));
                        try {
                            rs = st.executeQuery("DROP USER " + userName);
                        }
                        catch (Exception ee) {
                            if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) break block19;
                            HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("User '" + userName + "' doesn't exists"), (Throwable)ee);
                        }
                    }
                    rs = st.executeQuery("Create USER " + userName + " PASSWORD " + password + " ADMIN");
                    rs.close();
                }
                catch (Exception e) {
                    HsqlDBServiceImpl.getLogger().log(BasicLevel.ERROR, (Object)"Error while creating/adding user", (Throwable)e);
                }
            }
            try {
                st.close();
            }
            catch (Exception e) {
                if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) break block20;
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)"Error while closing statement object", (Throwable)e);
            }
        }
        Object var12_18 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var12_18);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        super.doStop();
        this._getserver().shutdown();
        HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)(this._getserver().getProductName() + " stopped."));
        Object var1_1 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var1_1);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("MAX_RETRY_NB")) {
                this._FMAX_RETRY_NB = true;
            }
            if (set.contains("portNumber")) {
                this._FportNumber = true;
            }
            if (set.contains("databaseName")) {
                this._FdatabaseName = true;
            }
            if (set.contains("users")) {
                this._Fusers = true;
            }
            if (set.contains("SLEEP_VALUE")) {
                this._FSLEEP_VALUE = true;
            }
            if (set.contains("server")) {
                this._Fserver = true;
            }
            if (set.contains("DEFAULT_PORT")) {
                this._FDEFAULT_PORT = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("initServerjava_util_Listjava_lang_Stringjava_lang_String")) {
                this._MinitServerjava_util_Listjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

