/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.check;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class CheckEnv {
    public static final int ENV_OK = 0;
    public static final int ENV_ERROR = 1;
    private static int envStatus = 0;
    private static final String JONAS_ROOT = "jonas.root";
    private static final String JONAS_BASE = "jonas.base";
    private static final String JORAM_RAR = "joram_ra_for_jonas.rar";
    private static final String JORAM_ADMIN_FILE = "joramAdmin.xml";
    private static List<String> filesToCheck = new ArrayList<String>();

    private CheckEnv() {
    }

    public static void main(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-help") && !arg.equals("-?")) continue;
            CheckEnv.help();
            System.exit(0);
        }
        envStatus = CheckEnv.performCheck();
        if (envStatus == 0) {
            System.out.println("\nThe JOnAS environment seems correct.");
            System.exit(0);
        } else if (envStatus == 1) {
            System.out.println("\nERROR : The JOnAS environment is NOT correct.");
            System.exit(2);
        }
    }

    public static int performCheck() {
        envStatus = 0;
        try {
            String jonasRoot = System.getProperty(JONAS_ROOT);
            if (jonasRoot == null) {
                System.out.println("ERROR : JONAS_ROOT system property not defined");
                return 1;
            }
            if (!new File(jonasRoot).isDirectory()) {
                System.out.println("ERROR : " + jonasRoot + " directory does not exist");
                return 1;
            }
            System.out.println("- JONAS_ROOT value : " + jonasRoot);
        }
        catch (SecurityException e) {
            System.out.println("ERROR : Cannot get the 'jonas.root' system property ");
            return 1;
        }
        try {
            String jonasBase = System.getProperty(JONAS_BASE);
            if (jonasBase == null) {
                System.out.println("ERROR : JONAS_BASE system property not defined");
                return 1;
            }
            if (!new File(jonasBase).isDirectory()) {
                System.out.println("ERROR : " + jonasBase + " directory does not exist");
                return 1;
            }
            System.out.println("- JONAS_BASE value : " + jonasBase);
        }
        catch (SecurityException e) {
            System.out.println("ERROR : Cannot get the 'jonas.base' system property (" + e + ")");
            return 1;
        }
        for (String fileName : filesToCheck) {
            if (CheckEnv.fileExists(fileName)) continue;
            System.out.println("ERROR : '" + fileName + "' not accessible in JONAS_BASE/conf directory");
            envStatus = 1;
        }
        CheckEnv.checkJORAMRar();
        return envStatus;
    }

    private static boolean fileExists(String fileName) {
        String jonasBase = System.getProperty(JONAS_BASE);
        File file = new File(jonasBase, "conf" + File.separator + fileName);
        return file.exists();
    }

    private static void help() {
        System.out.println("This comand allows to check if the JOnAS environment is correct or not.");
    }

    private static void checkJORAMRar() {
        File joramAdminFile;
        System.out.println("\nChecking JORAM configuration...");
        String jonasBase = System.getProperty(JONAS_BASE);
        File deployDirectory = new File(jonasBase, "deploy");
        if (!new File(deployDirectory, JORAM_RAR).exists()) {
            System.out.println("ERROR : the file 'joram_ra_for_jonas.rar' was not found in JONAS_BASE/deploy directory");
            envStatus = 1;
        }
        if (!(joramAdminFile = new File(jonasBase + File.separator + "conf" + File.separator + JORAM_ADMIN_FILE)).exists()) {
            System.out.println("ERROR : the file joramAdmin.xml was not found in JONAS_BASE/conf directory");
            envStatus = 1;
        }
    }

    static {
        filesToCheck.add("jonas.properties");
        filesToCheck.add("trace.properties");
        filesToCheck.add("carol.properties");
        filesToCheck.add("jonas-realm.xml");
    }
}

