/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.pool;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.pool.NamingPoolException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.CMIReferenceableWrapper;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class StubOrProxyFactory
implements PoolFactory<CMIReferenceable<?>, CMIReference> {
    private static final Log LOGGER = LogFactory.getLog(StubOrProxyFactory.class);
    private final ClusterViewManager clusterViewManager;

    public StubOrProxyFactory(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    public CMIReferenceable<?> create(CMIReference cmiReference) throws PoolException {
        Class<?> interfaceClass;
        InitialContext chosenContext;
        ServerRef serverRef = cmiReference.getServerRef();
        String protocol = serverRef.getProtocol();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.clusterViewManager.getInitialContextFactoryName(protocol));
        env.put("java.naming.provider.url", serverRef.getProviderURL());
        try {
            chosenContext = new InitialContext(env);
        }
        catch (NamingException e) {
            LOGGER.error((Object)"Cannot get a real context", new Object[]{e});
            throw new PoolException("Cannot get a real context", (Throwable)e);
        }
        if (chosenContext == null) {
            LOGGER.error((Object)"Cannot get a real context", new Object[0]);
            throw new PoolException("Cannot get a real context");
        }
        String bindName = cmiReference.getObjectName();
        try {
            interfaceClass = this.clusterViewManager.getInterface(bindName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot get interface for name {0}", new Object[]{bindName, e});
            throw new PoolException("Cannot get interface for name " + bindName, (Throwable)e);
        }
        Object object = null;
        try {
            LOGGER.debug((Object)"Lookup {0} on {1}", new Object[]{bindName, serverRef.getProviderURL()});
            object = PortableRemoteObject.narrow((Object)chosenContext.lookup(bindName), interfaceClass);
        }
        catch (NamingException e) {
            LOGGER.debug((Object)"No ClientClusterViewProvider is bound with the name {0} at the url {1}", new Object[]{bindName, serverRef.getProviderURL(), e});
            throw new NamingPoolException("No ClientClusterViewProvider is bound with the name " + bindName + " at the url " + serverRef.getProviderURL(), e);
        }
        return this.getCMIReferenceable(cmiReference, object);
    }

    public boolean isMatching(CMIReferenceable<?> cmiReferenceable, CMIReference cmiReference) {
        LOGGER.debug((Object)"{0} == {1} ?", new Object[]{cmiReferenceable.getReference(), cmiReference});
        return cmiReferenceable.getReference().equals(cmiReference);
    }

    public void remove(CMIReferenceable<?> cmiReferenceable) {
    }

    public boolean validate(CMIReferenceable<?> cmiReferenceable, PoolEntryStatistics stats) {
        return true;
    }

    protected CMIReferenceable<?> getCMIReferenceable(CMIReference cmiRef, Object stubOrProxy) {
        return new CMIReferenceableWrapper<Object>(cmiRef, stubOrProxy);
    }
}

