/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.rpc;

import java.lang.reflect.Method;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.pool.StubOrProxyFactory;
import org.ow2.cmi.reference.CMIProxyHandle;
import org.ow2.cmi.reference.CMIProxyHandleImpl;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.rpc.CMIInvocationHandlerByPool;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.cmi.rpc.POJOInvocationHandlerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class POJOInvocationHandler
extends CMIInvocationHandlerByPool<Object> {
    private static final long serialVersionUID = 4461812198372895346L;
    private static final Log LOGGER = LogFactory.getLog(POJOInvocationHandler.class);
    private transient ClassLoader classLoader;

    public POJOInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<?> itf) {
        super(clusterViewManager, objectName, protocolName, false, itf);
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws POJOInvocationHandlerException, Throwable {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            Object object = super.invokeRemoteMethod(proxy, method, args);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    protected String proxyToString(Object proxy) {
        return "POJOProxy[" + super.proxyToString(proxy) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkInitialized() throws POJOInvocationHandlerException {
        try {
            ClusterViewManager clusterViewManager = this.clusterViewManager;
            synchronized (clusterViewManager) {
                if (this.clusterViewManager.getPool(this.objectName) == null) {
                    LOGGER.debug((Object)"First lookup on {0}: creation of the pool for its stubs for EJBHome", new Object[]{this.objectName});
                    JPool pool = new JPool((PoolFactory)new StubOrProxyFactory(this.clusterViewManager));
                    pool.setPoolConfiguration(this.clusterViewManager.getPoolConfiguration(this.objectName));
                    this.clusterViewManager.setPool(this.objectName, (Pool<CMIReferenceable<?>, CMIReference>)pool);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot init the pool", new Object[]{e});
            throw new POJOInvocationHandlerException("Cannot init the pool", e);
        }
        if (this.classLoader == null) {
            try {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception e) {
                throw new POJOInvocationHandlerException("Cannot retrieve the classloader for object with name " + this.objectName, e);
            }
        }
    }

    @Override
    protected CMIProxyHandle getHandle(CMIProxy cmiProxy) {
        if (this.cmiProxyHandle == null) {
            this.cmiProxyHandle = new CMIProxyHandleImpl(this.objectName, this.itf.getName(), cmiProxy);
        }
        return this.cmiProxyHandle;
    }
}

