/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.DataBaseService;
import org.ow2.jonas.dbm.internal.DBMConstants;
import org.ow2.jonas.dbm.internal.JOnASDataBaseManagerServiceMBean;
import org.ow2.jonas.dbm.internal.cm.ConnectionManager;
import org.ow2.jonas.dbm.internal.mbean.JDBCDataSource;
import org.ow2.jonas.dbm.internal.mbean.JDBCDriver;
import org.ow2.jonas.dbm.internal.mbean.JDBCResource;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionService;

public class JOnASDataBaseManagerService
extends AbsServiceImpl
implements DataBaseService,
JOnASDataBaseManagerServiceMBean,
DBMConstants,
Pojo {
    private InstanceManager _cm;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.dbm");
    private boolean _FcmList;
    private Vector cmList;
    private boolean _FbindedDatasources;
    private Hashtable bindedDatasources;
    private boolean _FdataSourceNames;
    private List<String> dataSourceNames;
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _FtxService;
    private TransactionService txService;
    private boolean _Fictx;
    private Context ictx;
    private boolean _FregistryService;
    private RegistryService registryService;
    public static final String JDBC_RESOURCE_NAME = "JDBCResource";
    private boolean _FjdbcResourceMBean;
    private JDBCResource jdbcResourceMBean;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MsetDatasourcesjava_lang_String;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _McreateDataSourcejava_lang_Stringjava_util_Properties;
    private boolean _MunbindDataSources;
    private boolean _MgetConnectionManagerjava_lang_String;
    private boolean _MgetDSList;
    private boolean _MgetDataSourcePropertiesFiles;
    private boolean _MgetCurrentNumberOfDataSource;
    private boolean _MgetTotalCurrentNumberOfJDBCConnectionOpen;
    private boolean _MisLoadedDataSourcejava_lang_String;
    private boolean _MunloadDataSourcejava_lang_String;
    private boolean _MgetDataSourcePropertiesFilejava_lang_String;
    private boolean _MloadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean;
    private boolean _MgetDatasourceNamejava_lang_String;
    private boolean _MregisterDbmServiceMBeanjava_lang_Objectjava_lang_String;
    private boolean _MunregisterDbmServiceMBeanjava_lang_String;
    private boolean _MregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String;
    private boolean _MregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringorg_ow2_jonas_dbm_internal_cm_ConnectionManager;
    private boolean _MunregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_String;
    private boolean _MunregisterAllDataSourceAndDriverMBeans;
    private boolean _MunregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String;
    private boolean _MsetTransactionServiceorg_ow2_jonas_tm_TransactionService;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;
    private boolean _MsetRegistryServiceorg_ow2_jonas_registry_RegistryService;
    private boolean _MgetRegistryService;

    private Vector _getcmList() {
        if (!this._FcmList) {
            return this.cmList;
        }
        return (Vector)this._cm.getterCallback("cmList");
    }

    private void _setcmList(Vector vector) {
        if (!this._FcmList) {
            this.cmList = vector;
            return;
        }
        this._cm.setterCallback("cmList", (Object)vector);
    }

    private Hashtable _getbindedDatasources() {
        if (!this._FbindedDatasources) {
            return this.bindedDatasources;
        }
        return (Hashtable)this._cm.getterCallback("bindedDatasources");
    }

    private void _setbindedDatasources(Hashtable hashtable) {
        if (!this._FbindedDatasources) {
            this.bindedDatasources = hashtable;
            return;
        }
        this._cm.setterCallback("bindedDatasources", (Object)hashtable);
    }

    private List _getdataSourceNames() {
        if (!this._FdataSourceNames) {
            return this.dataSourceNames;
        }
        return (List)this._cm.getterCallback("dataSourceNames");
    }

    private void _setdataSourceNames(List list) {
        if (!this._FdataSourceNames) {
            this.dataSourceNames = list;
            return;
        }
        this._cm.setterCallback("dataSourceNames", (Object)list);
    }

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    private TransactionService _gettxService() {
        if (!this._FtxService) {
            return this.txService;
        }
        return (TransactionService)this._cm.getterCallback("txService");
    }

    private void _settxService(TransactionService transactionService) {
        if (!this._FtxService) {
            this.txService = transactionService;
            return;
        }
        this._cm.setterCallback("txService", (Object)transactionService);
    }

    private Context _getictx() {
        if (!this._Fictx) {
            return this.ictx;
        }
        return (Context)this._cm.getterCallback("ictx");
    }

    private void _setictx(Context context) {
        if (!this._Fictx) {
            this.ictx = context;
            return;
        }
        this._cm.setterCallback("ictx", (Object)context);
    }

    private RegistryService _getregistryService() {
        if (!this._FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this._cm.getterCallback("registryService");
    }

    private void _setregistryService(RegistryService registryService) {
        if (!this._FregistryService) {
            this.registryService = registryService;
            return;
        }
        this._cm.setterCallback("registryService", (Object)registryService);
    }

    private JDBCResource _getjdbcResourceMBean() {
        if (!this._FjdbcResourceMBean) {
            return this.jdbcResourceMBean;
        }
        return (JDBCResource)((Object)this._cm.getterCallback("jdbcResourceMBean"));
    }

    private void _setjdbcResourceMBean(JDBCResource jDBCResource) {
        if (!this._FjdbcResourceMBean) {
            this.jdbcResourceMBean = jDBCResource;
            return;
        }
        this._cm.setterCallback("jdbcResourceMBean", (Object)jDBCResource);
    }

    public JOnASDataBaseManagerService(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setcmList(new Vector());
        this._setbindedDatasources(new Hashtable());
        this._setdataSourceNames(new Vector());
        this._setjmxService(null);
        this._settxService(null);
        this._setictx(null);
        this._setjdbcResourceMBean(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDatasources(String string) {
        void datasources;
        if (this._MsetDatasourcesjava_lang_String) {
            this._cm.entryCallback("setDatasourcesjava_lang_String");
        }
        this._setdataSourceNames(JOnASDataBaseManagerService.convertToList((String)datasources));
        Object var2_2 = null;
        if (this._MsetDatasourcesjava_lang_String) {
            this._cm.exitCallback("setDatasourcesjava_lang_String", var2_2);
        }
    }

    public void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Starting DataBase service");
        IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

            public InitialContext execute() throws Exception {
                return JOnASDataBaseManagerService.this.getRegistryService().getRegistryContext();
            }
        };
        ExecutionResult ictxResult = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)ictxGetter);
        if (ictxResult.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when DataBase service initializing");
            ServiceException serviceException = new ServiceException("Cannot create initial context when DataBase service initializing", (Throwable)ictxResult.getException());
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        this._setictx((Context)ictxResult.getResult());
        if (this._getjmxService() != null) {
            this._getjmxService().loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        }
        this.registerDbmServiceMBean(this, this.getDomainName());
        this._setjdbcResourceMBean(this.registerJdbcResourceMBean(this.getDomainName(), this.getJonasServerName(), JDBC_RESOURCE_NAME));
        String dsName = null;
        for (int i = 0; i < this._getdataSourceNames().size(); ++i) {
            dsName = (String)this._getdataSourceNames().get(i);
            try {
                JProp prop = JProp.getInstance((String)dsName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Creating Datasource " + dsName));
                }
                this.createDataSource(dsName, prop.getConfigFileEnv());
                continue;
            }
            catch (Exception e) {
                JProp.removeInstance((String)dsName);
                logger.log(BasicLevel.ERROR, (Object)("JOnAS: Cannot create datasource: '" + dsName + "'"), (Throwable)e);
                logger.log(BasicLevel.ERROR, (Object)("Please check if " + dsName + ".properties is available"));
            }
        }
        logger.log(BasicLevel.INFO, (Object)"DBM Service started");
        Object var7_8 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var7_8);
        }
    }

    public void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        try {
            this.unbindDataSources();
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unbind datasources");
            ServiceException serviceException = new ServiceException("Cannot unbind datasources ", (Throwable)e);
            if (this._MdoStop) {
                this._cm.exitCallback("doStop", (Object)serviceException);
            }
            throw serviceException;
        }
        if (this._getjmxService() != null) {
            this.unregisterDbmServiceMBean(this.getDomainName());
            this.unregisterJdbcResourceMBean(this.getDomainName(), this.getJonasServerName(), JDBC_RESOURCE_NAME);
        }
        logger.log(BasicLevel.INFO, (Object)"DBM Service stopped");
        Object var3_3 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createDataSource(String string, Properties properties) throws Exception {
        void datasourceName;
        void dsd;
        String dsName;
        if (this._McreateDataSourcejava_lang_Stringjava_util_Properties) {
            this._cm.entryCallback("createDataSourcejava_lang_Stringjava_util_Properties");
        }
        if ((dsName = dsd.getProperty("datasource.name")) == null) {
            logger.log(BasicLevel.ERROR, (Object)"");
            ServiceException serviceException = new ServiceException("Cannot create datasource as JNDI name not provided");
            if (this._McreateDataSourcejava_lang_Stringjava_util_Properties) {
                this._cm.exitCallback("createDataSourcejava_lang_Stringjava_util_Properties", (Object)serviceException);
            }
            throw serviceException;
        }
        dsName = dsName.trim();
        String className = dsd.getProperty("datasource.classname", "no class name").trim();
        String url = dsd.getProperty("datasource.url", "no url").trim();
        String description = dsd.getProperty("datasource.description", "no desc").trim();
        String user = dsd.getProperty("datasource.username", "").trim();
        String password = dsd.getProperty("datasource.password", "").trim();
        String connCheckLevel = dsd.getProperty("jdbc.connchecklevel", "1").trim();
        String connMaxAge = dsd.getProperty("jdbc.connmaxage", "1440").trim();
        String maxOpenTime = dsd.getProperty("jdbc.maxopentime", "1440").trim();
        String minconpool = dsd.getProperty("jdbc.minconpool", "0").trim();
        String maxconpool = dsd.getProperty("jdbc.maxconpool", "-1").trim();
        String maxwaittime = dsd.getProperty("jdbc.maxwaittime", "10").trim();
        String maxwaiters = dsd.getProperty("jdbc.maxwaiters", "1000").trim();
        String samplingperiod = dsd.getProperty("jdbc.samplingperiod", "30").trim();
        String adjustperiod = dsd.getProperty("jdbc.adjustperiod", "30").trim();
        String defaultStatement = dsd.getProperty("jdbc.connteststmt", "SELECT 1").trim();
        String pstmtmax = dsd.getProperty("jdbc.pstmtmax", "12").trim();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("create JOnAS ConnectionManager corresponding to data source " + (String)datasourceName + " with JNDI name " + dsName));
        }
        ConnectionManager ds = new ConnectionManager(this._gettxService());
        ds.setDatasourceName((String)datasourceName);
        ds.setDSName(dsName);
        ds.setUrl(url);
        ds.setClassName(className);
        ds.setUserName(user);
        ds.setPassword(password);
        ds.setTransactionIsolation(dsd.getProperty("datasource.isolationlevel", "").trim());
        ds.setMapperName(dsd.getProperty("datasource.mapper", "rdb").trim());
        ds.setDataSourceDescription(description);
        ds.poolConfigure(connCheckLevel, connMaxAge, maxOpenTime, defaultStatement, pstmtmax, minconpool, maxconpool, maxwaittime, maxwaiters, samplingperiod, adjustperiod);
        this._getcmList().addElement(ds);
        this._getictx().rebind(dsName, (Object)ds);
        this._getbindedDatasources().put(dsName, datasourceName);
        logger.log(BasicLevel.INFO, (Object)("Mapping ConnectionManager " + url + " on " + dsName));
        void jdbcDataSourceName = datasourceName;
        String jdbcDriverName = "aJDBCDriver-" + (String)jdbcDataSourceName;
        String jdbcDriverClassName = className;
        String jdbcDataSourceON = this.registerJdbcDataSourceAndDriverMBean(this.getDomainName(), this.getJonasServerName(), (String)jdbcDataSourceName, jdbcDriverName, jdbcDriverClassName, ds);
        this._getjdbcResourceMBean().addJdbcDataSource(jdbcDataSourceON);
        Object var26_26 = null;
        if (this._McreateDataSourcejava_lang_Stringjava_util_Properties) {
            this._cm.exitCallback("createDataSourcejava_lang_Stringjava_util_Properties", var26_26);
        }
    }

    public void unbindDataSources() throws NamingException {
        if (this._MunbindDataSources) {
            this._cm.entryCallback("unbindDataSources");
        }
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            if (this._getcmList().size() > 0) {
                String dsn = null;
                Enumeration lk = this._getcmList().elements();
                while (lk.hasMoreElements()) {
                    ConnectionManager cm = (ConnectionManager)lk.nextElement();
                    cm.closeAllConnection();
                    dsn = cm.getDSName();
                    this._getictx().unbind(dsn);
                    this._getbindedDatasources().remove(dsn);
                }
            }
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)"cannot unbind DataSources", (Throwable)e);
            NamingException namingException = e;
            if (this._MunbindDataSources) {
                this._cm.exitCallback("unbindDataSources", (Object)namingException);
            }
            throw namingException;
        }
        if (this._getjmxService() != null) {
            this.unregisterAllDataSourceAndDriverMBeans();
        }
        Object var5_6 = null;
        if (this._MunbindDataSources) {
            this._cm.exitCallback("unbindDataSources", var5_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager getConnectionManager(String string) {
        if (this._MgetConnectionManagerjava_lang_String) {
            this._cm.entryCallback("getConnectionManagerjava_lang_String");
        }
        ConnectionManager cm = null;
        if (this._getcmList().size() > 0) {
            Enumeration lk = this._getcmList().elements();
            while (lk.hasMoreElements()) {
                void dsname;
                cm = (ConnectionManager)lk.nextElement();
                if (!cm.getDSName().equals(dsname)) continue;
                ConnectionManager connectionManager = cm;
                if (this._MgetConnectionManagerjava_lang_String) {
                    this._cm.exitCallback("getConnectionManagerjava_lang_String", (Object)connectionManager);
                }
                return connectionManager;
            }
        }
        ConnectionManager connectionManager = null;
        if (this._MgetConnectionManagerjava_lang_String) {
            this._cm.exitCallback("getConnectionManagerjava_lang_String", connectionManager);
        }
        return connectionManager;
    }

    public Collection getDSList() {
        if (this._MgetDSList) {
            this._cm.entryCallback("getDSList");
        }
        Vector vector = this._getcmList();
        if (this._MgetDSList) {
            this._cm.exitCallback("getDSList", (Object)vector);
        }
        return vector;
    }

    public List getDataSourcePropertiesFiles() throws Exception {
        if (this._MgetDataSourcePropertiesFiles) {
            this._cm.entryCallback("getDataSourcePropertiesFiles");
        }
        ArrayList arrayList = JModule.getDatasourcePropsInDir();
        if (this._MgetDataSourcePropertiesFiles) {
            this._cm.exitCallback("getDataSourcePropertiesFiles", (Object)arrayList);
        }
        return arrayList;
    }

    public Integer getCurrentNumberOfDataSource() {
        if (this._MgetCurrentNumberOfDataSource) {
            this._cm.entryCallback("getCurrentNumberOfDataSource");
        }
        Integer n = new Integer(this._getcmList().size());
        if (this._MgetCurrentNumberOfDataSource) {
            this._cm.exitCallback("getCurrentNumberOfDataSource", (Object)n);
        }
        return n;
    }

    public Integer getTotalCurrentNumberOfJDBCConnectionOpen() {
        if (this._MgetTotalCurrentNumberOfJDBCConnectionOpen) {
            this._cm.entryCallback("getTotalCurrentNumberOfJDBCConnectionOpen");
        }
        int result = 0;
        if (this._getcmList().size() > 0) {
            Enumeration lk = this._getcmList().elements();
            while (lk.hasMoreElements()) {
                ConnectionManager cm = (ConnectionManager)lk.nextElement();
                result += cm.getPool().getCurrentOpened();
            }
        }
        Integer n = new Integer(result);
        if (this._MgetTotalCurrentNumberOfJDBCConnectionOpen) {
            this._cm.exitCallback("getTotalCurrentNumberOfJDBCConnectionOpen", (Object)n);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLoadedDataSource(String string) {
        if (this._MisLoadedDataSourcejava_lang_String) {
            this._cm.entryCallback("isLoadedDataSourcejava_lang_String");
        }
        boolean result = false;
        if (this._getcmList().size() > 0) {
            Enumeration lk = this._getcmList().elements();
            while (lk.hasMoreElements()) {
                void dsName;
                ConnectionManager cm = (ConnectionManager)lk.nextElement();
                if (!cm.getDatasourceName().equals(dsName)) continue;
                Boolean bl = new Boolean(true);
                if (this._MisLoadedDataSourcejava_lang_String) {
                    this._cm.exitCallback("isLoadedDataSourcejava_lang_String", (Object)bl);
                }
                return bl;
            }
        }
        Boolean bl = new Boolean(result);
        if (this._MisLoadedDataSourcejava_lang_String) {
            this._cm.exitCallback("isLoadedDataSourcejava_lang_String", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void unloadDataSource(String string) {
        block5: {
            block6: {
                Object var7_8;
                if (this._MunloadDataSourcejava_lang_String) {
                    this._cm.entryCallback("unloadDataSourcejava_lang_String");
                }
                logger.log(BasicLevel.DEBUG, (Object)"");
                try {
                    void name;
                    Enumeration lk;
                    if (this._getcmList().size() <= 0 || !(lk = this._getcmList().elements()).hasMoreElements()) break block5;
                    ConnectionManager cm = (ConnectionManager)lk.nextElement();
                    String dsName = cm.getDatasourceName();
                    String jndiName = cm.getDSName();
                    if (dsName.equals(name)) {
                        cm.closeAllConnection();
                        this._getictx().unbind(jndiName);
                        this._getcmList().remove(cm);
                        JProp.removeInstance((String)dsName);
                        String jdbcDataSourceOn = this.unregisterJdbcDataSourceAndDriverMBean(this.getDomainName(), this.getJonasServerName(), dsName);
                        this._getjdbcResourceMBean().removeJdbcDataSource(jdbcDataSourceOn);
                    }
                    var7_8 = null;
                    if (!this._MunloadDataSourcejava_lang_String) break block6;
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)"Cannot unload DataSources", (Throwable)e);
                }
                this._cm.exitCallback("unloadDataSourcejava_lang_String", var7_8);
            }
            return;
        }
        Object var8_9 = null;
        if (this._MunloadDataSourcejava_lang_String) {
            this._cm.exitCallback("unloadDataSourcejava_lang_String", var8_9);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Properties getDataSourcePropertiesFile(String string) throws Exception {
        Properties properties;
        block6: {
            void dsFile;
            if (this._MgetDataSourcePropertiesFilejava_lang_String) {
                this._cm.entryCallback("getDataSourcePropertiesFilejava_lang_String");
            }
            try {
                properties = JProp.getInstance((String)dsFile).getConfigFileEnv();
                if (!this._MgetDataSourcePropertiesFilejava_lang_String) break block6;
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    logger.log(BasicLevel.ERROR, (Object)("Please check if '" + (String)dsFile + ".properties' is available in JONAS_BASE/conf/ directory"));
                } else {
                    logger.log(BasicLevel.ERROR, (Object)("Error occured when reading file " + (String)dsFile));
                }
                Exception exception = e;
                if (this._MgetDataSourcePropertiesFilejava_lang_String) {
                    this._cm.exitCallback("getDataSourcePropertiesFilejava_lang_String", (Object)exception);
                }
                throw exception;
            }
            this._cm.exitCallback("getDataSourcePropertiesFilejava_lang_String", (Object)properties);
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    public void loadDataSource(String string, Properties properties, Boolean bl) throws ServiceException {
        void prop;
        void name;
        void loadFromFile;
        boolean fromFile;
        if (this._MloadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean) {
            this._cm.entryCallback("loadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean");
        }
        if (fromFile = loadFromFile.booleanValue()) {
            logger.log(BasicLevel.DEBUG, (Object)("Load data source named " + (String)name + " from file"));
        } else {
            logger.log(BasicLevel.DEBUG, (Object)("Load data source named " + (String)name + " from form"));
            if (this.isLoadedDataSource((String)name)) {
                logger.log(BasicLevel.DEBUG, (Object)("This data source, " + (String)name + " is already loaded ; Unload it !"));
                this.unloadDataSource((String)name);
            }
            try {
                logger.log(BasicLevel.DEBUG, (Object)"Call getInstance on JProp in order to create the properties file");
                JProp.getInstance((String)name, (Properties)prop);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create datasource " + (String)name + " as cannot create properties file"));
                ServiceException serviceException = new ServiceException("DatabaseService: Cannot create datasource '" + (String)name + "'", (Throwable)e);
                if (this._MloadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean) {
                    this._cm.exitCallback("loadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        try {
            logger.log(BasicLevel.DEBUG, (Object)"Call method to create a data source");
            this.createDataSource((String)name, (Properties)prop);
            logger.log(BasicLevel.DEBUG, (Object)"New data source created");
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create datasource '" + (String)name + "'."));
            if (fromFile) {
                JProp.removeInstance((String)name);
            } else {
                JProp.deleteInstance((String)name);
            }
            ServiceException serviceException = new ServiceException("DatabaseService: Cannot create datasource: " + (String)name + "'", (Throwable)e);
            if (this._MloadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean) {
                this._cm.exitCallback("loadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean", (Object)serviceException);
            }
            throw serviceException;
        }
        Object var8_9 = null;
        if (this._MloadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean) {
            this._cm.exitCallback("loadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean", var8_9);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getDatasourceName(String string) {
        void jndiName;
        if (this._MgetDatasourceNamejava_lang_String) {
            this._cm.entryCallback("getDatasourceNamejava_lang_String");
        }
        String string2 = (String)this._getbindedDatasources().get(jndiName);
        if (this._MgetDatasourceNamejava_lang_String) {
            this._cm.exitCallback("getDatasourceNamejava_lang_String", (Object)string2);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private void registerDbmServiceMBean(Object object, String string) {
        void service;
        void domainName;
        if (this._MregisterDbmServiceMBeanjava_lang_Objectjava_lang_String) {
            this._cm.entryCallback("registerDbmServiceMBeanjava_lang_Objectjava_lang_String");
        }
        ObjectName on = JonasObjectName.databaseService((String)domainName);
        this._getjmxService().registerMBean((Object)service, on);
        Object var4_4 = null;
        if (this._MregisterDbmServiceMBeanjava_lang_Objectjava_lang_String) {
            this._cm.exitCallback("registerDbmServiceMBeanjava_lang_Objectjava_lang_String", var4_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void unregisterDbmServiceMBean(String string) {
        void domainName;
        if (this._MunregisterDbmServiceMBeanjava_lang_String) {
            this._cm.entryCallback("unregisterDbmServiceMBeanjava_lang_String");
        }
        ObjectName on = JonasObjectName.databaseService((String)domainName);
        this._getjmxService().unregisterMBean(on);
        Object var3_3 = null;
        if (this._MunregisterDbmServiceMBeanjava_lang_String) {
            this._cm.exitCallback("unregisterDbmServiceMBeanjava_lang_String", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private JDBCResource registerJdbcResourceMBean(String string, String string2, String string3) {
        if (this._MregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("registerJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String");
        }
        JDBCResource jdbcResourceMBean = null;
        try {
            void resourceName;
            void serverName;
            void domainName;
            String jdbcResourceON = J2eeObjectName.JDBCResourceName((String)domainName, (String)serverName, (String)resourceName);
            jdbcResourceMBean = new JDBCResource(jdbcResourceON);
            this._getjmxService().registerModelMBean((Object)jdbcResourceMBean, jdbcResourceON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCResource MBean", (Throwable)e);
        }
        JDBCResource jDBCResource = jdbcResourceMBean;
        if (this._MregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("registerJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String", (Object)jDBCResource);
        }
        return jDBCResource;
    }

    /*
     * WARNING - void declaration
     */
    private String registerJdbcDataSourceAndDriverMBean(String string, String string2, String string3, String string4, String string5, ConnectionManager connectionManager) {
        void serverName;
        void domainName;
        if (this._MregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringorg_ow2_jonas_dbm_internal_cm_ConnectionManager) {
            this._cm.entryCallback("registerJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringorg_ow2_jonas_dbm_internal_cm_ConnectionManager");
        }
        JDBCDataSource jdbcDataSourceMBean = null;
        String jdbcDataSourceON = null;
        try {
            void ds;
            void jdbcDataSourceName;
            jdbcDataSourceON = J2eeObjectName.getJDBCDataSourceName((String)domainName, (String)serverName, (String)jdbcDataSourceName);
            jdbcDataSourceMBean = new JDBCDataSource(jdbcDataSourceON, (ConnectionManager)ds);
            this._getjmxService().registerModelMBean((Object)jdbcDataSourceMBean, jdbcDataSourceON);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"JDBCDataSource MBean created");
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCDataSource MBean", (Throwable)e);
        }
        JDBCDriver jdbcDriverMBean = null;
        String jdbcDriverON = null;
        try {
            void jdbcDriverClassName;
            void jdbcDriverName;
            jdbcDriverON = J2eeObjectName.getJDBCDriverName((String)domainName, (String)serverName, (String)jdbcDriverName);
            jdbcDriverMBean = new JDBCDriver(jdbcDriverON);
            jdbcDriverMBean.setDriverClassName((String)jdbcDriverClassName);
            this._getjmxService().registerModelMBean((Object)jdbcDriverMBean, jdbcDriverON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCDriver MBean", (Throwable)e);
        }
        jdbcDataSourceMBean.setJdbcDriver(jdbcDriverON);
        String string6 = jdbcDataSourceON;
        if (this._MregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringorg_ow2_jonas_dbm_internal_cm_ConnectionManager) {
            this._cm.exitCallback("registerJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringorg_ow2_jonas_dbm_internal_cm_ConnectionManager", (Object)string6);
        }
        return string6;
    }

    /*
     * WARNING - void declaration
     */
    private String unregisterJdbcDataSourceAndDriverMBean(String string, String string2, String string3) {
        void jdbcDataSourceName;
        void serverName;
        void domainName;
        if (this._MunregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("unregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_String");
        }
        String jdbcDataSourceON = J2eeObjectName.getJDBCDataSourceName((String)domainName, (String)serverName, (String)jdbcDataSourceName);
        ObjectName onJDBCDataSource = null;
        String jdbcDriverName = null;
        ObjectName onJDBCDriver = null;
        MBeanServer mbeanServer = this._getjmxService().getJmxServer();
        try {
            onJDBCDataSource = ObjectName.getInstance(jdbcDataSourceON);
            jdbcDriverName = (String)mbeanServer.getAttribute(onJDBCDataSource, "jdbcDriver");
            onJDBCDriver = ObjectName.getInstance(jdbcDriverName);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unregister MBean for datasource " + (String)jdbcDataSourceName), (Throwable)e);
        }
        this._getjmxService().unregisterModelMBean(onJDBCDataSource);
        this._getjmxService().unregisterModelMBean(onJDBCDriver);
        String string4 = jdbcDataSourceON;
        if (this._MunregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("unregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_String", (Object)string4);
        }
        return string4;
    }

    private void unregisterAllDataSourceAndDriverMBeans() {
        if (this._MunregisterAllDataSourceAndDriverMBeans) {
            this._cm.entryCallback("unregisterAllDataSourceAndDriverMBeans");
        }
        String[] ons = this._getjdbcResourceMBean().getJdbcDataSources();
        ObjectName onJDBCDataSource = null;
        ObjectName onJDBCDriver = null;
        String dataSourceName = null;
        for (int i = 0; i < ons.length; ++i) {
            try {
                onJDBCDataSource = ObjectName.getInstance(ons[i]);
            }
            catch (MalformedObjectNameException e) {
                logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot unegister JDBCDataSource MBean", (Throwable)e);
                continue;
            }
            dataSourceName = onJDBCDataSource.getKeyProperty("name");
            MBeanServer mbeanServer = this._getjmxService().getJmxServer();
            String jdbcDriverName = null;
            try {
                jdbcDriverName = (String)mbeanServer.getAttribute(onJDBCDataSource, "jdbcDriver");
            }
            catch (Exception e) {
                logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unegister JDBCDriver MBean for datasource " + dataSourceName), (Throwable)e);
                continue;
            }
            try {
                onJDBCDriver = new ObjectName(jdbcDriverName);
            }
            catch (MalformedObjectNameException e) {
                logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unegister JDBCDriver MBean" + dataSourceName), (Throwable)e);
                continue;
            }
            this._getjmxService().unregisterModelMBean(onJDBCDataSource);
            this._getjmxService().unregisterModelMBean(onJDBCDriver);
            this._getjdbcResourceMBean().removeJdbcDataSource(onJDBCDataSource.toString());
        }
        Object var9_12 = null;
        if (this._MunregisterAllDataSourceAndDriverMBeans) {
            this._cm.exitCallback("unregisterAllDataSourceAndDriverMBeans", var9_12);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void unregisterJdbcResourceMBean(String string, String string2, String string3) {
        if (this._MunregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.entryCallback("unregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String");
        }
        try {
            void resourceName;
            void serverName;
            void domainName;
            ObjectName jdbcResourceOn = J2eeObjectName.JDBCResource((String)domainName, (String)serverName, (String)resourceName);
            this._getjmxService().unregisterModelMBean(jdbcResourceOn);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot unegister JDBCResource MBean", (Throwable)e);
        }
        Object var5_6 = null;
        if (this._MunregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String) {
            this._cm.exitCallback("unregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String", var5_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTransactionService(TransactionService transactionService) {
        void txService;
        if (this._MsetTransactionServiceorg_ow2_jonas_tm_TransactionService) {
            this._cm.entryCallback("setTransactionServiceorg_ow2_jonas_tm_TransactionService");
        }
        this._settxService((TransactionService)txService);
        Object var2_2 = null;
        if (this._MsetTransactionServiceorg_ow2_jonas_tm_TransactionService) {
            this._cm.exitCallback("setTransactionServiceorg_ow2_jonas_tm_TransactionService", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRegistryService(RegistryService registryService) {
        void registry;
        if (this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService) {
            this._cm.entryCallback("setRegistryServiceorg_ow2_jonas_registry_RegistryService");
        }
        this._setregistryService((RegistryService)registry);
        Object var2_2 = null;
        if (this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService) {
            this._cm.exitCallback("setRegistryServiceorg_ow2_jonas_registry_RegistryService", var2_2);
        }
    }

    private RegistryService getRegistryService() {
        if (this._MgetRegistryService) {
            this._cm.entryCallback("getRegistryService");
        }
        RegistryService registryService = this._getregistryService();
        if (this._MgetRegistryService) {
            this._cm.exitCallback("getRegistryService", (Object)registryService);
        }
        return registryService;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("bindedDatasources")) {
                this._FbindedDatasources = true;
            }
            if (set.contains("ictx")) {
                this._Fictx = true;
            }
            if (set.contains("jdbcResourceMBean")) {
                this._FjdbcResourceMBean = true;
            }
            if (set.contains("cmList")) {
                this._FcmList = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("registryService")) {
                this._FregistryService = true;
            }
            if (set.contains("dataSourceNames")) {
                this._FdataSourceNames = true;
            }
            if (set.contains("JDBC_RESOURCE_NAME")) {
                this._FJDBC_RESOURCE_NAME = true;
            }
            if (set.contains("txService")) {
                this._FtxService = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("setDatasourcesjava_lang_String")) {
                this._MsetDatasourcesjava_lang_String = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("createDataSourcejava_lang_Stringjava_util_Properties")) {
                this._McreateDataSourcejava_lang_Stringjava_util_Properties = true;
            }
            if (set.contains("unbindDataSources")) {
                this._MunbindDataSources = true;
            }
            if (set.contains("getConnectionManagerjava_lang_String")) {
                this._MgetConnectionManagerjava_lang_String = true;
            }
            if (set.contains("getDSList")) {
                this._MgetDSList = true;
            }
            if (set.contains("getDataSourcePropertiesFiles")) {
                this._MgetDataSourcePropertiesFiles = true;
            }
            if (set.contains("getCurrentNumberOfDataSource")) {
                this._MgetCurrentNumberOfDataSource = true;
            }
            if (set.contains("getTotalCurrentNumberOfJDBCConnectionOpen")) {
                this._MgetTotalCurrentNumberOfJDBCConnectionOpen = true;
            }
            if (set.contains("isLoadedDataSourcejava_lang_String")) {
                this._MisLoadedDataSourcejava_lang_String = true;
            }
            if (set.contains("unloadDataSourcejava_lang_String")) {
                this._MunloadDataSourcejava_lang_String = true;
            }
            if (set.contains("getDataSourcePropertiesFilejava_lang_String")) {
                this._MgetDataSourcePropertiesFilejava_lang_String = true;
            }
            if (set.contains("loadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean")) {
                this._MloadDataSourcejava_lang_Stringjava_util_Propertiesjava_lang_Boolean = true;
            }
            if (set.contains("getDatasourceNamejava_lang_String")) {
                this._MgetDatasourceNamejava_lang_String = true;
            }
            if (set.contains("registerDbmServiceMBeanjava_lang_Objectjava_lang_String")) {
                this._MregisterDbmServiceMBeanjava_lang_Objectjava_lang_String = true;
            }
            if (set.contains("unregisterDbmServiceMBeanjava_lang_String")) {
                this._MunregisterDbmServiceMBeanjava_lang_String = true;
            }
            if (set.contains("registerJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String")) {
                this._MregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("registerJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringorg_ow2_jonas_dbm_internal_cm_ConnectionManager")) {
                this._MregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringjava_lang_Stringorg_ow2_jonas_dbm_internal_cm_ConnectionManager = true;
            }
            if (set.contains("unregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_String")) {
                this._MunregisterJdbcDataSourceAndDriverMBeanjava_lang_Stringjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("unregisterAllDataSourceAndDriverMBeans")) {
                this._MunregisterAllDataSourceAndDriverMBeans = true;
            }
            if (set.contains("unregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String")) {
                this._MunregisterJdbcResourceMBeanjava_lang_Stringjava_lang_Stringjava_lang_String = true;
            }
            if (set.contains("setTransactionServiceorg_ow2_jonas_tm_TransactionService")) {
                this._MsetTransactionServiceorg_ow2_jonas_tm_TransactionService = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setRegistryServiceorg_ow2_jonas_registry_RegistryService")) {
                this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("getRegistryService")) {
                this._MgetRegistryService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

