/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.archive;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.ow2.util.ee.deploy.api.archive.ArchiveFactory;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.archive.IArchiveManager;
import org.ow2.util.ee.deploy.impl.archive.DefaultArchiveFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveManager
implements IArchiveManager {
    private static Log logger = LogFactory.getLog(ArchiveManager.class);
    private static ArchiveManager archiveManager;
    private Map<Class<?>, ArchiveFactory<?>> factories = new HashMap();

    private ArchiveManager() {
        this.addFactory(new DefaultArchiveFactory());
    }

    public static ArchiveManager getInstance() {
        if (archiveManager == null) {
            archiveManager = new ArchiveManager();
        }
        return archiveManager;
    }

    public void addFactory(ArchiveFactory<?> factory) {
        Class<?> factoryClass = factory.getClass();
        Class<?> argumentClass = this.getSupportedType(factoryClass);
        logger.debug((Object)("Adding factory '" + factoryClass.getName() + "' for class '" + argumentClass + "'."), new Object[0]);
        this.factories.put(argumentClass, factory);
    }

    private Class<?> getSupportedType(Class<?> factoryClass) {
        Type[] generics = factoryClass.getGenericInterfaces();
        if (generics.length != 1) {
            throw new IllegalArgumentException("Invalid class, supports only class with a single generic");
        }
        Type factoryClassType = generics[0];
        ParameterizedType parameterType = null;
        if (!(factoryClassType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Object '" + factoryClassType + "' is not a ParameterizedType");
        }
        parameterType = (ParameterizedType)factoryClassType;
        Type[] arguments = parameterType.getActualTypeArguments();
        if (arguments.length != 1) {
            throw new IllegalArgumentException("Invalid class, supports only class with a single generic");
        }
        return (Class)arguments[0];
    }

    public void removeFactory(ArchiveFactory<?> factory) {
        Class<?> factoryClass = factory.getClass();
        Class<?> argumentClass = this.getSupportedType(factoryClass);
        if (this.factories.containsKey(argumentClass)) {
            logger.debug((Object)("Removing factory '" + factoryClass.getName() + "' for class '" + argumentClass + "'."), new Object[0]);
            this.factories.remove(argumentClass);
        } else {
            logger.debug((Object)("Factory '" + factoryClass.getName() + "' was not registered in the ArchiveManager."), new Object[0]);
        }
    }

    public IArchive getArchive(Object o) {
        Class<?> objectClass = o.getClass();
        ArchiveFactory<?> factory = this.factories.get(objectClass);
        if (factory == null) {
            for (Class<?> cls : this.factories.keySet()) {
                if (!cls.isAssignableFrom(objectClass) || factory != null) continue;
                factory = this.factories.get(cls);
            }
            if (factory == null) {
                throw new IllegalArgumentException("No factory found for the type '" + objectClass + "'.");
            }
        }
        return factory.create(o);
    }
}

