/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.iiop;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.ow2.carol.util.csiv2.SasPolicyFactory;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.security.iiop.Csiv2ClientInterceptor;
import org.ow2.jonas.security.iiop.Csiv2IorInterceptor;
import org.ow2.jonas.security.iiop.Csiv2ServerInterceptor;

public class Csiv2Initializer
extends LocalObject
implements ORBInitializer {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.security.csiv2");
    private static Logger loggerDetails = Log.getLogger((String)"org.ow2.jonas.security.csiv2_details");

    public void post_init(ORBInitInfo info) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Initializing SAS Interceptors");
        }
        Encoding encoding = new Encoding(0, 1, 2);
        Codec codec = null;
        try {
            codec = info.codec_factory().create_codec(encoding);
        }
        catch (UnknownEncoding ue) {
            String err = "Cannot use a given encoding : '" + ue.getMessage() + "'.";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new RuntimeException(err);
        }
        try {
            info.add_server_request_interceptor((ServerRequestInterceptor)new Csiv2ServerInterceptor(codec, logger, loggerDetails));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to register CSIv2 server interceptor : '" + e.getMessage() + "'."));
        }
        try {
            info.add_client_request_interceptor((ClientRequestInterceptor)new Csiv2ClientInterceptor(codec, logger, loggerDetails));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to register CSIv2 client interceptor : '" + e.getMessage() + "'."));
        }
        try {
            info.add_ior_interceptor((IORInterceptor)new Csiv2IorInterceptor(codec, logger, loggerDetails));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to register CSIv2 IOR interceptor : '" + e.getMessage() + "'."));
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Initializing SAS policy factory");
        }
        info.register_policy_factory(64377, (PolicyFactory)new SasPolicyFactory());
    }

    public void pre_init(ORBInitInfo info) {
    }
}

