/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployablemonitor;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.deployablemonitor.DeployableMonitor;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DeployableMonitorService
extends AbsServiceImpl
implements MonitoringService,
Pojo {
    private InstanceManager _cm;
    public static final String DEVELOPMENT_MODE_PROPERTY = "development";
    public static final String DIRECTORIES_LIST_PROPERTY = "directories";
    protected static final String JONAS_BASE = JProp.getJonasBase();
    public static final String DEFAULT_DIRECTORY = JONAS_BASE + File.separator + "deploy";
    private boolean _Flogger;
    private Log logger;
    private boolean _FdevelopmentMode;
    private boolean developmentMode;
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _Fdirectories;
    private List<File> directories;
    private boolean _FdeployableMonitor;
    private DeployableMonitor deployableMonitor;
    private boolean _FreadyToRunning;
    private boolean readyToRunning;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MdoStart;
    private boolean _MstartMonitoring;
    private boolean _MdoStop;
    private boolean _MsetDevelopmentboolean;
    private boolean _MsetDirectoriesjava_lang_String;
    private boolean _MsetExclusionsjava_lang_String;
    private boolean _MsetDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;
    private boolean _MfirstCheckEnded;
    private boolean _MisReadyToRunning;
    private boolean _MsetReadyToRunningboolean;

    private Log _getlogger() {
        if (!this._Flogger) {
            return this.logger;
        }
        return (Log)this._cm.getterCallback("logger");
    }

    private void _setlogger(Log log) {
        if (!this._Flogger) {
            this.logger = log;
            return;
        }
        this._cm.setterCallback("logger", (Object)log);
    }

    private boolean _getdevelopmentMode() {
        if (!this._FdevelopmentMode) {
            return this.developmentMode;
        }
        Object object = this._cm.getterCallback("developmentMode");
        Boolean bl = (Boolean)object;
        return bl;
    }

    private void _setdevelopmentMode(boolean bl) {
        if (!this._FdevelopmentMode) {
            this.developmentMode = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this._cm.setterCallback("developmentMode", (Object)bl2);
    }

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    private List _getdirectories() {
        if (!this._Fdirectories) {
            return this.directories;
        }
        return (List)this._cm.getterCallback(DIRECTORIES_LIST_PROPERTY);
    }

    private void _setdirectories(List list) {
        if (!this._Fdirectories) {
            this.directories = list;
            return;
        }
        this._cm.setterCallback(DIRECTORIES_LIST_PROPERTY, (Object)list);
    }

    private DeployableMonitor _getdeployableMonitor() {
        if (!this._FdeployableMonitor) {
            return this.deployableMonitor;
        }
        return (DeployableMonitor)this._cm.getterCallback("deployableMonitor");
    }

    private void _setdeployableMonitor(DeployableMonitor deployableMonitor) {
        if (!this._FdeployableMonitor) {
            this.deployableMonitor = deployableMonitor;
            return;
        }
        this._cm.setterCallback("deployableMonitor", (Object)deployableMonitor);
    }

    private boolean _getreadyToRunning() {
        if (!this._FreadyToRunning) {
            return this.readyToRunning;
        }
        Object object = this._cm.getterCallback("readyToRunning");
        Boolean bl = (Boolean)object;
        return bl;
    }

    private void _setreadyToRunning(boolean bl) {
        if (!this._FreadyToRunning) {
            this.readyToRunning = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this._cm.setterCallback("readyToRunning", (Object)bl2);
    }

    public DeployableMonitorService(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setlogger(LogFactory.getLog(DeployableMonitor.class));
        this._setdevelopmentMode(true);
        this._setjmxService(null);
        this._setdirectories(null);
        this._setdeployableMonitor(null);
        this._setreadyToRunning(false);
        this._setdirectories(new LinkedList());
        this._setdeployableMonitor(new DeployableMonitor(this));
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    protected void doStart() throws ServiceException {
        File defaultDirectory;
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        this._getlogger().info((Object)"Use the deploy directories ''{0}'', development mode is ''{1}''", new Object[]{this._getdirectories(), this._getdevelopmentMode()});
        if (this._getdeployableMonitor() == null) {
            this._setdeployableMonitor(new DeployableMonitor(this));
        }
        if (!(defaultDirectory = new File(DEFAULT_DIRECTORY)).exists()) {
            this._getlogger().info((Object)"Creating default deploy directory ''{0}''", new Object[]{defaultDirectory});
            defaultDirectory.mkdirs();
        }
        this._getdirectories().add(defaultDirectory);
        if (this._getjmxService() != null) {
            this._getjmxService().loadDescriptors(((Object)((Object)this)).getClass().getPackage().getName(), ((Object)((Object)this)).getClass().getClassLoader());
            try {
                this._getjmxService().registerModelMBean((Object)this, JonasObjectName.deployableMonitorService((String)this.getDomainName()));
            }
            catch (Exception e) {
                this._getlogger().warn((Object)"Cannot register MBean for Deployable Monitor service", new Object[]{e});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Object var3_4 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var3_4);
        }
    }

    public void startMonitoring() {
        if (this._MstartMonitoring) {
            this._cm.entryCallback("startMonitoring");
        }
        this._getlogger().debug((Object)"Start DeployableMonitor", new Object[0]);
        this._getdeployableMonitor().start();
        Object var1_1 = null;
        if (this._MstartMonitoring) {
            this._cm.exitCallback("startMonitoring", var1_1);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        if (this._getjmxService() != null) {
            try {
                this._getjmxService().unregisterModelMBean(JonasObjectName.deployableMonitorService((String)this.getDomainName()));
            }
            catch (Exception e) {
                this._getlogger().warn((Object)"Cannot unregister MBean for Deployable Monitor service", new Object[]{e});
            }
        }
        this._getdeployableMonitor().stopOrder();
        this._setdeployableMonitor(null);
        this._getlogger().info((Object)"DeployableMonitor stopped successfully", new Object[0]);
        Object var2_2 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDevelopment(boolean bl) {
        void mode;
        if (this._MsetDevelopmentboolean) {
            this._cm.entryCallback("setDevelopmentboolean");
        }
        this._setdevelopmentMode((boolean)mode);
        this._getdeployableMonitor().setDevelopmentMode((boolean)mode);
        Object var2_2 = null;
        if (this._MsetDevelopmentboolean) {
            this._cm.exitCallback("setDevelopmentboolean", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDirectories(String string) {
        void dirs;
        if (this._MsetDirectoriesjava_lang_String) {
            this._cm.entryCallback("setDirectoriesjava_lang_String");
        }
        List additionalDirectories = DeployableMonitorService.convertToList((String)dirs);
        for (String dir : additionalDirectories) {
            File tmpFile = new File(dir);
            if (!tmpFile.isAbsolute()) {
                tmpFile = new File(JONAS_BASE + File.separator + dir);
            }
            if (!tmpFile.exists()) {
                this._getlogger().warn((Object)"The given directory ''{0}'' is neither present on the filesystem or in JONAS_BASE ''{1}''", new Object[]{tmpFile, JONAS_BASE});
                continue;
            }
            this._getdirectories().add(tmpFile);
        }
        this._getdeployableMonitor().setDirectories(this._getdirectories());
        Object var6_6 = null;
        if (this._MsetDirectoriesjava_lang_String) {
            this._cm.exitCallback("setDirectoriesjava_lang_String", var6_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setExclusions(String string) {
        void exclusionList;
        if (this._MsetExclusionsjava_lang_String) {
            this._cm.entryCallback("setExclusionsjava_lang_String");
        }
        List exclusions = DeployableMonitorService.convertToList((String)exclusionList);
        this._getdeployableMonitor().setExclusionPatterns(exclusions);
        Object var3_3 = null;
        if (this._MsetExclusionsjava_lang_String) {
            this._cm.exitCallback("setExclusionsjava_lang_String", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDeployerManager(IDeployerManager iDeployerManager) {
        void deployerManager;
        if (this._MsetDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this._cm.entryCallback("setDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager");
        }
        this._getdeployableMonitor().setDeployerManager((IDeployerManager)deployerManager);
        Object var2_2 = null;
        if (this._MsetDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this._cm.exitCallback("setDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    public void firstCheckEnded() {
        if (this._MfirstCheckEnded) {
            this._cm.entryCallback("firstCheckEnded");
        }
        try {
            ObjectName on = JonasObjectName.deployableMonitorService((String)this.getDomainName());
            Attribute att = new Attribute("readyToRunning", true);
            this._getjmxService().getJmxServer().setAttribute(on, att);
        }
        catch (Exception e) {
            this._getlogger().warn((Object)"Problem when trying to modify 'readyToRunning' attribute", new Object[0]);
        }
        Object var3_4 = null;
        if (this._MfirstCheckEnded) {
            this._cm.exitCallback("firstCheckEnded", var3_4);
        }
    }

    public boolean isReadyToRunning() {
        if (this._MisReadyToRunning) {
            this._cm.entryCallback("isReadyToRunning");
        }
        Boolean bl = new Boolean(this._getreadyToRunning());
        if (this._MisReadyToRunning) {
            this._cm.exitCallback("isReadyToRunning", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void setReadyToRunning(boolean bl) {
        void readyToRunning;
        if (this._MsetReadyToRunningboolean) {
            this._cm.entryCallback("setReadyToRunningboolean");
        }
        this._setreadyToRunning((boolean)readyToRunning);
        Object var2_2 = null;
        if (this._MsetReadyToRunningboolean) {
            this._cm.exitCallback("setReadyToRunningboolean", var2_2);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("DEVELOPMENT_MODE_PROPERTY")) {
                this._FDEVELOPMENT_MODE_PROPERTY = true;
            }
            if (set.contains("DIRECTORIES_LIST_PROPERTY")) {
                this._FDIRECTORIES_LIST_PROPERTY = true;
            }
            if (set.contains(DIRECTORIES_LIST_PROPERTY)) {
                this._Fdirectories = true;
            }
            if (set.contains("JONAS_BASE")) {
                this._FJONAS_BASE = true;
            }
            if (set.contains("readyToRunning")) {
                this._FreadyToRunning = true;
            }
            if (set.contains("developmentMode")) {
                this._FdevelopmentMode = true;
            }
            if (set.contains("deployableMonitor")) {
                this._FdeployableMonitor = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("DEFAULT_DIRECTORY")) {
                this._FDEFAULT_DIRECTORY = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("startMonitoring")) {
                this._MstartMonitoring = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("setDevelopmentboolean")) {
                this._MsetDevelopmentboolean = true;
            }
            if (set.contains("setDirectoriesjava_lang_String")) {
                this._MsetDirectoriesjava_lang_String = true;
            }
            if (set.contains("setExclusionsjava_lang_String")) {
                this._MsetExclusionsjava_lang_String = true;
            }
            if (set.contains("setDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this._MsetDeployerManagerorg_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("firstCheckEnded")) {
                this._MfirstCheckEnded = true;
            }
            if (set.contains("isReadyToRunning")) {
                this._MisReadyToRunning = true;
            }
            if (set.contains("setReadyToRunningboolean")) {
                this._MsetReadyToRunningboolean = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

