/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.callback;

import java.io.IOException;
import java.security.cert.Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.ow2.jonas.security.auth.callback.CertificateCallback;

public class NoInputCallbackHandler
implements CallbackHandler {
    private String username = null;
    private String password = null;
    private Certificate cert = null;

    public NoInputCallbackHandler() throws Exception {
        throw new Exception("This class could only be used with the constructor NoInputCallbackHandler(String username, String password)");
    }

    public NoInputCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public NoInputCallbackHandler(String username, String password, Certificate cert) {
        this(username, password);
        this.cert = cert;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof CertificateCallback) {
                CertificateCallback cc = (CertificateCallback)callbacks[i];
                cc.setUserCertificate(this.cert);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

