/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.velocity.app.VelocityEngine;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.lib.JormCompiler;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp1Desc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.generators.genic.GenICException;
import org.ow2.jonas.generators.genic.GenICParameters;
import org.ow2.jonas.generators.genic.Source;
import org.ow2.jonas.lib.ejb21.jorm.RdbMappingBuilder;
import org.ow2.jonas.lib.util.BeanNaming;
import org.ow2.jonas.lib.util.Log;

public class BeanSources {
    private static final String JAVA_SUFFIX = ".java";
    private String wrpRemoteFileName = null;
    private String wrpLocalFileName = null;
    private String wrpHomeFileName = null;
    private String wrpHomeClusterFileName = null;
    private String wrpRemoteClusterFileName = null;
    private String wrpLocalHomeFileName = null;
    private String wrpHandleFileName = null;
    private String wrpBeanFileName = null;
    private String wrpServiceEndpointFileName = null;
    private String wrpSEHomeFileName = null;
    private String itfCohCmp2Entity = null;
    private ArrayList sources;
    private ArrayList noRemoteJava;
    private String outdir = null;
    private BeanDesc dd = null;
    private JormCompiler jormCompiler;
    private Manager manager = null;
    private Logger logger = Log.getLogger((String)"org.ow2.jonas.generators.genic");
    private GenICParameters gp;
    private VelocityEngine ve;

    public BeanSources(BeanDesc beanDesc, GenICParameters gp, VelocityEngine ve) {
        this.dd = beanDesc;
        this.gp = gp;
        this.outdir = gp.getOutputDirectory();
        this.ve = ve;
        this.sources = new ArrayList();
        this.noRemoteJava = new ArrayList();
    }

    public void init(JormCompiler jc, Manager mgr) throws GenICException {
        SessionStatelessDesc ssd;
        this.jormCompiler = jc;
        this.manager = mgr;
        if (this.dd.getHomeClass() != null) {
            this.wrpHomeFileName = this.outdir.length() > 0 ? this.outdir + File.separatorChar + BeanNaming.getPath((String)this.dd.getFullWrpHomeName()) : this.dd.getWrpHomeName();
            this.wrpHomeFileName = this.wrpHomeFileName.concat(JAVA_SUFFIX);
            this.sources.add(new Source(this.dd, this.wrpHomeFileName, 0, this.ve, this.manager));
            if (this.dd instanceof EntityDesc) {
                this.wrpHandleFileName = this.outdir.length() > 0 ? this.outdir + File.separatorChar + BeanNaming.getPath((String)this.dd.getFullWrpHandleName()) : this.dd.getWrpHandleName();
                this.wrpHandleFileName = this.wrpHandleFileName.concat(JAVA_SUFFIX);
                this.noRemoteJava.add(this.wrpHandleFileName);
                this.sources.add(new Source(this.dd, this.wrpHandleFileName, 4, this.ve, this.manager));
            }
        }
        if (this.dd.getRemoteClass() != null) {
            this.wrpRemoteFileName = this.outdir.length() > 0 ? this.outdir + File.separatorChar + BeanNaming.getPath((String)this.dd.getFullWrpRemoteName()) : this.dd.getWrpRemoteName();
            this.wrpRemoteFileName = this.wrpRemoteFileName.concat(JAVA_SUFFIX);
            this.sources.add(new Source(this.dd, this.wrpRemoteFileName, 2, this.ve, this.manager));
        }
        if (this.dd.getLocalHomeClass() != null) {
            this.wrpLocalHomeFileName = this.outdir.length() > 0 ? this.outdir + File.separatorChar + BeanNaming.getPath((String)this.dd.getFullWrpLocalHomeName()) : this.dd.getWrpLocalHomeName();
            this.wrpLocalHomeFileName = this.wrpLocalHomeFileName.concat(JAVA_SUFFIX);
            this.noRemoteJava.add(this.wrpLocalHomeFileName);
            this.sources.add(new Source(this.dd, this.wrpLocalHomeFileName, 1, this.ve, this.manager));
        }
        if (this.dd.getLocalClass() != null) {
            this.wrpLocalFileName = this.outdir.length() > 0 ? this.outdir + File.separatorChar + BeanNaming.getPath((String)this.dd.getFullWrpLocalName()) : this.dd.getWrpLocalName();
            this.wrpLocalFileName = this.wrpLocalFileName.concat(JAVA_SUFFIX);
            this.noRemoteJava.add(this.wrpLocalFileName);
            this.sources.add(new Source(this.dd, this.wrpLocalFileName, 3, this.ve, this.manager));
        }
        if (this.dd instanceof SessionStatelessDesc && (ssd = (SessionStatelessDesc)this.dd).getServiceEndpointClass() != null) {
            this.wrpServiceEndpointFileName = this.outdir.length() > 0 ? this.outdir + File.separatorChar + BeanNaming.getPath((String)ssd.getFullWrpServiceEndpointName()) : ssd.getWrpServiceEndpointName();
            this.wrpServiceEndpointFileName = this.wrpServiceEndpointFileName.concat(JAVA_SUFFIX);
            this.sources.add(new Source(this.dd, this.wrpServiceEndpointFileName, 9, this.ve, this.manager));
            this.wrpSEHomeFileName = this.outdir.length() > 0 ? this.outdir + File.separatorChar + BeanNaming.getPath((String)ssd.getFullWrpSEHomeName()) : ssd.getWrpSEHomeName();
            this.wrpSEHomeFileName = this.wrpSEHomeFileName.concat(JAVA_SUFFIX);
            this.noRemoteJava.add(this.wrpSEHomeFileName);
            this.sources.add(new Source(this.dd, this.wrpSEHomeFileName, 10, this.ve, this.manager));
        }
        if (this.dd instanceof EntityJdbcCmp1Desc) {
            this.wrpBeanFileName = this.outdir.length() > 0 ? this.outdir + File.separatorChar + BeanNaming.getPath((String)this.dd.getFullDerivedBeanName()) : this.dd.getDerivedBeanName();
            this.wrpBeanFileName = this.wrpBeanFileName.concat(JAVA_SUFFIX);
            this.noRemoteJava.add(this.wrpBeanFileName);
            this.sources.add(new Source(this.dd, this.wrpBeanFileName, 5, this.ve, this.manager));
        }
        if (this.dd instanceof EntityCmp2Desc) {
            EntityCmp2Desc ecd = (EntityCmp2Desc)this.dd;
            if (this.outdir.length() > 0) {
                this.wrpBeanFileName = this.outdir + File.separatorChar + BeanNaming.getPath((String)this.dd.getFullDerivedBeanName()) + JAVA_SUFFIX;
                if (ecd.needJormCoherenceHelper()) {
                    this.itfCohCmp2Entity = this.outdir + File.separatorChar + BeanNaming.getPath((String)ecd.getJormCoherenceHelperFQItfName()) + JAVA_SUFFIX;
                }
            } else {
                this.wrpBeanFileName = BeanNaming.getPath((String)this.dd.getDerivedBeanName()) + JAVA_SUFFIX;
                if (ecd.needJormCoherenceHelper()) {
                    this.itfCohCmp2Entity = BeanNaming.getPath((String)ecd.getJormCoherenceHelperItfName()) + JAVA_SUFFIX;
                }
            }
            if (ecd.needJormCoherenceHelper()) {
                this.sources.add(new Source(this.dd, this.itfCohCmp2Entity, 7, this.ve, this.manager));
                this.noRemoteJava.add(this.itfCohCmp2Entity);
            }
            this.noRemoteJava.add(this.wrpBeanFileName);
            this.sources.add(new Source(this.dd, this.wrpBeanFileName, 5, this.ve, this.manager));
        }
    }

    public void generate() throws GenICException {
        for (Source src : this.sources) {
            src.generate();
        }
    }

    public void jormCompile(ArrayList jormList) throws GenICException {
        if (this.dd instanceof EntityCmp2Desc) {
            EntityCmp2Desc ecd = (EntityCmp2Desc)this.dd;
            JormCompilerParameter cp = this.jormCompiler.getCompilerParameter();
            cp.setProjectName(RdbMappingBuilder.getProjectName());
            cp.setKeepSrc(true);
            cp.setOutput(this.outdir);
            cp.setClassMappingInheritance("org.ow2.jonas.lib.ejb21.jorm.RdbFactory");
            cp.setStateGenerated(true);
            cp.setStateInheritance(ecd.getEjbClass().getName());
            switch (ecd.getLockPolicy()) {
                case 0: {
                    cp.setBindingInheritance("org.ow2.jonas.lib.ejb21.JEntitySwitchCRU");
                    break;
                }
                case 1: {
                    cp.setBindingInheritance("org.ow2.jonas.lib.ejb21.JEntitySwitchCS");
                    break;
                }
                case 6: {
                    cp.setBindingInheritance("org.ow2.jonas.lib.ejb21.JEntitySwitchCST");
                    break;
                }
                case 2: {
                    cp.setBindingInheritance("org.ow2.jonas.lib.ejb21.JEntitySwitchCRC");
                    break;
                }
                case 3: {
                    cp.setBindingInheritance("org.ow2.jonas.lib.ejb21.JEntitySwitchDB");
                    break;
                }
                case 4: {
                    cp.setBindingInheritance("org.ow2.jonas.lib.ejb21.JEntitySwitchRO");
                    break;
                }
                case 5: {
                    cp.setBindingInheritance("org.ow2.jonas.lib.ejb21.JEntitySwitchCRW");
                    break;
                }
                default: {
                    throw new GenICException("Cannot find JEntitySwitch: Unknown lock policy");
                }
            }
            Collection jormflist = null;
            try {
                jormflist = this.jormCompiler.generateFiles((Collection)jormList);
            }
            catch (Exception e) {
                throw new GenICException("Problem during jorm generation", e);
            }
            for (String file : jormflist) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Jorm generated file: " + file));
                this.noRemoteJava.add(file);
            }
        }
    }

    public String getEjbName() {
        return this.dd.getEjbName();
    }

    public String getWrpHomeFileName() {
        return this.wrpHomeFileName;
    }

    public String getWrpHomeClusterFileName() {
        return this.wrpHomeClusterFileName;
    }

    public String getWrpRemoteClusterFileName() {
        return this.wrpRemoteClusterFileName;
    }

    public String getWrpRemoteFileName() {
        return this.wrpRemoteFileName;
    }

    public String getWrpRemoteClassName() {
        return this.dd.getFullWrpRemoteName();
    }

    public String getWrpServiceEndpointFileName() {
        return this.wrpServiceEndpointFileName;
    }

    public String getWrpSEHomeFileName() {
        return this.wrpSEHomeFileName;
    }

    public String getWrpServiceEndpointClassName() {
        if (this.dd instanceof SessionStatelessDesc) {
            return ((SessionStatelessDesc)this.dd).getFullWrpServiceEndpointName();
        }
        return null;
    }

    public String getWrpHomeClassName() {
        return this.dd.getFullWrpHomeName();
    }

    public Collection getNoRemoteJavas() {
        return this.noRemoteJava;
    }
}

