/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cluster.daemon.mbean;

import java.util.ArrayList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jonas.cluster.daemon.mbean.JMXRemoteException;
import org.ow2.jonas.cluster.daemon.mbean.MBeanServerException;

public final class MBeanServerHelper {
    private static String idMbeanServer = null;
    private static final String DEFAULT_DOMAIN_NAME = "JOnAS";

    private MBeanServerHelper() {
    }

    public static MBeanServer getMBeanServer() throws JMXRemoteException {
        if (MBeanServerHelper.getInternalMBeanServer() != null) {
            return MBeanServerHelper.getInternalMBeanServer();
        }
        throw new JMXRemoteException("No running MBeanServer was found.");
    }

    private static MBeanServer getInternalMBeanServer() {
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
        if (mbeanServers.size() > 0) {
            return (MBeanServer)mbeanServers.get(0);
        }
        return null;
    }

    public static synchronized void startMBeanServer(String domainName) throws MBeanServerException {
        MBeanServer mbeanServer = MBeanServerHelper.getInternalMBeanServer();
        if (mbeanServer == null) {
            mbeanServer = domainName == null ? MBeanServerFactory.createMBeanServer(DEFAULT_DOMAIN_NAME) : MBeanServerFactory.createMBeanServer(domainName);
        }
        ObjectName mbeanServerDelegate = null;
        try {
            mbeanServerDelegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            throw new MBeanServerException("Cannot build an objectName", e);
        }
        catch (NullPointerException e) {
            throw new MBeanServerException("Cannot build an objectName", e);
        }
        try {
            idMbeanServer = (String)mbeanServer.getAttribute(mbeanServerDelegate, "MBeanServerId");
        }
        catch (AttributeNotFoundException e) {
            throw new MBeanServerException("Cannot get an attribute on MBeanserver.", e);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanServerException("Cannot get an attribute on MBeanserver.", e);
        }
        catch (MBeanException e) {
            throw new MBeanServerException("Cannot get an attribute on MBeanserver.", e);
        }
        catch (ReflectionException e) {
            throw new MBeanServerException("Cannot get an attribute on MBeanserver.", e);
        }
    }

    protected static String getIdMbeanServer() {
        return idMbeanServer;
    }
}

