/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.lib.ejb21.JEntityContext;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntityHome;
import org.ow2.jonas.lib.ejb21.JEntityLocal;
import org.ow2.jonas.lib.ejb21.JEntityLocalHome;
import org.ow2.jonas.lib.ejb21.JEntityRemote;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JTimerService;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.timer.TraceTimer;

public abstract class JEntitySwitch {
    protected JEntityFactory bf;
    protected Object pk = null;
    protected JEntityLocal local = null;
    protected JEntityRemote remote = null;
    protected long inactivityTimeout;
    protected long readTimeout;
    protected boolean shared;
    protected int lockpolicy;
    protected boolean txUpdates = true;
    protected TimerService myTimerService = null;
    protected int countIH = 0;
    protected int countIT = 0;
    protected int waiters = 0;
    protected boolean inDirtyList = false;
    protected boolean mustReload = false;
    protected boolean mustStore = false;
    protected boolean todiscard = false;
    protected Transaction runningtx = null;
    protected Transaction writingtx = null;
    protected long deadlockTimeout;
    protected ArrayList<Transaction> blockedtx = new ArrayList();
    protected boolean isremoved = false;
    protected boolean isdetached = false;
    protected static int counter = 0;
    protected String ident = "0000 ";
    protected long estimestamp = System.currentTimeMillis();
    protected static final long FEW_SECONDS = 2000L;
    private static final int MAX_NB_RETRY = 2;
    protected boolean lazyregister = false;
    protected boolean reentrant;
    static final int ALL_DONE = 0;
    static final int STORED = 1;
    static final int NOT_DONE = 2;

    abstract JEntityContext getContext4Tx(Transaction var1);

    abstract void setContext4Tx(Transaction var1, JEntityContext var2);

    abstract void removeContext4Tx(Transaction var1);

    protected abstract void initpolicy(JEntityFactory var1);

    public abstract int passivateIH(boolean var1, boolean var2);

    public abstract void endIH();

    public void init(JEntityFactory bf, Object pk) {
        this.bf = bf;
        this.pk = pk;
        this.isremoved = false;
        if (pk == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"Init Entity Switch with a null PK!");
            throw new EJBException("Init Entity Switch with a null PK!");
        }
        this.shared = bf.isShared();
        this.reentrant = bf.isReentrant();
        this.inactivityTimeout = bf.getInactivityTimeout() * 1000;
        this.deadlockTimeout = bf.getDeadlockTimeout() * 1000;
        this.readTimeout = bf.getReadTimeout() * 1000;
        this.initpolicy(bf);
        if (TraceEjb.isDebugSynchro() || TraceEjb.isDebugTx()) {
            String pks = pk.toString();
            this.ident = "<" + counter + ":" + pks + "> ";
        }
        ++counter;
        this.countIH = 0;
        this.countIT = 0;
        this.waiters = 0;
        if (bf.getHome() != null) {
            try {
                this.remote = ((JEntityHome)bf.getHome()).createRemoteObject();
                this.remote.setEntitySwitch(this);
            }
            catch (RemoteException e) {
                throw new EJBException("cannot create Remote Object", (Exception)e);
            }
        }
        if (bf.getLocalHome() != null) {
            this.local = ((JEntityLocalHome)bf.getLocalHome()).createLocalObject();
            this.local.setEntitySwitch(this);
        }
        this.estimestamp = System.currentTimeMillis() + 2000L;
    }

    public boolean lazyRegistering() {
        return this.lazyregister;
    }

    public JEntityLocal getLocal() {
        return this.local;
    }

    public JEntityRemote getRemote() {
        return this.remote;
    }

    public TimerService getEntityTimerService() {
        if (this.pk == null) {
            throw new IllegalStateException();
        }
        if (this.myTimerService == null) {
            this.myTimerService = new JTimerService(this);
        }
        return this.myTimerService;
    }

    public synchronized void notifyWriting(Transaction tx, JEntityContext bctx) {
        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)this.ident);
        if (this.writingtx != null) {
            if (!tx.equals(this.writingtx)) {
                TraceEjb.logger.log(BasicLevel.WARN, (Object)("Conflict with " + this.writingtx));
                TraceEjb.logger.log(BasicLevel.WARN, (Object)("Current Tx is " + tx));
                try {
                    tx.setRollbackOnly();
                }
                catch (SystemException e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot set current transaction RollbackOnly");
                }
                throw new EJBException("Conflict writing entity bean");
            }
        } else {
            if (this.lazyregister) {
                if (TraceEjb.isDebugTx()) {
                    TraceEjb.tx.log(BasicLevel.DEBUG, (Object)(this.ident + " Register Ctx on " + tx));
                }
                this.registerCtx(tx, bctx);
            }
            if (TraceEjb.isDebugTx()) {
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)(this.ident + " Set writingtx"));
            }
            this.writingtx = tx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyTimeout(Timer timer) {
        if (this.bf.isStopped()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Container stopped");
            return;
        }
        if (this.isremoved) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Bean is removed");
            return;
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)this.ident);
        }
        boolean committed = false;
        int nbretry = 0;
        while (!committed) {
            if (nbretry >= 2) return;
            RequestCtx rctx = this.bf.preInvoke(this.bf.getTimerTxAttribute());
            try {
                JEntityContext bctx = this.getICtx(rctx.currTx, false);
                EntityBean eb = bctx.getInstance();
                this.bf.checkSecurity(null);
                if (!(eb instanceof TimedObject)) throw new EJBException("The bean does not implement the `TimedObject` interface");
                TimedObject instance = (TimedObject)eb;
                instance.ejbTimeout(timer);
                committed = rctx.currTx == null || rctx.currTx.getStatus() != 1;
            }
            catch (EJBException e) {
                try {
                    rctx.sysExc = e;
                    throw e;
                    catch (RuntimeException e2) {
                        rctx.sysExc = e2;
                        throw new EJBException("RuntimeException thrown by an enterprise Bean", (Exception)e2);
                    }
                    catch (Error e3) {
                        rctx.sysExc = e3;
                        throw new EJBException("Error thrown by an enterprise Bean" + e3);
                    }
                    catch (RemoteException e4) {
                        rctx.sysExc = e4;
                        throw new EJBException("Remote Exception raised:", (Exception)e4);
                    }
                    catch (SystemException e5) {
                        rctx.sysExc = e5;
                        throw new EJBException("Cannot get transaction status:", (Exception)((Object)e5));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.bf.postInvoke(rctx);
                        this.releaseICtx(rctx.currTx, rctx.sysExc != null);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        this.releaseICtx(rctx.currTx, rctx.sysExc != null);
                        throw throwable2;
                    }
                }
            }
            try {
                this.bf.postInvoke(rctx);
                this.releaseICtx(rctx.currTx, rctx.sysExc != null);
            }
            catch (Throwable throwable) {
                this.releaseICtx(rctx.currTx, rctx.sysExc != null);
                throw throwable;
            }
            ++nbretry;
        }
    }

    public Object getPrimaryKey() {
        if (this.pk == null) {
            throw new IllegalStateException();
        }
        return this.pk;
    }

    public void bindICtx(Transaction tx, JEntityContext bctx) {
        if (TraceEjb.isDebugSynchro()) {
            TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " tx=" + tx));
        }
        this.mapICtx(tx, bctx, true, false, false);
    }

    public synchronized boolean tryBindICtx(Transaction tx, JEntityContext bctx, boolean simple) throws ObjectNotFoundException {
        if (TraceEjb.isDebugSynchro()) {
            TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " tx=" + tx));
        }
        if (this.getContext4Tx(tx) != null) {
            if (TraceEjb.isDebugContext()) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)(this.ident + "context already mapped!"));
            }
            if (this.getContext4Tx(tx).isMarkedRemoved()) {
                if (TraceEjb.isDebugContext()) {
                    TraceEjb.context.log(BasicLevel.DEBUG, (Object)(this.ident + " currently being removed"));
                }
                if (simple) {
                    throw new ObjectNotFoundException("Instance is currently being removed");
                }
                return false;
            }
            return false;
        }
        boolean isdirty = false;
        try {
            isdirty = bctx.initEntityContext(this);
            bctx.activate(true);
        }
        catch (Exception e) {
            TraceEjb.synchro.log(BasicLevel.WARN, (Object)(this.ident + "Cannot bind Ctx: " + e));
            return false;
        }
        this.setContext4Tx(tx, bctx);
        if (!this.lazyregister || isdirty) {
            if (tx == null) {
                if (TraceEjb.isDebugSynchro()) {
                    TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "IH find"));
                }
            } else {
                if (TraceEjb.isDebugTx()) {
                    TraceEjb.tx.log(BasicLevel.DEBUG, (Object)(this.ident + "IT find: registerCtx"));
                }
                this.registerCtx(tx, bctx);
            }
        }
        return true;
    }

    public JEntityContext getICtx(Transaction tx, JEntityContext newctx) {
        return this.mapICtx(tx, newctx, false, false, false);
    }

    public JEntityContext getICtx(Transaction tx, boolean checkr) {
        return this.mapICtx(tx, null, false, true, checkr);
    }

    public synchronized boolean terminate(Transaction tx) {
        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)this.ident);
        this.waitmyturn(tx);
        JEntityContext jec = this.getContext4Tx(tx);
        if (jec != null) {
            if (this.todiscard || jec.isMarkedRemoved()) {
                TraceEjb.logger.log(BasicLevel.DEBUG, (Object)"will discardContext");
                this.discardContext(tx, true, true);
            } else {
                try {
                    jec.storeIfModified();
                }
                catch (Exception e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)this.ident, (Object)"error while storing bean state:", (Object)e);
                }
                jec.passivate();
                this.discardContext(tx, false, true);
            }
            if (this.waiters > 0) {
                if (TraceEjb.isDebugSynchro()) {
                    TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " notify"));
                }
                this.notifyAll();
            }
        }
        return true;
    }

    abstract void waitmyturn(Transaction var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JEntityContext mapICtx(Transaction tx, JEntityContext bctx, boolean forced, boolean holdit, boolean checkreentrance) {
        try {
            if (this.bf == null) {
                TraceEjb.synchro.log(BasicLevel.ERROR, (Object)"JEntitySwitch not initialized!");
                throw new EJBException("JEntitySwitch not initialized");
            }
            if (TraceEjb.isDebugSynchro()) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " tx=" + tx));
            }
            if (!this.reentrant && checkreentrance) {
                if (this.runningtx != null && this.countIT > 0 && tx != null && tx.equals(this.runningtx)) {
                    throw new EJBException("non-reentrant bean accessed twice in same transaction");
                }
                if (tx == null && this.countIH > 0) {
                    throw new EJBException("non-reentrant bean accessed twice outside transaction");
                }
            }
            this.waitmyturn(tx);
            this.estimestamp = System.currentTimeMillis() + 2000L;
            if (this.isdetached) {
                JEntityFactory fact = this.bf;
                JEntitySwitch old = fact.existEJB(this.getPrimaryKey(), this);
                if (old != null) {
                    throw new NoSuchObjectLocalException("Inactivity timeout expired");
                }
                this.isdetached = false;
            }
            boolean newtrans = false;
            boolean isdirty = false;
            JEntityContext jec = this.getContext4Tx(tx);
            if (forced) {
                HaService haService;
                if (jec != null) {
                    if (TraceEjb.isDebugContext()) {
                        TraceEjb.context.log(BasicLevel.DEBUG, (Object)(this.ident + "new context is enforced!"));
                    }
                    this.discardContext(tx, false, true);
                }
                jec = bctx;
                this.setContext4Tx(tx, jec);
                isdirty = jec.initEntityContext(this);
                newtrans = true;
                this.isremoved = false;
                if (this.bf.isClusterReplicated && (haService = this.bf.cont.getHaService()) != null && haService.isStarted()) {
                    haService.addEntityBean((EntityContext)jec);
                }
            } else {
                if (this.isremoved) {
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + " has been removed."));
                    throw new NoSuchObjectLocalException("Try to access a bean previously removed");
                }
                if (jec != null) {
                    if (this.todiscard) {
                        TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + " has been discarded."));
                        throw new NoSuchObjectLocalException("Try to access a bean previously discarded");
                    }
                    if (bctx != null) {
                        if (TraceEjb.isDebugContext()) {
                            TraceEjb.context.log(BasicLevel.DEBUG, (Object)(this.ident + " a context was supplied"));
                        }
                        if (bctx.getMyTx() != null) {
                            TraceEjb.context.log(BasicLevel.WARN, (Object)"Will forget Tx!");
                        }
                        this.bf.releaseJContext(bctx, 2);
                    }
                    if (this.runningtx == null && this.lockpolicy != 3) {
                        newtrans = true;
                    }
                    jec.reuseEntityContext(newtrans);
                } else {
                    jec = bctx != null ? bctx : this.bf.getJContext(this);
                    isdirty = jec.initEntityContext(this);
                    jec.activate(true);
                    this.setContext4Tx(tx, jec);
                    newtrans = true;
                }
            }
            if (tx != null) {
                if (newtrans && (!this.lazyregister || isdirty)) {
                    try {
                        this.registerCtx(tx, jec);
                        if (TraceEjb.isDebugSynchro()) {
                            TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: new tx, registerSynchronization"));
                        }
                    }
                    catch (IllegalStateException e) {
                        if (TraceEjb.synchro.isLoggable(BasicLevel.WARN)) {
                            TraceEjb.synchro.log(BasicLevel.WARN, (Object)(this.ident + "mapICtx IT: not registered!"), (Throwable)e);
                        }
                    }
                }
            } else {
                if (holdit) {
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IH count=" + this.countIH));
                    }
                    if ((this.shared || this.mustReload) && this.countIH == 0) {
                        jec.activate(false);
                        this.mustReload = false;
                    }
                }
                if (!this.inDirtyList && !this.txUpdates) {
                    this.inDirtyList = true;
                    this.bf.registerEJB(this);
                }
            }
            JEntityContext jEntityContext = jec;
            return jEntityContext;
        }
        finally {
            if (holdit) {
                if (tx == null) {
                    ++this.countIH;
                } else {
                    ++this.countIT;
                }
            }
        }
    }

    public Transaction getBlockingTx(Transaction testedtx) {
        Transaction ret = null;
        if (this.runningtx != null && this.blockedtx.size() > 0) {
            try {
                for (Transaction tx : this.blockedtx) {
                    if (!tx.equals(testedtx)) continue;
                    ret = this.runningtx;
                    break;
                }
            }
            catch (ConcurrentModificationException e) {
                TraceEjb.synchro.log(BasicLevel.WARN, (Object)"Concurrent access. Will retry later.");
            }
        }
        return ret;
    }

    public synchronized void releaseICtx(Transaction tx, boolean discard) {
        if (tx == null) {
            --this.countIH;
            if (TraceEjb.isDebugSynchro()) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " countIH=" + this.countIH));
            }
            if (this.countIH == 0) {
                JEntityContext jec = this.getContext4Tx(tx);
                if (jec == null) {
                    TraceEjb.context.log(BasicLevel.ERROR, (Object)(this.ident + " No context!"));
                    Thread.dumpStack();
                    return;
                }
                if (jec.isMarkedRemoved()) {
                    this.discardContext(tx, true, true);
                } else if (this.todiscard || discard) {
                    this.discardContext(tx, false, false);
                } else {
                    if (this.mustStore) {
                        block22: {
                            try {
                                jec.storeIfModified();
                            }
                            catch (EJBException e) {
                                if (!TraceEjb.isVerbose()) break block22;
                                TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + " ejbexception"), (Throwable)e);
                            }
                        }
                        this.mustStore = false;
                    }
                    if (this.bf.tooManyInstances()) {
                        if (TraceEjb.isDebugContext()) {
                            TraceEjb.context.log(BasicLevel.DEBUG, (Object)(jec + " passivated!"));
                        }
                        jec.passivate();
                        if (jec.getMyTx() != null) {
                            TraceEjb.context.log(BasicLevel.WARN, (Object)"Will forget Tx!");
                        }
                        this.bf.releaseJContext(jec, 0);
                        this.removeContext4Tx(tx);
                    }
                }
                if (this.waiters > 0) {
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " notify"));
                    }
                    this.notifyAll();
                }
            } else if (discard) {
                this.todiscard = true;
            }
        } else {
            --this.countIT;
            if (TraceEjb.isDebugSynchro()) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " countIT=" + this.countIT));
            }
            if (this.runningtx != null && discard) {
                if (TraceEjb.isDebugTx()) {
                    TraceEjb.tx.log(BasicLevel.DEBUG, (Object)(this.ident + " will be disarded when tx is over: " + this.runningtx));
                }
                this.todiscard = true;
            }
        }
    }

    public synchronized void forceDiscardICtx(Transaction tx) {
        this.discardContext(tx, true, true);
    }

    public synchronized void txCompleted(Transaction tx, boolean committed) {
        JEntityContext jec = this.getContext4Tx(tx);
        if (jec == null) {
            TraceEjb.context.log(BasicLevel.ERROR, (Object)(this.ident + " No context for this tx"));
            return;
        }
        this.runningtx = null;
        if (this.writingtx != null && tx.equals(this.writingtx)) {
            this.writingtx = null;
        }
        if (TraceEjb.isDebugSynchro()) {
            TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + (committed ? " commit" : " rollback")));
        }
        if (this.todiscard || jec.isNewInstance() && !committed) {
            if (TraceEjb.isDebugTx()) {
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)(this.ident + " will be discarded"));
            }
            if (this.writingtx != null) {
                TraceEjb.tx.log(BasicLevel.WARN, (Object)(this.ident + " has a running tx:" + this.writingtx));
            }
            this.discardContext(tx, !this.todiscard, false);
            return;
        }
        if (jec.isMarkedRemoved()) {
            if (TraceEjb.isDebugContext()) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)(this.ident + " removed!"));
            }
            this.discardContext(tx, committed, true);
        } else {
            if (this.shared || !committed || this.bf.tooManyInstances()) {
                if (TraceEjb.isDebugContext()) {
                    TraceEjb.context.log(BasicLevel.DEBUG, (Object)(jec + " passivated!"));
                }
                jec.passivate();
                if (!committed && this.writingtx != null) {
                    TraceEjb.tx.log(BasicLevel.WARN, (Object)(this.ident + " !!! Discard but has a running tx:" + this.writingtx));
                }
                this.bf.releaseJContext(jec, committed ? 2 : 0);
                this.removeContext4Tx(tx);
            } else {
                jec.detachTx();
            }
            if (this.lockpolicy == 2 || this.lockpolicy == 3) {
                this.mustReload = true;
            }
        }
        if (this.waiters > 0) {
            if (TraceEjb.isDebugSynchro()) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " notify"));
            }
            this.notifyAll();
        }
    }

    protected void registerCtx(Transaction tx, JEntityContext bctx) {
        if (this.bf == null) {
            TraceEjb.synchro.log(BasicLevel.ERROR, (Object)"JEntitySwitch not initialized!");
            throw new EJBException("JEntitySwitch not initialized");
        }
        try {
            if (!bctx.setRunningTx(tx)) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)(bctx + "already registered!"));
                if (this.runningtx == null) {
                    TraceEjb.context.log(BasicLevel.ERROR, (Object)"runningtx = null");
                }
                return;
            }
            if (this.bf.registerContext(tx, bctx)) {
                if (TraceEjb.isDebugContext()) {
                    TraceEjb.context.log(BasicLevel.DEBUG, (Object)(bctx + " registered!"));
                }
                this.runningtx = tx;
            } else {
                TraceEjb.context.log(BasicLevel.WARN, (Object)(bctx + " could not be registered!"));
                bctx.setRunningTx(null);
            }
        }
        catch (IllegalStateException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + "Transaction is in an illegal state"));
            throw e;
        }
    }

    protected void detachPk() {
        TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)(this.ident + " discarded on timeout"));
        if (this.remote != null) {
            try {
                this.remote.unexportObject();
            }
            catch (NoSuchObjectException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + " unexport entity failed: "), (Throwable)e);
            }
        }
        this.bf.removeEJB(this.getPrimaryKey());
        this.isdetached = true;
    }

    protected void discardContext(Transaction tx, boolean forgetpk, boolean pool) {
        JEntityContext jec;
        if (TraceEjb.isDebugTx()) {
            TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("tx=" + tx));
        }
        if ((jec = this.getContext4Tx(tx)) != null) {
            if (this.runningtx != null && tx != null && tx.equals(this.runningtx)) {
                this.bf.unregisterContext(this.runningtx, jec);
                this.runningtx = null;
            }
            this.bf.releaseJContext(jec, pool ? 2 : 0);
            this.removeContext4Tx(tx);
        }
        if (forgetpk) {
            if (this.remote != null) {
                try {
                    this.remote.unexportObject();
                }
                catch (NoSuchObjectException e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + " unexport entity failed: "), (Throwable)e);
                }
            }
            this.bf.removeEJB(this.getPrimaryKey());
            if (this.myTimerService != null) {
                ((JTimerService)this.myTimerService).cancelAllTimers();
                this.myTimerService = null;
            }
            this.isremoved = true;
        }
        this.todiscard = false;
    }

    public int getPolicy() {
        return this.lockpolicy;
    }

    public abstract int getState();

    public JFactory getBeanFactory() {
        return this.bf;
    }
}

