/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class Logger {
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private BundleContext m_context;
    private String m_name;
    private int m_level;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public Logger(BundleContext bc, String name, int level) {
        this.m_name = name;
        this.m_level = level;
        this.m_context = bc;
    }

    public void log(int level, String msg) {
        if (this.m_level >= level) {
            this.dispatch(level, msg, null);
        }
    }

    public void log(int level, String msg, Throwable ex) {
        if (this.m_level >= level) {
            this.dispatch(level, msg, ex);
        }
    }

    private void dispatch(int level, String msg, Throwable ex) {
        String s = msg;
        if (ex != null) {
            s = s + " (" + ex.getMessage() + ")";
        }
        ServiceReference ref = this.m_context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
        LogService log = null;
        if (ref != null) {
            log = (LogService)this.m_context.getService(ref);
        }
        String message = null;
        switch (level) {
            case 4: {
                message = "[" + this.m_name + "] DEBUG: " + s;
                if (log != null) {
                    log.log(4, message);
                }
                System.err.println(message);
                break;
            }
            case 1: {
                message = "[" + this.m_name + "] ERROR: " + s;
                if (log != null) {
                    log.log(1, message);
                }
                System.err.println(message);
                break;
            }
            case 3: {
                message = "[" + this.m_name + "] INFO: " + s;
                if (log != null) {
                    log.log(3, message);
                }
                System.err.println(message);
                break;
            }
            case 2: {
                message = "[" + this.m_name + "] WARNING: " + s;
                if (log != null) {
                    log.log(2, message);
                }
                System.err.println(message);
                break;
            }
            default: {
                System.err.println("[" + this.m_name + "] UNKNOWN[" + level + "]: " + s);
            }
        }
        if (log != null) {
            this.m_context.ungetService(ref);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

