/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: StatelessBean.java 12317 2007-12-12 18:25:16Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.examples.ear;

import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.osgi.framework.BundleContext;
import org.ow2.easybeans.osgi.annotation.OSGiResource;

/**
 * Defines a stateless bean with a local interface. This beans provides methods
 * for accessing the two entities, Book and Author.<br>
 * By default, an interface is considered as a local interface if there is no
 * @Remote annotation.
 * @author Florent Benoit
 */
@Stateless(mappedName="myStateless")
public class StatelessBean implements StatelessLocal {

    /**
     * Entity manager utilise par ce bean.
     */
    @PersistenceContext
    private EntityManager entityManager = null;

    /**
     * Bundle context that will be injected by the container.
     */
    @OSGiResource
    private BundleContext bundleContextField = null;


    /**
     * Create authors and their books.
     */
    public void init() {

        if (bundleContextField != null) {
            System.out.println("An OSGi BundleContext has been injected, value = " + bundleContextField);
        }

        // Books of balzac
        Author balzac = new Author("Honore de Balzac");
        Book pereGloriot = new Book("Le Pere Goriot", balzac);
        balzac.getBooks().add(pereGloriot);
        Book lesChouans = new Book("Les Chouans", balzac);
        balzac.getBooks().add(lesChouans);

        // Store (only author as cascade attribute is set to all)
        entityManager.persist(balzac);

        // Add Hugo books
        Author hugo = new Author("Victor Hugo");
        hugo.addBook("Les Miserables");
        hugo.addBook("Notre-Dame de Paris");

        // Store
        entityManager.persist(hugo);
    }

    /**
     * @return list of authors.
     */
    @SuppressWarnings("unchecked")
    public List<Author> listOfAuthors() {
        Query auteurs = entityManager.createNamedQuery("allAuthors");
        return auteurs.getResultList();
    }

    /**
     * @return ist of books.
     */
    @SuppressWarnings("unchecked")
    public List<Book> listOfBooks() {
        return entityManager.createNamedQuery("allBooks").getResultList();
    }

}
