/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.io.File;
import java.io.InputStream;
import java.util.Dictionary;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.composite.ServiceReferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class PolicyServiceContext
implements ServiceContext {
    public static final int LOCAL = 0;
    public static final int LOCAL_AND_GLOBAL = 1;
    public static final int GLOBAL = 2;
    public BundleContext m_global;
    public ServiceContext m_local;
    private int m_policy = 1;

    public PolicyServiceContext(BundleContext global, ServiceContext local, int policy) {
        this.m_global = global;
        this.m_local = local;
        this.m_policy = policy;
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        if (this.m_policy == 0 || this.m_policy == 1) {
            this.m_local.addServiceListener(listener, filter);
        }
        if (this.m_policy == 2 || this.m_policy == 1) {
            this.m_global.addServiceListener(listener, filter);
        }
    }

    public void addServiceListener(ServiceListener listener) {
        if (this.m_policy == 0 || this.m_policy == 1) {
            this.m_local.addServiceListener(listener);
        }
        if (this.m_policy == 2 || this.m_policy == 1) {
            this.m_global.addServiceListener(listener);
        }
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        switch (this.m_policy) {
            case 0: {
                return this.m_local.getAllServiceReferences(clazz, filter);
            }
            case 2: {
                return this.m_global.getAllServiceReferences(clazz, filter);
            }
            case 1: {
                ServiceReference[] refLocal = this.m_local.getAllServiceReferences(clazz, filter);
                ServiceReference[] refGlobal = this.m_global.getAllServiceReferences(clazz, filter);
                if (refLocal != null && refGlobal != null) {
                    int i;
                    ServiceReference[] refs = new ServiceReference[refLocal.length + refGlobal.length];
                    int j = 0;
                    for (i = 0; i < refLocal.length; ++i) {
                        refs[j] = refLocal[i];
                        ++j;
                    }
                    for (i = 0; i < refGlobal.length; ++i) {
                        refs[j] = refGlobal[i];
                        ++j;
                    }
                    return refs;
                }
                if (refLocal != null && refGlobal == null) {
                    return refLocal;
                }
                return refGlobal;
            }
        }
        return null;
    }

    public Object getService(ServiceReference ref) {
        switch (this.m_policy) {
            case 0: {
                return this.m_local.getService(ref);
            }
            case 2: {
                return this.m_global.getService(ref);
            }
            case 1: {
                if (ref instanceof ServiceReferenceImpl) {
                    return this.m_local.getService(ref);
                }
                return this.m_global.getService(ref);
            }
        }
        return null;
    }

    public ServiceReference getServiceReference(String clazz) {
        switch (this.m_policy) {
            case 0: {
                return this.m_local.getServiceReference(clazz);
            }
            case 2: {
                return this.m_global.getServiceReference(clazz);
            }
            case 1: {
                ServiceReference refLocal = this.m_local.getServiceReference(clazz);
                if (refLocal != null) {
                    return refLocal;
                }
                return this.m_global.getServiceReference(clazz);
            }
        }
        return null;
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        switch (this.m_policy) {
            case 0: {
                return this.m_local.getServiceReferences(clazz, filter);
            }
            case 2: {
                return this.m_global.getServiceReferences(clazz, filter);
            }
            case 1: {
                ServiceReference[] refLocal = this.m_local.getServiceReferences(clazz, filter);
                ServiceReference[] refGlobal = this.m_global.getServiceReferences(clazz, filter);
                if (refLocal != null && refGlobal != null) {
                    int i;
                    ServiceReference[] refs = new ServiceReference[refLocal.length + refGlobal.length];
                    int j = 0;
                    for (i = 0; i < refLocal.length; ++i) {
                        refs[j] = refLocal[i];
                        ++j;
                    }
                    for (i = 0; i < refGlobal.length; ++i) {
                        refs[j] = refGlobal[i];
                        ++j;
                    }
                    return refs;
                }
                if (refLocal != null && refGlobal == null) {
                    return refLocal;
                }
                return refGlobal;
            }
        }
        return null;
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        throw new UnsupportedOperationException("PolicyServiceContext can only be used for service dependency and not service providing");
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        throw new UnsupportedOperationException("PolicyServiceContext can only be used for service dependency and not service providing");
    }

    public void removeServiceListener(ServiceListener listener) {
        if (this.m_policy == 0 || this.m_policy == 1) {
            this.m_local.removeServiceListener(listener);
        }
        if (this.m_policy == 2 || this.m_policy == 1) {
            this.m_global.removeServiceListener(listener);
        }
    }

    public boolean ungetService(ServiceReference reference) {
        if (reference instanceof ServiceReferenceImpl) {
            return this.m_local.ungetService(reference);
        }
        return this.m_global.ungetService(reference);
    }

    public void addBundleListener(BundleListener arg0) {
        this.m_global.addBundleListener(arg0);
    }

    public void addFrameworkListener(FrameworkListener arg0) {
        this.m_global.addFrameworkListener(arg0);
    }

    public Filter createFilter(String arg0) throws InvalidSyntaxException {
        return this.m_global.createFilter(arg0);
    }

    public Bundle getBundle() {
        return this.m_global.getBundle();
    }

    public Bundle getBundle(long id) {
        return this.m_global.getBundle(id);
    }

    public Bundle[] getBundles() {
        return this.m_global.getBundles();
    }

    public File getDataFile(String filename) {
        return this.m_global.getDataFile(filename);
    }

    public String getProperty(String key) {
        return this.m_global.getProperty(key);
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.m_global.installBundle(location);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.m_global.installBundle(location, input);
    }

    public void removeBundleListener(BundleListener listener) {
        this.m_global.removeBundleListener(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.m_global.removeFrameworkListener(listener);
    }
}

