/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.CompositeManager;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.composite.instance.InstanceHandler;
import org.apache.felix.ipojo.composite.service.provides.CompositionException;
import org.apache.felix.ipojo.composite.service.provides.CompositionMetadata;
import org.apache.felix.ipojo.composite.service.provides.FieldMetadata;
import org.apache.felix.ipojo.composite.service.provides.ProvidedServiceHandler;
import org.apache.felix.ipojo.composite.service.provides.ServiceExporter;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class ProvidedService {
    private CompositeManager m_manager;
    private CompositionMetadata m_composition;
    private byte[] m_clazz;
    private Element m_metadata;
    private ServiceContext m_scope;
    private BundleContext m_context;
    private ComponentFactory m_factory;
    private ComponentInstance m_instance;
    private ServiceExporter m_exports;
    private String m_instanceName;

    public ProvidedService(ProvidedServiceHandler handler, Element element, String name) {
        this.m_manager = handler.getCompositeManager();
        this.m_scope = this.m_manager.getServiceContext();
        this.m_context = this.m_manager.getContext();
        this.m_composition = new CompositionMetadata(this.m_manager.getContext(), element, handler, name);
    }

    public void start() throws CompositionException {
        this.m_composition.buildMapping();
        this.m_instanceName = this.m_composition.getSpecificationMetadata().getName() + "Provider-Gen";
        this.m_clazz = this.m_composition.buildPOJO();
        this.m_metadata = this.m_composition.buildMetadata(this.m_instanceName);
        this.m_factory = new ComponentFactory(this.m_context, this.m_clazz, this.m_metadata);
        this.m_factory.start();
        this.m_exports = new ServiceExporter(this.m_composition.getSpecificationMetadata().getName(), "(instance.name=" + this.m_instanceName + ")", false, false, this.m_scope, this.m_context, this);
        this.m_exports.start();
    }

    public void stop() {
        if (this.m_exports != null) {
            this.m_exports.stop();
            this.m_exports = null;
        }
        if (this.m_instance != null) {
            this.m_instance.dispose();
            this.m_instance = null;
        }
        if (this.m_factory != null) {
            this.m_factory.stop();
            this.m_factory = null;
        }
    }

    protected CompositeManager getManager() {
        return this.m_manager;
    }

    public void validating(ServiceExporter exporter) {
    }

    public void invalidating(ServiceExporter exporter) {
    }

    protected void unregister() {
        if (this.m_instance != null) {
            this.m_instance.dispose();
            this.m_instance = null;
        }
    }

    protected void register() {
        if (this.m_exports != null) {
            if (this.m_instance != null) {
                this.m_instance.dispose();
            }
            Properties p = new Properties();
            p.put("name", this.m_instanceName);
            List fields = this.m_composition.getFieldList();
            for (int i = 0; i < fields.size(); ++i) {
                FieldMetadata fm = (FieldMetadata)fields.get(i);
                if (!fm.isUseful() || fm.getSpecification().isInterface()) continue;
                String type = fm.getSpecification().getComponentType();
                Object o = this.getObjectByType(type);
                p.put(fm.getName(), o);
            }
            try {
                this.m_instance = this.m_factory.createComponentInstance(p, this.m_manager.getServiceContext());
            }
            catch (UnacceptableConfiguration e) {
                e.printStackTrace();
            }
            catch (MissingHandlerException e) {
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    private Object getObjectByType(String type) {
        InstanceHandler h = (InstanceHandler)this.m_manager.getCompositeHandler("org.apache.felix.ipojo.composite.instance.InstanceHandler");
        Object o = h.getObjectFromInstance(type);
        if (o == null) {
            this.m_manager.getFactory().getLogger().log(1, "An instance object cannot be found for the type : " + type);
        }
        return o;
    }

    public String getSpecification() {
        return this.m_composition.getSpecificationMetadata().getName();
    }

    public boolean getState() {
        return this.m_exports != null && this.m_exports.isPublishing();
    }
}

