/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.AbsArchiveImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryArchive
extends AbsArchiveImpl
implements IArchive {
    private Map<String, URL> urlMap = new HashMap<String, URL>();

    public MemoryArchive() {
    }

    public MemoryArchive(ClassLoader classLoader, List<String> classNames) {
        this.addClassResource(classLoader, classNames);
    }

    public boolean close() {
        return true;
    }

    public String getName() {
        return "ArchiveInMemory";
    }

    public URL getResource(String resourceName) {
        return this.urlMap.get(resourceName);
    }

    public Iterator<URL> getResources() {
        return this.urlMap.values().iterator();
    }

    public Iterator<URL> getResources(String resourceName) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        linkedList.add(this.urlMap.get(resourceName));
        return linkedList.iterator();
    }

    public URL getURL() {
        return null;
    }

    public void addResource(String resourceName, URL url) {
        this.urlMap.put(resourceName, url);
    }

    public void addClassResource(ClassLoader classLoader, List<String> classNames) {
        for (String className : classNames) {
            this.urlMap.put(className, classLoader.getResource(className.replace('.', '/').concat(".class")));
        }
    }

    public Iterator<String> getEntries() {
        return this.urlMap.keySet().iterator();
    }
}

