/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.scheduler.event;

import com.scalagent.scheduler.event.DiaryEvent;
import com.scalagent.scheduler.event.DiaryPeriod;
import fr.dyade.aaa.util.Strings;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class PeriodicEvent
implements DiaryEvent {
    private static final long serialVersionUID = 1L;
    protected String timeZoneId = null;
    protected long refDate = -1L;
    protected DiaryPeriod period = null;
    protected int[] maskField = null;
    protected int[] maskValue = null;
    protected Calendar calendar;

    public static long getDate(long refDate, DiaryPeriod period) {
        if (refDate == -1L || period.value == 0) {
            return -1L;
        }
        PeriodicEvent pevt = new PeriodicEvent(refDate, period);
        return pevt.getNextDate(refDate);
    }

    public static boolean checkField(Calendar calendar, int field, int value) {
        if (value >= 0) {
            return calendar.get(field) == value;
        }
        Calendar clone = (Calendar)calendar.clone();
        switch (field) {
            case 5: {
                clone.add(5, -value);
                return clone.get(5) == 1;
            }
            case 8: {
                clone.add(5, -7 * value);
                return clone.get(5) < 7;
            }
        }
        return false;
    }

    public PeriodicEvent(String timeZoneId, long refDate, DiaryPeriod period, int[] maskField, int[] maskValue) {
        TimeZone tz;
        this.timeZoneId = timeZoneId;
        this.refDate = refDate;
        this.period = period;
        this.maskField = maskField;
        this.maskValue = maskValue;
        this.calendar = timeZoneId == null ? Calendar.getInstance() : ((tz = TimeZone.getTimeZone(timeZoneId)) == null ? Calendar.getInstance() : Calendar.getInstance(tz));
        if (refDate != -1L) {
            this.calendar.setTime(new Date(refDate));
        }
    }

    public PeriodicEvent(String timeZoneId, long refDate, DiaryPeriod period) {
        this(timeZoneId, refDate, period, null, null);
    }

    public PeriodicEvent(long refDate, DiaryPeriod period) {
        this(null, refDate, period);
    }

    public PeriodicEvent() {
        this(-1L, null);
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setRefDate(long refDate) {
        this.refDate = refDate;
        if (refDate != -1L) {
            this.calendar.setTime(new Date(refDate));
        }
    }

    public long getRefDate() {
        return this.refDate;
    }

    public void setPeriod(DiaryPeriod period) {
        this.period = period;
    }

    public DiaryPeriod getPeriod() {
        return this.period;
    }

    public void setMaskField(int[] maskField) {
        this.maskField = (int[])(maskField != null && maskField.length == 0 ? null : maskField);
    }

    public int[] getMaskField() {
        return this.maskField;
    }

    public void setMaskValue(int[] maskValue) {
        this.maskValue = (int[])(maskValue != null && maskValue.length == 0 ? null : maskValue);
    }

    public int[] getMaskValue() {
        return this.maskValue;
    }

    public boolean validateMask() {
        if (this.maskField == null || this.maskField.length == 0) {
            return true;
        }
        if (this.period == null) {
            return false;
        }
        boolean fillValue = false;
        if (this.maskValue == null) {
            fillValue = true;
            this.maskValue = new int[this.maskField.length];
        }
        if (this.refDate != -1L) {
            this.calendar.setTime(new Date(this.refDate));
        }
        if (this.maskField[0] == 1) {
            return false;
        }
        int index = 0;
        switch (this.period.unit) {
            case 1: {
                switch (this.maskField[index]) {
                    case 2: {
                        if (fillValue) {
                            if (this.refDate == -1L) {
                                return false;
                            }
                            this.maskValue[index] = this.calendar.get(2);
                        } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 2, this.maskValue[index])) {
                            return false;
                        }
                        if (++index >= this.maskField.length) {
                            return false;
                        }
                        switch (this.maskField[index]) {
                            case 4: {
                                if (fillValue) {
                                    if (this.refDate == -1L) {
                                        return false;
                                    }
                                    this.maskValue[index] = this.calendar.get(4);
                                } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 4, this.maskValue[index])) {
                                    return false;
                                }
                                if (++index < this.maskField.length) {
                                    switch (this.maskField[index]) {
                                        case 7: {
                                            if (fillValue) {
                                                if (this.refDate == -1L) {
                                                    return false;
                                                }
                                                this.maskValue[index] = this.calendar.get(7);
                                            } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 7, this.maskValue[index])) {
                                                return false;
                                            }
                                            return ++index >= this.maskField.length;
                                        }
                                    }
                                    return false;
                                }
                                if (this.refDate == -1L) {
                                    return false;
                                }
                                int[] mask = new int[index];
                                System.arraycopy(this.maskField, 0, mask, 0, this.maskField.length);
                                this.maskField = mask;
                                this.maskField[index] = 7;
                                mask = new int[index];
                                System.arraycopy(this.maskValue, 0, mask, 0, this.maskValue.length);
                                this.maskValue = mask;
                                this.maskValue[index] = this.calendar.get(7);
                                return true;
                            }
                            case 5: {
                                if (fillValue) {
                                    if (this.refDate == -1L) {
                                        return false;
                                    }
                                    this.maskValue[index] = this.calendar.get(5);
                                } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 5, this.maskValue[index])) {
                                    return false;
                                }
                                return ++index >= this.maskField.length;
                            }
                            case 8: {
                                if (fillValue) {
                                    if (this.refDate == -1L) {
                                        return false;
                                    }
                                    this.maskValue[index] = this.calendar.get(8);
                                } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 8, this.maskValue[index])) {
                                    return false;
                                }
                                if (++index < this.maskField.length) {
                                    switch (this.maskField[index]) {
                                        case 7: {
                                            if (fillValue) {
                                                if (this.refDate == -1L) {
                                                    return false;
                                                }
                                                this.maskValue[index] = this.calendar.get(7);
                                            } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 7, this.maskValue[index])) {
                                                return false;
                                            }
                                            return ++index >= this.maskField.length;
                                        }
                                    }
                                    return false;
                                }
                                if (this.refDate == -1L) {
                                    return false;
                                }
                                int[] mask = new int[index];
                                System.arraycopy(this.maskField, 0, mask, 0, this.maskField.length);
                                this.maskField = mask;
                                this.maskField[index] = 7;
                                mask = new int[index];
                                System.arraycopy(this.maskValue, 0, mask, 0, this.maskValue.length);
                                this.maskValue = mask;
                                this.maskValue[index] = this.calendar.get(7);
                                return true;
                            }
                        }
                        return false;
                    }
                    case 3: {
                        if (fillValue) {
                            if (this.refDate == -1L) {
                                return false;
                            }
                            this.maskValue[index] = this.calendar.get(3);
                        } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 3, this.maskValue[index])) {
                            return false;
                        }
                        if (++index < this.maskField.length) {
                            switch (this.maskField[index]) {
                                case 7: {
                                    if (fillValue) {
                                        if (this.refDate == -1L) {
                                            return false;
                                        }
                                        this.maskValue[index] = this.calendar.get(7);
                                    } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 7, this.maskValue[index])) {
                                        return false;
                                    }
                                    return ++index >= this.maskField.length;
                                }
                            }
                            return false;
                        }
                        if (this.refDate == -1L) {
                            return false;
                        }
                        int[] mask = new int[index];
                        System.arraycopy(this.maskField, 0, mask, 0, this.maskField.length);
                        this.maskField = mask;
                        this.maskField[index] = 7;
                        mask = new int[index];
                        System.arraycopy(this.maskValue, 0, mask, 0, this.maskValue.length);
                        this.maskValue = mask;
                        this.maskValue[index] = this.calendar.get(7);
                        return true;
                    }
                    case 6: {
                        if (fillValue) {
                            if (this.refDate == -1L) {
                                return false;
                            }
                            this.maskValue[index] = this.calendar.get(6);
                        } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 6, this.maskValue[index])) {
                            return false;
                        }
                        return ++index >= this.maskField.length;
                    }
                }
                break;
            }
            case 2: {
                switch (this.maskField[index]) {
                    case 4: {
                        if (fillValue) {
                            if (this.refDate == -1L) {
                                return false;
                            }
                            this.maskValue[index] = this.calendar.get(4);
                        } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 4, this.maskValue[index])) {
                            return false;
                        }
                        if (++index < this.maskField.length) {
                            switch (this.maskField[index]) {
                                case 7: {
                                    if (fillValue) {
                                        if (this.refDate == -1L) {
                                            return false;
                                        }
                                        this.maskValue[index] = this.calendar.get(7);
                                    } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 7, this.maskValue[index])) {
                                        return false;
                                    }
                                    return ++index >= this.maskField.length;
                                }
                            }
                            return false;
                        }
                        if (this.refDate == -1L) {
                            return false;
                        }
                        int[] mask = new int[index];
                        System.arraycopy(this.maskField, 0, mask, 0, this.maskField.length);
                        this.maskField = mask;
                        this.maskField[index] = 7;
                        mask = new int[index];
                        System.arraycopy(this.maskValue, 0, mask, 0, this.maskValue.length);
                        this.maskValue = mask;
                        this.maskValue[index] = this.calendar.get(7);
                        return true;
                    }
                    case 5: {
                        if (fillValue) {
                            if (this.refDate == -1L) {
                                return false;
                            }
                            this.maskValue[index] = this.calendar.get(5);
                        } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 5, this.maskValue[index])) {
                            return false;
                        }
                        return ++index >= this.maskField.length;
                    }
                    case 8: {
                        if (fillValue) {
                            if (this.refDate == -1L) {
                                return false;
                            }
                            this.maskValue[index] = this.calendar.get(8);
                        } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 8, this.maskValue[index])) {
                            return false;
                        }
                        if (++index < this.maskField.length) {
                            switch (this.maskField[index]) {
                                case 7: {
                                    if (fillValue) {
                                        if (this.refDate == -1L) {
                                            return false;
                                        }
                                        this.maskValue[index] = this.calendar.get(7);
                                    } else if (this.refDate != -1L && !PeriodicEvent.checkField(this.calendar, 7, this.maskValue[index])) {
                                        return false;
                                    }
                                    return ++index >= this.maskField.length;
                                }
                            }
                            return false;
                        }
                        if (this.refDate == -1L) {
                            return false;
                        }
                        int[] mask = new int[index];
                        System.arraycopy(this.maskField, 0, mask, 0, this.maskField.length);
                        this.maskField = mask;
                        this.maskField[index] = 7;
                        mask = new int[index];
                        System.arraycopy(this.maskValue, 0, mask, 0, this.maskValue.length);
                        this.maskValue = mask;
                        this.maskValue[index] = this.calendar.get(7);
                        return true;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("(");
        output.append(super.toString());
        output.append(",timeZoneId=");
        Strings.toString(output, this.timeZoneId);
        output.append(",refDate=");
        output.append(this.refDate);
        if (this.refDate > 0L) {
            output.append("(");
            output.append(DateFormat.getDateTimeInstance().format(new Date(this.refDate)));
            output.append(")");
        }
        output.append(",period=");
        output.append(this.period);
        output.append(",maskField=");
        Strings.toStringArray(output, this.maskField);
        output.append(",maskValue=");
        Strings.toStringArray(output, this.maskValue);
        output.append(")");
        return output.toString();
    }

    protected void applyMask() {
        if (this.maskField == null) {
            return;
        }
        int lastDayInMonth = 0;
        for (int i = 0; i < this.maskField.length; ++i) {
            if (this.maskField[i] == 5 && this.maskValue[i] < 0) {
                lastDayInMonth = this.maskValue[i];
                this.calendar.set(5, 33);
                continue;
            }
            this.calendar.set(this.maskField[i], this.maskValue[i]);
        }
        if (lastDayInMonth != 0) {
            this.calendar.get(2);
            this.calendar.set(5, lastDayInMonth + 1);
        }
    }

    protected boolean checkMask() {
        if (this.maskField == null) {
            return true;
        }
        for (int i = 0; i < this.maskField.length; ++i) {
            if (this.maskValue[i] <= 0 || this.calendar.get(this.maskField[i]) == this.maskValue[i]) continue;
            return false;
        }
        return true;
    }

    public long getNextDate(long now, boolean inclusive) {
        return this.getNextDate(now, 1, inclusive);
    }

    public long getNextDate(long now) {
        return this.getNextDate(now, false);
    }

    public long getLastDate(long now, boolean inclusive) {
        return this.getNextDate(now, -1, inclusive);
    }

    public long getLastDate(long now) {
        return this.getLastDate(now, false);
    }

    private long getNextDate(long now, int dir, boolean inclusive) {
        if (dir == 0) {
            return -1L;
        }
        dir = dir > 0 ? 1 : -1;
        if (this.refDate == -1L) {
            return -1L;
        }
        long date = this.calendar.getTime().getTime();
        if (inclusive && date == now) {
            return date;
        }
        if (this.period.value == 0) {
            return -1L;
        }
        Calendar clone = (Calendar)this.calendar.clone();
        long pnum = now - date;
        int sign = 1;
        if (pnum > 0L) {
            sign = dir;
        } else {
            pnum = -pnum;
            sign = -dir;
        }
        switch (this.period.unit) {
            case 1: {
                pnum /= 12L;
            }
            case 2: {
                pnum /= 30L;
            }
            case 5: {
                pnum /= 24L;
            }
            case 11: {
                pnum /= 60L;
            }
            case 12: {
                pnum /= 60L;
            }
            case 13: {
                pnum /= 1000L;
            }
        }
        pnum /= (long)this.period.value;
        while (pnum > 3L) {
            this.calendar.add(this.period.unit, (int)(pnum * (long)this.period.value * (long)dir * (long)sign));
            this.applyMask();
            if (!this.checkMask()) {
                this.calendar = clone;
                clone = (Calendar)this.calendar.clone();
                --pnum;
                continue;
            }
            clone = (Calendar)this.calendar.clone();
            break;
        }
        if (now == (date = this.calendar.getTime().getTime())) {
            if (inclusive) {
                return date;
            }
            sign = 1;
        } else {
            sign = now > date ? dir : -dir;
        }
        pnum = 1L;
        while (true) {
            this.calendar.add(this.period.unit, (int)(pnum * (long)this.period.value * (long)dir * (long)sign));
            this.applyMask();
            date = this.calendar.getTime().getTime();
            if (sign == -1 && ((date - now) * (long)dir < 0L || !inclusive && date == now)) {
                this.calendar = clone;
                return this.calendar.getTime().getTime();
            }
            if (!this.checkMask()) {
                this.calendar = clone;
                clone = (Calendar)this.calendar.clone();
                ++pnum;
                continue;
            }
            if (sign == 1 && ((date - now) * (long)dir > 0L || inclusive && date == now)) {
                return date;
            }
            clone = (Calendar)this.calendar.clone();
            pnum = 1L;
        }
    }
}

