/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LfuMemoryStore
extends MemoryStore {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$store$LfuMemoryStore == null ? (class$net$sf$ehcache$store$LfuMemoryStore = LfuMemoryStore.class$("net.sf.ehcache.store.LfuMemoryStore")) : class$net$sf$ehcache$store$LfuMemoryStore).getName());
    private static final int DEFAULT_SAMPLE_SIZE = 30;
    private final Random random = new Random();
    static /* synthetic */ Class class$net$sf$ehcache$store$LfuMemoryStore;

    protected LfuMemoryStore(Ehcache cache, DiskStore diskStore) {
        super(cache, diskStore);
        this.map = new HashMap();
    }

    public final synchronized void doPut(Element elementJustAdded) {
        if (this.isFull()) {
            this.removeLfuElement(elementJustAdded);
        }
    }

    private void removeLfuElement(Element elementJustAdded) {
        Element element;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cache is full. Removing LFU element ...");
        }
        if ((element = this.findRelativelyUnused(elementJustAdded)).isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return;
        }
        this.evict(element);
        this.remove(element.getObjectKey());
    }

    final Element findRelativelyUnused(Element elementJustAdded) {
        Element[] elements = this.sampleElements(this.calculateSampleSize());
        return LfuMemoryStore.lowestElementFromArray(elements, elementJustAdded);
    }

    private int calculateSampleSize() {
        if (this.map.size() < 30) {
            return this.map.size();
        }
        return 30;
    }

    final Element[] sampleElements(int sampleSize) {
        int[] offsets = this.generateRandomOffsets(sampleSize);
        Element[] elements = new Element[sampleSize];
        Iterator iterator = this.map.values().iterator();
        for (int i = 0; i < sampleSize; ++i) {
            for (int j = 0; j < offsets[i]; ++j) {
                iterator.next();
            }
            elements[i] = (Element)iterator.next();
        }
        return elements;
    }

    private static Element lowestElementFromArray(Element[] elements, Element elementJustAdded) {
        if (elements.length == 1) {
            return elementJustAdded;
        }
        Element lowestElement = null;
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            if (lowestElement == null) {
                if (element.equals(elementJustAdded)) continue;
                lowestElement = element;
                continue;
            }
            if (element.getHitCount() >= lowestElement.getHitCount() || element.equals(elementJustAdded)) continue;
            lowestElement = element;
        }
        return lowestElement;
    }

    private int[] generateRandomOffsets(int sampleSize) {
        int size = this.map.size();
        int[] offsets = new int[sampleSize];
        int maxOffset = size / sampleSize;
        for (int i = 0; i < sampleSize; ++i) {
            offsets[i] = this.random.nextInt(maxOffset);
        }
        return offsets;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

