/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust2.samples;

import java.net.URI;
import java.net.URL;
import java.util.Date;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.ws.sandbox.security.trust2.Lifetime;
import org.apache.ws.sandbox.security.trust2.RequestSecurityToken;
import org.apache.ws.sandbox.security.trust2.RequestSecurityTokenResponse;
import org.apache.ws.sandbox.security.trust2.SecurityTokenOrReference;
import org.apache.ws.sandbox.security.trust2.TokenTypes;
import org.apache.ws.sandbox.security.trust2.TrustConstants;
import org.apache.ws.sandbox.security.trust2.exception.TrustException;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.token.UsernameToken;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public class SampleSecurityTokenServiceClient {
    public static void main(String[] args) throws DOMException, TrustException, Exception {
        Service service = new Service();
        Call call = (Call)service.createCall();
        String url = "http://localhost:8080/JavaTrust/services/SampleSecurityTokenService";
        if (args.length > 0) {
            url = args[0];
        }
        call.setTargetEndpointAddress(new URL(url));
        SOAPEnvelope env = new SOAPEnvelope();
        Document doc = env.getAsDocument();
        WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
        RequestSecurityToken tokenRequest = new RequestSecurityToken(doc, TrustConstants.REQUEST_ISSUE);
        tokenRequest.setContext(new URI("http://context.context"));
        tokenRequest.setTokenType(TokenTypes.X509);
        UsernameToken userToken = new UsernameToken(wssConfig, doc);
        userToken.setName("bob");
        userToken.setPassword("bobspass");
        tokenRequest.setBase(new SecurityTokenOrReference(userToken));
        UsernameToken user2Token = new UsernameToken(wssConfig, doc);
        user2Token.setName("joe");
        user2Token.setPassword("bobspass");
        tokenRequest.addSupporting(new SecurityTokenOrReference(user2Token));
        UsernameToken user3Token = new UsernameToken(wssConfig, doc);
        user3Token.setName("mike");
        user3Token.setPassword("bobspass");
        tokenRequest.addSupporting(new SecurityTokenOrReference(user3Token));
        Date start = new Date();
        Date end = new Date();
        end.setTime(start.getTime() + 250000L);
        tokenRequest.setLifetime(new Lifetime(wssConfig, doc, start, end));
        tokenRequest.addCustomElementNS("http://testElementNs.testElementNs", "te:TestElement");
        SOAPBodyElement sbe = new SOAPBodyElement(tokenRequest.getElement());
        env.addBodyElement(sbe);
        System.out.println("\n============= Request ==============");
        System.out.println(XMLUtils.DocumentToString(env.getAsDocument()));
        SOAPEnvelope response = call.invoke(env);
        System.out.println("\n============= Response ==============");
        XMLUtils.PrettyElementToStream(response.getAsDOM(), System.out);
        SOAPBodyElement responseBody = response.getBodyByName("http://schemas.xmlsoap.org/ws/2004/04/trust", "RequestSecurityTokenResponse");
        RequestSecurityTokenResponse tokenResponse = new RequestSecurityTokenResponse(responseBody.getAsDOM());
        System.out.println("\n------- RequestSecurityTokenResponse object ------------- \n" + tokenResponse);
    }
}

