/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.w3c.dom.Element;

public class KeyResolver {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$keys$keyresolver$KeyResolver == null ? (class$org$apache$xml$security$keys$keyresolver$KeyResolver = KeyResolver.class$("org.apache.xml.security.keys.keyresolver.KeyResolver")) : class$org$apache$xml$security$keys$keyresolver$KeyResolver).getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    protected KeyResolverSpi _resolverSpi = null;
    protected StorageResolver _storage = null;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$KeyResolver;

    private KeyResolver(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (KeyResolverSpi)Class.forName(string).newInstance();
    }

    public static int length() {
        return _resolverVector.size();
    }

    public static KeyResolver item(int n) throws KeyResolverException {
        KeyResolver keyResolver = (KeyResolver)_resolverVector.get(n);
        if (keyResolver == null) {
            throw new KeyResolverException("utils.resolver.noClass");
        }
        return keyResolver;
    }

    public static final KeyResolver getInstance(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        for (int i = 0; i < _resolverVector.size(); ++i) {
            KeyResolver keyResolver = (KeyResolver)_resolverVector.get(i);
            if (keyResolver == null) {
                Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", objectArray);
            }
            if (log.isDebugEnabled()) {
                log.debug("check resolvability by class " + keyResolver.getClass());
            }
            if (!keyResolver.canResolve(element, string, storageResolver)) continue;
            return keyResolver;
        }
        Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        _resolverVector.add(new KeyResolver(string));
    }

    public static void registerAtStart(String string) {
        _resolverVector.add(0, string);
    }

    public static PublicKey resolveStatic(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        KeyResolver keyResolver = KeyResolver.getInstance(element, string, storageResolver);
        return keyResolver.resolvePublicKey(element, string, storageResolver);
    }

    public PublicKey resolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineResolvePublicKey(element, string, storageResolver);
    }

    public X509Certificate resolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineResolveX509Certificate(element, string, storageResolver);
    }

    public SecretKey resolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineResolveSecretKey(element, string, storageResolver);
    }

    public void setProperty(String string, String string2) {
        this._resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this._resolverSpi.engineGetProperty(string);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string) {
        return this._resolverSpi.understandsProperty(string);
    }

    public boolean canResolve(Element element, String string, StorageResolver storageResolver) {
        return this._resolverSpi.engineCanResolve(element, string, storageResolver);
    }

    public String resolverClassName() {
        return this._resolverSpi.getClass().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

