/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.metadata.marshalling;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.metadata.marshalling.BaseClassBinding;
import org.jboss.xb.binding.metadata.marshalling.CollectionBinding;
import org.jboss.xb.binding.metadata.marshalling.FieldBinding;
import org.jboss.xb.binding.metadata.marshalling.FieldGroupBinding;
import org.jboss.xb.binding.metadata.marshalling.FieldGroupChoiceBinding;
import org.jboss.xb.binding.metadata.marshalling.FieldGroupSequenceBinding;
import org.jboss.xb.binding.metadata.marshalling.FieldValueBinding;
import org.jboss.xb.binding.metadata.marshalling.FinalClassBinding;
import org.jboss.xb.binding.metadata.marshalling.NonFinalClassBinding;
import org.jboss.xb.binding.metadata.marshalling.ObjectModelBinding;
import org.jboss.xb.binding.metadata.marshalling.SimpleValueBinding;

public abstract class ObjectModelBindingFactory {
    public static ObjectModelBindingFactory newInstance() {
        return new ObjectModelBindingFactoryImpl();
    }

    public abstract ObjectModelBinding newObjectModelBinding();

    public abstract FinalClassBinding bindFinalClass(ObjectModelBinding var1, Class var2, String var3, String var4);

    public abstract FieldBinding bindFieldToAttribute(FinalClassBinding var1, String var2, String var3, String var4);

    public abstract FieldBinding bindField(FinalClassBinding var1, String var2);

    public abstract FieldBinding bindField(NonFinalClassBinding var1, String var2);

    public abstract FieldGroupSequenceBinding bindFieldGroupSequence(FinalClassBinding var1);

    public abstract FieldGroupSequenceBinding bindFieldGroupSequence(NonFinalClassBinding var1);

    public abstract FieldGroupChoiceBinding bindFieldGroupChoice(FinalClassBinding var1);

    public abstract FieldGroupChoiceBinding bindFieldGroupChoice(NonFinalClassBinding var1);

    public abstract FieldGroupSequenceBinding bindFieldGroupSequence(FieldGroupBinding var1);

    public abstract FieldGroupChoiceBinding bindFieldGroupChoice(FieldGroupBinding var1);

    public abstract FieldBinding bindField(FieldGroupBinding var1, String var2);

    public abstract SimpleValueBinding bindSimpleValue(FieldBinding var1, String var2, String var3);

    public abstract FinalClassBinding bindFinalClassValue(FieldBinding var1, String var2, String var3);

    public abstract NonFinalClassBinding bindNonFinalClassValue(FieldBinding var1);

    public abstract NonFinalClassBinding bindNonFinalClass(NonFinalClassBinding var1, Class var2);

    public abstract FinalClassBinding bindFinalClass(NonFinalClassBinding var1, Class var2, String var3, String var4);

    public abstract CollectionBinding bindCollectionValue(FieldBinding var1, String var2, String var3);

    public abstract NonFinalClassBinding bindNonFinalItem(CollectionBinding var1, Class var2);

    public abstract FinalClassBinding bindFinalItem(CollectionBinding var1, Class var2, String var3, String var4);

    public abstract SimpleValueBinding bindSimpleItem(CollectionBinding var1, Class var2, String var3, String var4);

    public abstract NonFinalClassBinding bindNonFinalClass(ObjectModelBinding var1, Class var2);

    static final class FieldBindingImpl
    extends AbstractFieldGroupBindingImpl
    implements FieldBinding {
        private final String fieldName;
        private final Field field;
        private final Method getter;
        private final Class fieldType;
        private FieldValueBinding value;

        public FieldBindingImpl(BaseClassBinding owner, String fieldName) {
            super(owner);
            Class<?> fieldType;
            Class ownerClass = owner.getJavaClass();
            this.fieldName = fieldName;
            Field field = null;
            Method getter = null;
            String getterName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                getter = ownerClass.getMethod(getterName, null);
                fieldType = getter.getReturnType();
            }
            catch (NoSuchMethodException e1) {
                try {
                    field = ownerClass.getField(fieldName);
                    fieldType = field.getType();
                }
                catch (NoSuchFieldException e) {
                    throw new JBossXBRuntimeException("Failed to bind field " + fieldName + " in " + owner + ": neither field nor getter were found.");
                }
            }
            this.field = field;
            this.getter = getter;
            this.fieldType = fieldType;
        }

        void bindValue(FieldValueBinding value) {
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Field getField() {
            return this.field;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Class getFieldType() {
            return this.fieldType;
        }

        public FieldValueBinding getValueBinding() {
            return this.value;
        }

        public int getCategory() {
            return 2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldBindingImpl)) {
                return false;
            }
            FieldBindingImpl fieldBinding = (FieldBindingImpl)o;
            return this.fieldName.equals(fieldBinding.fieldName);
        }

        public int hashCode() {
            return this.fieldName.hashCode();
        }
    }

    static final class FieldGroupChoiceBindingImpl
    extends AbstractFieldGroupBindingImpl
    implements FieldGroupChoiceBinding {
        private final List groups = new ArrayList();

        public FieldGroupChoiceBindingImpl(BaseClassBinding owner) {
            super(owner);
        }

        void bindGroup(FieldGroupBinding group) {
            this.groups.add(group);
        }

        public FieldGroupBinding[] getFieldGroups() {
            return this.groups.toArray(new FieldGroupBinding[this.groups.size()]);
        }

        public int getCategory() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldGroupChoiceBindingImpl)) {
                return false;
            }
            FieldGroupChoiceBindingImpl fieldGroupChoiceBinding = (FieldGroupChoiceBindingImpl)o;
            return ((Object)this.groups).equals(fieldGroupChoiceBinding.groups);
        }

        public int hashCode() {
            return ((Object)this.groups).hashCode();
        }
    }

    static final class FieldGroupSequenceBindingImpl
    extends AbstractFieldGroupBindingImpl
    implements FieldGroupSequenceBinding {
        private final List groups = new ArrayList();

        public FieldGroupSequenceBindingImpl(BaseClassBinding owner) {
            super(owner);
        }

        void bindGroup(FieldGroupBinding group) {
            this.groups.add(group);
        }

        public FieldGroupBinding[] getFieldGroups() {
            return this.groups.toArray(new FieldGroupBinding[this.groups.size()]);
        }

        public int getCategory() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldGroupSequenceBindingImpl)) {
                return false;
            }
            FieldGroupSequenceBindingImpl fieldGroupSequenceBinding = (FieldGroupSequenceBindingImpl)o;
            return ((Object)this.groups).equals(fieldGroupSequenceBinding.groups);
        }

        public int hashCode() {
            return ((Object)this.groups).hashCode();
        }
    }

    static abstract class AbstractFieldGroupBindingImpl
    implements FieldGroupBinding {
        private final BaseClassBinding owner;

        protected AbstractFieldGroupBindingImpl(BaseClassBinding owner) {
            this.owner = owner;
        }

        public BaseClassBinding getDeclaringClassBinding() {
            return this.owner;
        }
    }

    static final class CollectionBindingImpl
    extends AbstractFieldValueBinding
    implements CollectionBinding {
        private final String namespaceUri;
        private final String elementName;
        private final Map items = new HashMap();

        public CollectionBindingImpl(FieldBinding field, Class javaClass, String namespaceUri, String elementName) {
            super(field, javaClass);
            this.namespaceUri = namespaceUri;
            this.elementName = elementName;
        }

        void bindItem(FieldValueBinding item) {
            this.items.put(item.getJavaClass(), item);
        }

        public int getCategory() {
            return 4;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }

        public String getElementName() {
            return this.elementName;
        }

        public FieldValueBinding getItemBinding(Class type) {
            return (FieldValueBinding)this.items.get(type);
        }
    }

    static final class NonFinalClassBindingImpl
    extends AbstractBaseClassBinding
    implements NonFinalClassBinding {
        private final Map subclasses = new HashMap();

        public NonFinalClassBindingImpl(FieldBinding field, Class javaClass) {
            this(field, javaClass, null, null);
        }

        public NonFinalClassBindingImpl(FieldBinding field, Class javaClass, Collection inheritedFieldGroups, Collection inheritedFieldToAttribute) {
            super(field, javaClass, inheritedFieldGroups, inheritedFieldToAttribute);
        }

        void bindSubclass(FieldValueBinding subclass) {
            this.subclasses.put(subclass.getJavaClass(), subclass);
        }

        public int getCategory() {
            return 2;
        }

        public FieldValueBinding getSubclassBinding(Class type) {
            return (FieldValueBinding)this.subclasses.get(type);
        }
    }

    static final class FinalClassBindingImpl
    extends AbstractBaseClassBinding
    implements FinalClassBinding {
        private final String namespaceUri;
        private final String elementName;

        public FinalClassBindingImpl(FieldBinding field, Class javaClass, String namespaceUri, String elementName) {
            this(field, javaClass, namespaceUri, elementName, null, null);
        }

        public FinalClassBindingImpl(FieldBinding field, Class javaClass, String namespaceUri, String elementName, Collection inheritedFieldGroups, Collection inheritedFieldToAttribute) {
            super(field, javaClass, inheritedFieldGroups, inheritedFieldToAttribute);
            this.namespaceUri = namespaceUri;
            this.elementName = elementName;
        }

        public int getCategory() {
            return 1;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }

        public String getElementName() {
            return this.elementName;
        }
    }

    static final class SimpleValueBindingImpl
    extends AbstractFieldValueBinding
    implements SimpleValueBinding {
        private final String namespaceUri;
        private final String elementName;

        public SimpleValueBindingImpl(FieldBinding field, Class javaClass, String namespaceUri, String elementName) {
            super(field, javaClass);
            this.namespaceUri = namespaceUri;
            this.elementName = elementName;
        }

        public int getCategory() {
            return 0;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }

        public String getElementName() {
            return this.elementName;
        }
    }

    static abstract class AbstractBaseClassBinding
    extends AbstractFieldValueBinding
    implements BaseClassBinding {
        final LinkedHashSet fieldGroups;
        final LinkedHashSet fieldToAttribute;

        public AbstractBaseClassBinding(FieldBinding field, Class javaClass, Collection inheritedFieldGroups, Collection inheritedFieldToAttribute) {
            super(field, javaClass);
            this.fieldGroups = inheritedFieldGroups == null ? new LinkedHashSet() : new LinkedHashSet(inheritedFieldGroups);
            this.fieldToAttribute = inheritedFieldToAttribute == null ? new LinkedHashSet() : new LinkedHashSet(inheritedFieldToAttribute);
        }

        void bindFieldGroup(FieldGroupBinding group) {
            this.fieldGroups.add(group);
        }

        void bindFieldToAttribute(FieldBinding field) {
            this.fieldToAttribute.add(field);
        }

        public FieldBinding[] getFieldToAttributeBindings() {
            return this.fieldToAttribute.toArray(new FieldBinding[this.fieldToAttribute.size()]);
        }

        public FieldGroupBinding[] getFieldGroups() {
            return this.fieldGroups.toArray(new FieldGroupBinding[this.fieldGroups.size()]);
        }
    }

    static abstract class AbstractFieldValueBinding
    implements FieldValueBinding {
        private final FieldBinding field;
        private final Class javaClass;

        protected AbstractFieldValueBinding(FieldBinding field, Class javaClass) {
            this.javaClass = javaClass;
            this.field = field;
        }

        public FieldBinding getFieldBinding() {
            return this.field;
        }

        public Class getJavaClass() {
            return this.javaClass;
        }
    }

    static final class ObjectModelBindingImpl
    implements ObjectModelBinding {
        private final Map tops = new HashMap();

        ObjectModelBindingImpl() {
        }

        void bindTop(FieldValueBinding fieldValue) {
            this.tops.put(fieldValue.getJavaClass(), fieldValue);
        }

        public FieldValueBinding getTopClass(Class cls) {
            return (FieldValueBinding)this.tops.get(cls);
        }
    }

    static final class ObjectModelBindingFactoryImpl
    extends ObjectModelBindingFactory {
        ObjectModelBindingFactoryImpl() {
        }

        public ObjectModelBinding newObjectModelBinding() {
            return new ObjectModelBindingImpl();
        }

        public FinalClassBinding bindFinalClass(ObjectModelBinding om, Class cls, String namespaceUri, String elementName) {
            FinalClassBindingImpl clsBinding = new FinalClassBindingImpl(null, cls, namespaceUri, elementName);
            ((ObjectModelBindingImpl)om).bindTop(clsBinding);
            return clsBinding;
        }

        public FieldBinding bindFieldToAttribute(FinalClassBinding cls, String fieldName, String namespaceUri, String attributeName) {
            FieldBindingImpl field = new FieldBindingImpl(cls, fieldName);
            this.bindSimpleValue(field, namespaceUri, attributeName);
            ((FinalClassBindingImpl)cls).bindFieldToAttribute(field);
            return field;
        }

        public FieldBinding bindField(FinalClassBinding cls, String fieldName) {
            FieldBindingImpl field = new FieldBindingImpl(cls, fieldName);
            ((FinalClassBindingImpl)cls).bindFieldGroup(field);
            return field;
        }

        public FieldBinding bindField(NonFinalClassBinding cls, String fieldName) {
            FieldBindingImpl field = new FieldBindingImpl(cls, fieldName);
            ((NonFinalClassBindingImpl)cls).bindFieldGroup(field);
            return field;
        }

        public FieldGroupSequenceBinding bindFieldGroupSequence(FinalClassBinding cls) {
            FieldGroupSequenceBindingImpl seq = new FieldGroupSequenceBindingImpl(cls);
            ((FinalClassBindingImpl)cls).bindFieldGroup(seq);
            return seq;
        }

        public FieldGroupSequenceBinding bindFieldGroupSequence(NonFinalClassBinding cls) {
            FieldGroupSequenceBindingImpl seq = new FieldGroupSequenceBindingImpl(cls);
            ((NonFinalClassBindingImpl)cls).bindFieldGroup(seq);
            return seq;
        }

        public FieldGroupChoiceBinding bindFieldGroupChoice(FinalClassBinding cls) {
            FieldGroupChoiceBindingImpl choice = new FieldGroupChoiceBindingImpl(cls);
            ((FinalClassBindingImpl)cls).bindFieldGroup(choice);
            return choice;
        }

        public FieldGroupChoiceBinding bindFieldGroupChoice(NonFinalClassBinding cls) {
            FieldGroupChoiceBindingImpl choice = new FieldGroupChoiceBindingImpl(cls);
            ((NonFinalClassBindingImpl)cls).bindFieldGroup(choice);
            return choice;
        }

        public FieldGroupSequenceBinding bindFieldGroupSequence(FieldGroupBinding group) {
            FieldGroupSequenceBindingImpl seq = new FieldGroupSequenceBindingImpl(group.getDeclaringClassBinding());
            this.bindFieldGroup(group, seq);
            return seq;
        }

        public FieldGroupChoiceBinding bindFieldGroupChoice(FieldGroupBinding group) {
            FieldGroupChoiceBindingImpl choice = new FieldGroupChoiceBindingImpl(group.getDeclaringClassBinding());
            this.bindFieldGroup(group, choice);
            return choice;
        }

        public FieldBinding bindField(FieldGroupBinding group, String fieldName) {
            FieldBindingImpl field = new FieldBindingImpl(group.getDeclaringClassBinding(), fieldName);
            this.bindFieldGroup(group, field);
            return field;
        }

        public SimpleValueBinding bindSimpleValue(FieldBinding field, String namespaceUri, String elementName) {
            SimpleValueBindingImpl value = new SimpleValueBindingImpl(field, field.getFieldType(), namespaceUri, elementName);
            ((FieldBindingImpl)field).bindValue(value);
            return value;
        }

        public FinalClassBinding bindFinalClassValue(FieldBinding field, String namespaceUri, String elementName) {
            FinalClassBindingImpl value = new FinalClassBindingImpl(field, field.getFieldType(), namespaceUri, elementName);
            ((FieldBindingImpl)field).bindValue(value);
            return value;
        }

        public NonFinalClassBinding bindNonFinalClassValue(FieldBinding field) {
            NonFinalClassBindingImpl value = new NonFinalClassBindingImpl(field, field.getFieldType());
            ((FieldBindingImpl)field).bindValue(value);
            return value;
        }

        public NonFinalClassBinding bindNonFinalClass(NonFinalClassBinding parentClass, Class subclass) {
            NonFinalClassBindingImpl parent = (NonFinalClassBindingImpl)parentClass;
            NonFinalClassBindingImpl subclassBinding = new NonFinalClassBindingImpl(parentClass.getFieldBinding(), subclass, parent.fieldGroups, parent.fieldToAttribute);
            parent.bindSubclass(subclassBinding);
            return subclassBinding;
        }

        public FinalClassBinding bindFinalClass(NonFinalClassBinding parentClass, Class subclass, String namespaceUri, String elementName) {
            NonFinalClassBindingImpl parent = (NonFinalClassBindingImpl)parentClass;
            FinalClassBindingImpl subclassBinding = new FinalClassBindingImpl(parentClass.getFieldBinding(), subclass, namespaceUri, elementName, parent.fieldGroups, parent.fieldToAttribute);
            parent.bindSubclass(subclassBinding);
            return subclassBinding;
        }

        public CollectionBinding bindCollectionValue(FieldBinding field, String namespaceUri, String elementName) {
            CollectionBindingImpl value = new CollectionBindingImpl(field, field.getFieldType(), namespaceUri, elementName);
            ((FieldBindingImpl)field).bindValue(value);
            return value;
        }

        public NonFinalClassBinding bindNonFinalItem(CollectionBinding col, Class itemClass) {
            NonFinalClassBindingImpl item = new NonFinalClassBindingImpl(null, itemClass);
            ((CollectionBindingImpl)col).bindItem(item);
            return item;
        }

        public FinalClassBinding bindFinalItem(CollectionBinding col, Class itemClass, String namespaceUri, String elementName) {
            FinalClassBindingImpl item = new FinalClassBindingImpl(null, itemClass, namespaceUri, elementName);
            ((CollectionBindingImpl)col).bindItem(item);
            return item;
        }

        public SimpleValueBinding bindSimpleItem(CollectionBinding col, Class itemClass, String namespaceUri, String elementName) {
            SimpleValueBindingImpl item = new SimpleValueBindingImpl(null, itemClass, namespaceUri, elementName);
            ((CollectionBindingImpl)col).bindItem(item);
            return item;
        }

        public NonFinalClassBinding bindNonFinalClass(ObjectModelBinding om, Class cls) {
            NonFinalClassBindingImpl clsBinding = new NonFinalClassBindingImpl(null, cls);
            ((ObjectModelBindingImpl)om).bindTop(clsBinding);
            return clsBinding;
        }

        private void bindFieldGroup(FieldGroupBinding group, FieldGroupBinding subgroup) {
            switch (group.getCategory()) {
                case 0: {
                    ((FieldGroupSequenceBindingImpl)group).bindGroup(subgroup);
                    break;
                }
                case 1: {
                    ((FieldGroupChoiceBindingImpl)group).bindGroup(subgroup);
                    break;
                }
                case 2: {
                    throw new JBossXBRuntimeException("Field binding can't contain nested field groups!");
                }
                default: {
                    throw new JBossXBRuntimeException("Unexpected field group category: " + group.getCategory());
                }
            }
        }
    }
}

